#
# Makefile for BLANK
#
# $Revision:   1.4  $
#   $Author:   sisaac  $
#     $Date:   06 Apr 1992 11:50:52  $
#
#
# BLANK.MAK is the makefile for a template PENPOINT project. It is among
# a collection of POLYMAKE makefiles designed to standardize, automate,
# and simplify the process of building system or application code for
# PENPOINT. The build creates one .EXE file and/or .DLL file per project.
#
# Customizable build files used for a project:
#
#	MAKEFILE.MAK	This file, modified for a specific project
#	EXE.LBC		Exports for a project's .EXE
#	DLL.LBC		Exports for a project's .DLL
#   INIT.LBC       Exports for a project's initialization
#
# Standard build files for all projects:
#
#	DEFAULTS.MAK	Assigns default values to variables.
#	GO.MAK		Defines the standard rules for building a project.
#	UTIL.MAK  	Useful utilities to help manage a project.
#
# Files a build produces:
#
#	.DLL file 	Project DLL. Named as $(PROJ).DLL.
#	.LIB file 	Import library for $(PROJ).DLL.
#	.MPD file 	Map file for $(PROJ).DLL.
#	.EXE file 	Project EXE. Named as $(PROJ).EXE
#	.MPE file      Map file for $(PROJ).EXE.
#	*.OBJ files	Object file for each source file.
#	*.ERR		Compiler error file for each source file.
#
# To use BLANK.MAK, simply copy the file to a project directory, rename
# the file as MAKEFILE.MAK and change values to the following variables
# to values that describe your project. If your project is only building
# a .DLL file or only a .EXE file, you can just delete the unused variables
# from your makefile. All uncommented variables are required for a .EXE
# file and/or .DLL file.
#
# See DEFAULTS.MAK for other interesting variables you can override 
# in your makefile.
#
# See UTIL.MAK for some project management utilities (like 'make checkin').
#

#
# Project Name
#
# The project name must be the same name as the project directory name.
# The build uses this name to produce one .DLL file and/or .EXE file
# per project directory.  The project name is also used as the target 
# location in \PENPOINT for the project .DLL file and/or .EXE file.
#

PROJ		     =	blank

#
# Abbreviated Project Name (optional)
#
# This is an abbreviated project name, which is used during the build.
# This name must be six or less characters. It can be left emply if
# the project name is already six characters or less.
#
#
# PROJ_ABBREV        =    blank

#
# Project Owner
#
# Used in 'make netbackup' to copy project files to
# Z:\HOME\$(OWNER)\GO\SOURCE\$(HOME). You can modify your copy of
# UTIL.MAK to copy to a different location.
#

OWNER 		     = bldmstr

#
# Global Include Files (optional)
#
# List of .H files to be copied to \...\PENPOINT\SDK\INC when your project
# is built. These are class definitions that any project can use
# from this project.
#
#
# INCS		     = 

#
# Global GO Internal Include Files (optional)
#
# List of .H files to be copied to \...\GO\PINC when your project
# is built. These are class definitions that other GO projects will need
# from this project.
#
#
# PINCS		     = 

#
# Local Include Files
#
# List of .H files specifically for the given project.
#

LINCS	     	=    blank.h

#
# INIT Loader Name
#
# Name used to load INIT. This name is placed into the INIT.DLL file at
# link time. The format is GO-<project>-V<major version>(<minor version>).
#
#
# INIT_LNAME	     =	go-blank_init-v1(0)

#
# DLL Loader Name
#
# Name used to load DLL. This name is placed into the .DLL file at
# link time. The format is GO-<project>-V<major version>(<minor version>).
#
#
# DLL_LNAME	     =	go-blank_dll-v1(0)

#
# DLL Type (optional)
#
# Type of DLL to be built. Defines where to place the .DLL file and
# .MPD file. The default is app.
#
#   app	     		puts files into \...\PENPOINT\APP\$(PROJ)
#   distributed		puts files into \...\PENPOINT\SDK\DLL\$(PROJ)
#   service    		puts files into \...\PENPOINT\SERVICE\$(PROJ)
#   system  		puts files into \...\PENPOINT\BOOT\DLL
#   distributed_service puts files into \...\PENPOINT\SDK\SERVICE\$(PROJ)
#
# DLL_TYPE    	=

#
# DLL Source Files
#
# List of .C or .ASM files to build .DLL file.
#
#
# DLL_SRCS      	= blnk_dll.c

#
# DLL Libraries
#
# List of .LIB files to link with when building .DLL file
#
#
# DLL_LIBS	          = penpoint.lib

#
# EXE Loader Name
#
# Name used to load EXE. This name is placed into the .EXE file at
# link time. The format is GO-<project>-V<major version>(<minor version>).
#
#
# EXE_LNAME	     =	go-blank-v1(0)

#
# EXE Type (optional)
#
# Type of EXE to be built. Defines where to place the .EXE file and
# .MPE file. The default is app.
#
# 	app  		puts files into \...\PENPOINT\APP\$(PROJ)
# 	distributed	puts files into \...\PENPOINT\SDK\APP\$(PROJ)
# 	system		puts files into \...\PENPOINT\BOOT\APP\$(PROJ)
#
#
# EXE_TYPE    	=

#
# EXE Source Files
#
# List of .C or .ASM files to build .EXE file.
#
#
# EXE_SRCS	          = blank.c

#
# EXE Libraries
#
# List of .LIB files to link with when building .EXE file.
#
#
# EXE_LIBS	          = penpoint.lib misc.lib app.lib

#
# Distributed .DLL List (optional)
#
# List of .DLL files to get from \...\PENPOINT\SDK\DLL\$(PROJ). These are 
# .DLLs that were built in other projects. This list should be 
# composed of project \ .DLL file pairs, for example: 
# DISTRIBUTED_DLLS = grafpapr\grafpapr.dll atp\flap.dll
#
#
# DISTRIBUTED_DLLS = 

#
# Distributed Application List (optional)
#
# List of applications to get from \...\PENPOINT\SDK\APP\$(PROJ). These are 
# applications that were built in other projects. This list should be 
# composed of application names, for example: 
# DISTRIBUTED_APPS = obxwrap subapp1
#
#
# DISTRIBUTED_APPS = 

#
# Distributed Service List (optional)
#
# List of services to get from \...\PENPOINT\SDK\APP\$(PROJ). These are 
# services that were built in other projects. This list should be 
# composed of service names, for example: 
# DISTRIBUTED_SERVICES = hslink atp
#
#
# DISTRIBUTED_SERVICES = 

# Penpoint Name (optional)
#
# PENPOINT name for your application. This name can be up to 32
# characters, have upper/lower case, spaces and special characters.
#
# EXE_NAME    	= 

# Installer Version Number (optional)
#
# Version for your application. This is the version string seen by the
# PENPOINT installer (not to be confused with the source code control
# version!)
#
# APP_VERSION 	=

# Service Name (optional)
#
# PENPOINT name for your service. This name can be up to 32 characters,
# have upper/lower case, spaces and special characters.
#
# SERVICE_NAME 	= 

# Installer Version Number (optional)
#
# Version for your service. This is the version string seen by the
# PENPOINT installer (not to be confused with the source code control
# version!)
#
# SERVICE_VERSION  =

# Service Type (optional)
#
# Service type name. This is the type of your service, as seen by the
# installer. Examples: Printer, E-Mail, Database.
#
# SERVICE_TYPE 	= 

# Service Resource File (optional)
#
# Resources that are generated with the resource compiler from the
# .RC files listed. The resources file SERVICE.RES is placed in the
# same directory as the service.
#
# SERVICE_RC       =

# Include standard rules.
.INCLUDE $(MAKEFILE_PATH)\go.mak

# Your file dependencies here...

# blank.obj     : blank.c blank.h
