################################################################
#
# One of a few Awk programs used by gensyms.bat.  
# See documentation there.
#
################################################################
BEGIN {
	tag=ARGV[1]
	ARGV[1]=""

	printf "SYM_TAG=%s\n", tag
	ltag = tolower(tag)
	ftag = sprintf("%s%s", toupper(substr(tag,1,1)), tolower(substr(tag,2)))

	while (0 < getline < "gensyms.t1") {
		sub("\"", "<")
		sub("\"", ">")
		sub("#include.*\\\\", "#include <")
		print > "gensyms.t1"
	}

	printf "\nconst CLS_SYM_STS %sStsSymbols[] = {\n",ltag >> "gensyms.t1"
	printf "\nconst CLS_SYM_MSG %sMsgSymbols[] = {\n",ltag >> "gensyms.t2"
	printf "\nconst CLS_SYM_OBJ %sObjSymbols[] = {\n",ltag >> "gensyms.t3"

}

/^[[:space:]]*#define[[:space:]]+[[:alnum:]]+[[:space:]]+.*Make(Status|NonErr|Warning)/ {
	print  "  "    $2    ",\t"    "\""    $2    "\""    "," >> "gensyms.t1"
	next
	}
/^[[:space:]]*#define[[:space:]]+[[:alnum:]]+[[:space:]]+.*Make(Msg|Tag)/ {
	print  "  "    $2    ",\t"    "\""    $2    "\""    "," >> "gensyms.t2"
	next
	}
/^[[:space:]]*#define[[:space:]]+[[:alnum:]]+[[:space:]]+.*Make(GlobalWKN|LocalWKN|PrivateWKN|WKN)/ {
	print  "  "    $2    ",\t"    "\""    $2    "\""    "," >> "gensyms.t3"
	next
	}

END {
	print "  0, 0};" >> "gensyms.t1"
	print "  0, 0};" >> "gensyms.t2"
	print "  0, 0};" >> "gensyms.t3"
	printf "\nSTATUS EXPORTED %sSymbolsInit(void)",
		ftag >> "gensyms.t3"
	printf "\n{\n\treturn ClsSymbolsInit(\n" >> "gensyms.t3"
	printf "\t\t\t\"%s\",\n",tag >> "gensyms.t3"
	printf "\t\t\t%sObjSymbols,\n",ltag >> "gensyms.t3"
	printf "\t\t\t%sMsgSymbols,\n",ltag >> "gensyms.t3"
	printf "\t\t\t%sStsSymbols);\n}",ltag >> "gensyms.t3"
	printf "\n#else" >> "gensyms.t3"
	printf "\n#include <go.h>" >> "gensyms.t3"
	printf "\nSTATUS EXPORTED %sSymbolsInit(void)",
		ftag >> "gensyms.t3"
	printf "\n{\n\treturn stsOK;\n}" >> "gensyms.t3"
	printf "\n#endif\n" >> "gensyms.t3"

	printf "Creating s_%s.c\n", ltag

}
