"64180"
                GLB     Msgs,Init,Cmd_Input,Msg_Dest
                DATA
Msgs
Msg_A           DB      "Command A entered "
Msg_B           DB      "Entered B command "
Msg_I           DB      "Invalid Command "
End_Msgs

                ORG     0000H
                JP      Init

                PROG
****************************************************
* The following instructions set up the stack
* pointer.
****************************************************
Init            LD      SP,Stk

****************************************************
* Clear previous command.
****************************************************
Read_Cmd        LD      A,0
                LD      [Cmd_Input],A

****************************************************
* Read command input byte.  If no command has been
* entered, continue to scan for command input.
****************************************************
Scan            LD      A,[Cmd_Input]
                CP      0
                JR      Z,Scan

****************************************************
* A command has been entered.  Check if it is
* command A, command B, or invalid.
****************************************************
Exe_Cmd         CP      41H
                JR      Z,Cmd_A
                CP      42H
                JR      Z,Cmd_B
                JP      Cmd_I
****************************************************
* Command A is entered.  BC = the number of bytes in
* message A.  HL = location of the message. Jump to
* the routine which writes the message.
****************************************************
Cmd_A           LD      BC,Msg_B-Msg_A
                LD      HL,Msg_A
                JP      Write_Msg
****************************************************
* Command B is entered.
****************************************************
Cmd_B           LD      BC,Msg_I-Msg_B
                LD      HL,Msg_B
                JP      Write_Msg
****************************************************
* An invalid command is entered.
****************************************************
Cmd_I           LD      BC,End_Msgs-Msg_I
                LD      HL,Msg_I
****************************************************
* Message is written to the destination.
****************************************************
Write_Msg       LD      DE,Msg_Dest
                LDIR
****************************************************
* The rest of the destination area is filled
* with zeros.
****************************************************
Fill_Dest       LD      HL,Msg_Dest+20H
                SBC     HL,DE
                LD      B,L
                LD      A,0
Fill_Loop       LD      [DE],A
                INC     DE
                DJNZ    Fill_Loop

****************************************************
* Go back and scan for next command.
****************************************************
                JP      Read_Cmd

                COMN
****************************************************
* Command input byte.
****************************************************
Cmd_Input       DB      0
****************************************************
* Destination of the command messages.
****************************************************
Msg_Dest        DS      0FFH,0
Stk             DS      1,0      ; Stack area.
          END     Init
