                .file   "cmd_rds.s"

                .equ    Dest_Size,0x30
                .equ    Stack_Size,0x100

                  .globl  Command_Input, Init, Message_Dest
                .data   "sbt" (RW) >0x00000000
                .org    .+0x34
                .word   Dummy_Text

                .text (RX) >0x00010000
                .align  4

Init:           mov.w   #Stack+Stack_Size,sp
                movea.w Command_Input,r0
                movea.w Message_Dest,r1
                mov.b   #' ',r26

Clear:          mov.b   #0x00,[r0]

Read_Input:     mov.b   [r0],r2
                cmp.b   #0x00,r2
                je      Read_Input

Process_Comm:   cmp.b   #'A',r2
                je      Command_A
                cmp.b   #'B',r2
                je      Command_B
                jr      Unrecognized

Command_A:      movea.w Message_A,r3
                mov.w   #Message_B-Message_A,r4
                jr      Output

Command_B:      movea.w Message_B,r3
                mov.w   #Invalid_Input-Message_B,r4
                jr      Output

Unrecognized:   movea.w Invalid_Input,r3
                mov.w   #Message_End-Invalid_Input,r4

Output:         movcfu.b [r3],r4,Message_Dest,#Dest_Size
Text_End:       jr      Clear

Dummy_Text:             halt


                .data (R) >0x00020000

Message_A:      .str    "THIS IS MESSAGE A"
Message_B:      .str    "THIS IS MESSAGE B"
Invalid_Input:  .str    "INVALID COMMAND"
Message_End:


                .bss (RW) >0x00030000
                .lcomm  Command_Input,  1,1
                .lcomm  Message_Dest,Dest_Size,4
                .lcomm  Stack,Stack_Size,4 

