                .file   "os.s"

                .equ    isp,0
                .equ    l0sp,1
                .equ    l1sp,2
                .equ    l2sp,3
                .equ    l3sp,4
                .equ    sbr,5
                .equ    tr,6
                .equ    sycw,7
                .equ    tkcw,8
                .equ    pir,9
                .equ    psw2,15
                .equ    atbr0,16
                .equ    atlr0,17
                .equ    atbr1,18
                .equ    atlr1,19
                .equ    atbr2,20
                .equ    atlr2,21
                .equ    atbr3,22
                .equ    atlr3,23
                .equ    trmod,24
                .equ    adtr0,25
                .equ    adtr1,26
                .equ    adtmr0,27
                .equ    adtmr1,28

                .equ    Stack_Size,0x1000
                .equ    Dest_Size,0x20

                .globl  Sys_SBT, Current_Task, Num_Of_Task, TCB_Entry, ATE0
                .globl  ATE1_A, ATE1_B, PTE0, PTE1_A, PTE1_B, Sys_Stack, Sys_Init
                .globl  Setup_Task, Start_Ini_Task, Sys_Trap, Switch_Task, Message_Dest



                .data   "sys_sbt" (RW) >0x00000000
Sys_SBT:
                .org    0x34
                .word   Dummy_Text
                .org    0xc0
                .word   Sys_Trap


                .data   "sys_tcb" (RW) >0x00001000
Current_Task:   .word   0
Num_Of_Task:    .word   2

TCB_Entry:      .word   TCB_A
                .word   0x7f000000
                .word   0x00000000
                .word   0x40000000
                .word   0x40002000
                .word   0


                .word   TCB_B
                .word   0x7f000000
                .word   0x00000000
                .word   0x40000000
                .word   0x40002000
                .word   0

TCB_A:          .word   0x0000e000
                .space  8*4
                .word   0x00002009,0x00000000

TCB_B:          .word   0x0000e000
                .space  8*4
                .word   0x00002011,0x00000000

                .data   "sys_ate" (RW) >0x00002000
ATE0:           .word   0x00003003,0x00000500

ATE1_A:         .word   0x00003103,0x00000300
ATE1_B:         .word   0x00003203,0x00000300

                .data   "sys_pte" (RW) >0x00003000
PTE0:           .word   0x00000e05
                .word   0x00001e05
                .word   0x00002e05
                .word   0x00003e05
                .word   0x00004e05
                .word   0x00005e05

                .org    0x100
PTE1_A:         .word   0x00007e05
                .word   0x00008e05
                .word   0x00009e05
                .word   0x00006e05

                .org    0x200
PTE1_B:         .word   0x0000ae05
                .word   0x0000be05
                .word   0x0000ce05
                .word   0x00006e05


                .bss    "sys_stk" (RW) >0x00004000
                .lcomm  Sys_Stack,Stack_Size,4


                .text   "sys_text" (RX) >0x00005000
                .align  4

Sys_Init:       mov.w   #Sys_Stack+Stack_Size,sp
                ldpr    #Sys_SBT,#sbr

                ldpr    #0x2001,#atbr0
                ldpr    #0x00000000,#atlr0
                ldpr    #0,#atbr1
                ldpr    #0,#atbr2
                ldpr    #0,#atbr3

                ldpr    #0x2171,#sycw

Setup_Task:     mov.w   Num_Of_Task,r0
                mov.w   #TCB_Entry,r1
Setup_Task_0:   ldtask  4[r1],[r1]
                mov.w   0x10[r1],r2
                mov.w   #0,[-r2]
                mov.w   8[r1],[-r2]
                mov.w   12[r1],[-r2]
                mov.w   r2,4[[r1]]
                add.w   #0x18,r1
                dbr     r0,Setup_Task_0

                ldtask  TCB_Entry+4,TCB_Entry
Start_Ini_Task: retis   #4

                .align  4
Sys_Trap:       mov.w   Current_Task,r0
                mov.w   r0,r2
                mul.w   #0x6,r2
                mov.w   #TCB_Entry,r1
                sttask  4[r1](r2)
                inc.w   r0
                cmp.w   r0,Num_Of_Task
                jnz     Sys_Trap_0
                xor.w   r0,r0
Sys_Trap_0:     mov.w   r0,Current_Task
                mul.w   #0x6,r0
                ldtask  4[r1](r0),[r1](r0)
Switch_Task:    retis   #4

Dummy_Text:     halt

                .bss    "shr_mem" (RW) >0x40003000
                .lcomm  Message_Dest, Dest_Size,4 

