"80C196"

			GLB		AX,BL,BH,CX,DX
************************************************************
* The following EQU instructions define the names
* of registers in the Internal Register file.
************************************************************
AX			EQU		1AH
BL			EQU		1CH
BH			EQU		1DH
CX			EQU		1EH
DX			EQU		20H

			ORG		500H
Msgs
Msg_A		DCB		"Command A entered "
Msg_B		DCB		"Entered B command "
Msg_I		DCB		"Invalid command "
End_Msgs
************************************************************
* Code at location 2080H is executed after reset.
************************************************************
			ORG		2080H
			LJMP		Init

			ORG		400H
************************************************************
* The following instructions set up the stack pointer and 
* load AX with the address of the Cmd_Input byte.
************************************************************
Init			LD		SP,#Stk
			LD		AX,#Cmd_Input
************************************************************
* Clear previous command.
************************************************************
Read_Cmd		LDB		BL,#0
			STB		BL,[AX]
************************************************************
* Read command input byte. If no command has been entered,
* continue to scan for command input.
************************************************************
Scan			LDB		BL,[AX]
			CMPB		BL,#0
			JE		Scan
************************************************************
* A command has been entered. Check if it is 
* command A, command B, or invalid.
************************************************************
Exe_Cmd		CMPB		BL,#41H
			JE		Cmd_A
			CMPB		BL,#42H
			JE		Cmd_B
			SJMP		Cmd_I
************************************************************
* Command A is entered. Set up registers BH and CX with
* the parameters expected by the "Write_Msg" routine.
* Call the routine. After return, go back and scan for
* next command.
************************************************************
Cmd_A		LDB		BH,#Msg_B-Msg_A
			LD		CX,#Msg_A
			SCALL	Write_Msg
			SJMP		Read_Cmd
************************************************************
* Command B is entered.
************************************************************
Cmd_B		LDB		BH,#Msg_I-Msg_B
			LD		CX,#Msg_B
			SCALL	Write_Msg
			SJMP		Read_Cmd
************************************************************
* An invalid command is entered.
************************************************************
Cmd_I		LDB		BH,#End_Msgs-Msg_I
			LD		CX,#Msg_I
			SCALL	Write_Msg
			SJMP		Read_Cmd
************************************************************
* The "Write_Msg" routine writes a message to the
* destination. The parameter passed in register BH=the
* number of bytes in the message. The parameter passed in
* register CX=the location of the message.
************************************************************
Write_Msg		LD		DX,#Msg_Dest
Again		LDB		BL,[CX]+
			STB		BL,[DX]+
			DBNZ		BH,Again
************************************************************
* The rest of the destination are is filled with zeros.
************************************************************
			LDB		BL,#0
Fill_Dest		STB		BL,[DX]+
			CMPB		DX,#Msg_Dest+20H
			JNE		Fill_Dest
			RET

			ORG		600H
************************************************************
* Command input byte.
************************************************************
Cmd_Input		DSB		1
************************************************************
* Destination of the command messages.
************************************************************
Msg_Dest		DSB		0FBH
Stk			DSW		1		; Stack area.
			END		Init
