/* "NS 32532 DEMONSTRATION PROGRAM" */
/* "demo532.c" */

/* DEFINES */
#define TRUE          0x1
#define FALSE         0x0
#define NO_CMD        0x0
#define NEW_CMD       0x2
#define CMD_STARTED   0x4
#define CMD_FINISHED  0x8
#define CMD_A         0x10
#define CMD_B         0x20
#define CMD_C         0x30

/**************************************************************************/
main ()

{
  unsigned char *semaphore;
  unsigned char *cmd_code;
  unsigned char *cmd_result;
  
  /* initialize control variables - pointer values */
  semaphore = (unsigned char *) 0x400;
  cmd_code = (unsigned char *) 0x401;
  cmd_result = (unsigned char *) 0x402;

  *semaphore = NO_CMD;
  *cmd_code = NO_CMD;
  *cmd_result = '\0';

  /* Call command loop function */
  cmd_loop (semaphore, cmd_code, cmd_result);

}   /* main */
/**************************************************************************/

/**************************************************************************/
cmd_loop (semaphore, cmd_code, cmd_result)
  unsigned char *semaphore;
  unsigned char *cmd_code;
  unsigned char *cmd_result;
  
{
  /* Stay in endless loop, checking for a new command */
  /* When a new command is detected, it is executed */
  /* New command can be entered using */
  /* m -db 401=20    (place the value CMD_B in cmd_code memory location) */
  /* m -db 400=2     (place the value NEW_CMD in semaphore memory location) */
  /* m -db 402       (to display command result) */

  while (TRUE) {
    if (*semaphore == NEW_CMD) {
      *semaphore = CMD_STARTED;
      switch (*cmd_code) {
	case CMD_A :
	  *cmd_result = 'A';
	  break;

	case CMD_B :
	  *cmd_result = 'B';
	  break;

	case CMD_C :
	  *cmd_result = 'C';
	  break;

        default :
	  *cmd_result = '\0';
      }   /* switch */

      *semaphore = CMD_FINISHED;

    }   /* if (semaphore == NEW_CMD) body */
  }   /* while (TRUE) loop */
}   /* FUNCTION cmd_loop */
/**************************************************************************/

