/********************************************************
 *                          							*
 *	FILE:	crt0_32c.s		                    		*
 *							                            *
 *	DESCRIPTION:	startup file for dcc generated	    *
 *			DSP32 programs.			                    *
 *							                            *
 ********************************************************/

#define	sp	r14e		/* stack pointer */
#define	rp	r18			/* return pointer */
#define	rpe	r18e		/* return pointer */
#define	ir	r19			/* increment register */

#define	STACK_INC	4	/* stack increment */

	.rsect	".text"
	.global	__start
	.global	__end
	.global	errno
    .extern main
    .extern sioin_int
    .extern sioout_int

	.align	4

__start:
    nop
    nop
	dauc = 0x0c	        /* Set round to int */
	ioc = 0x0cc5		/* Disable any Serial DMAs	*/
	sp = _stack		    /* Stack is empty at bottom	*/
	ir = STACK_INC		/* stack increment */
	r22e = ivt		    /* Interrupt vector table pointer */
    r1 = 0x80c0         /* PCW register */
    nop
    pcw = r1
    nop
    nop
	call main (rp)		/* Nothing else to do now	*/
	rpe = . + 4		    /* to get around call bug in 32c rev 2.0 */

	r1 = 0
	pdr = r1		    /* exit (0) */
__end:
	goto	__end
	nop

/* Interrupt pointer table */
ivt:
    fltbits 0x0a0001180 /* External interrupt 1 (Monitor @ 1000h) */
    nop
    ireturn             /* PIO buffer full */
    nop
    ireturn             /* PIO buffer empty */
    nop
    goto __int_sio_in   /* SIO input buffer full */
    nop
    goto __int_sio_out  /* SIO output buffer empty */
    nop
    goto __ext_int2     /* External interrupt 2 */
    nop

/* Interrupt Service Routines */

__ext_int1:  /* External interrupt 1 */
    ireturn
    nop

__ext_int2:  /* External interrupt 2 */
    ireturn
    nop

__int_sio_in:  /* input from sio */
    call sioin_int(rp)
    ireturn
    nop

__int_sio_out: /* output from sio */
    call sioout_int(rp)
    ireturn
    nop

	.rsect	".data"
errno:	int

	.rsect	".bss"
_stack:	256 * byte
