/* "NS 32000 DEMONSTRATION PROGRAM" */
/* "demo.c" */

/* INCLUDES */
#include <strings.h>   /* 32000 Library */

/* DEFINES */
#define TRUE          1
#define FALSE         0
#define NOCMD        'F'
#define NEWCMD       'T'
#define CMDSTARTED   'S'
#define CMDFINISHED  'F'
#define CMDA         'A' 
#define CMDB         'B' 
#define CMDC         'C' 

/* Using data space for variables - allows use of symbols */
static unsigned char status [] = "                       ";

/* Declare external functions */
extern int setupmachine ();
extern int programstack;
extern int intbasetable;

/* Declare forward function */
extern int cmdloop ();

/**************************************************************************/
main ()

{

  /* Variables are aligned to allow for a "nice" display */

  static unsigned char cmdresult [] = "-No command entered    ";
  static unsigned char semaphore = NOCMD;
  static unsigned char dummy [] = "      ";
  static unsigned char cmdcode = NOCMD;

  /* Initialize supervisor stack pointer */
  asm ("addr    %_programstack,r7");
  asm ("lprd    sp,r7");

  setupmachine ();

  semaphore = NOCMD;
  strcpy (cmdresult, "-No command entered    ");
  strcpy (status, "Awaiting command       ");

  /* Call command loop function */
  /* Variables are passed to illustrate the passing mechanism */
  cmdloop (&semaphore, &cmdcode, cmdresult);

}   /* main */
/**************************************************************************/

/**************************************************************************/
int
cmdloop (semaphore, cmdcode, cmdresult)
  unsigned char *semaphore;
  unsigned char *cmdcode;
  unsigned char *cmdresult;
  
{
  /* Stay in endless loop, checking for a new command */
  /* When a new command is detected, it is executed */
  /* New command can be entered using the following: *

     Terminal Interface:
       demo
       r
       m -db cmdresult
         000000c18..000000c18@s=2d
       m cmdcode=cmdb
       m semaphore=newcmd
       m cmdresult
         000000c18..000000c18@s=42

     Softkey Interface
       load demo
       modify register intbase to _intbasetable
       display local_symbols_in demo.c:
       display memory _status thru _cmdcode repeatively bytes
       run from transfer_address
       modify memory _cmdcode bytes to 42h
       modify memory _semaphore bytes to 54h

     PC Interface :

  */

  while (TRUE) {
    if (*semaphore == NEWCMD) {
      *semaphore = CMDSTARTED;
      strcpy (status, "Command received       ");
      switch (*cmdcode) {
	case CMDA :
          strcpy (cmdresult, "A command entered      ");
	  break;

	case CMDB :
          strcpy (cmdresult, "B command entered      ");
	  break;

	case CMDC :
          strcpy (cmdresult, "C command entered      ");
	  break;

        default :
          strcpy (cmdresult, "? Invalid command      ");
      }   /* switch */

      *semaphore = CMDFINISHED;

    }   /* if (semaphore == NEWCMD) body */
  }   /* while (TRUE) loop */
}   /* FUNCTION cmdloop */
/**************************************************************************/
