	.file "setup.s"

	.globl _setupmachine
	.globl _programstack
	.globl _intbasetable 

	.text
	.align 4
_setupmachine:

	# Initialize the exception base table register
	# Table is set up for module exception mode
	addr    %_intbasetable,r7
	lprd    intbase,r7

	# Configure for module exception mode
	setcfg []

	# Enable maskable interrupts
	bispsrw  $(0x800)
	ret    $0

#***************************************************************************#
# FUNCTION 

_exception_function:
	enter   [r0,r1],0
	movd    $(0),r1
	cmpd	$(2000000),r1
	bls	.LL0
.LL1:
	addqd	$(1),r1
	cmpd	$(2000000),r1
	bhi	.LL1
.LL0:

	exit    [r0,r1]
	reti
#***************************************************************************#

	.data
	.align 4
        # 284 byte supervisor stack
        .space 284     
_programstack:

	.align 4
	# Exception Dispatch Table
_intbasetable:
        .word   MOD_TABLE             # NVI Vector
	.word   0
	.word   MOD_TABLE             # NMI Vector
	.word   0
        .word   MOD_TABLE             # NVI Vector
	.word   0
	.word   MOD_TABLE             # ABT Vector
	.word   0
	.word   MOD_TABLE             # SLAVE Vector
	.word   0
	.word   MOD_TABLE             # ILL Vector
	.word   0
	.word   MOD_TABLE             # SVC Vector
	.word   0
	.word   MOD_TABLE             # DVZ Vector
	.word   0
	.word   MOD_TABLE             # FLG Vector
	.word   0
	.word   MOD_TABLE             # BPT Vector
	.word   0
	.word   MOD_TABLE             # TRC Vector
	.word   0
	.word   MOD_TABLE             # UND Vector
	.word   0

	.align 4
MOD_TABLE:
	.double   0
	.double   0
	.double   _exception_function
