"TI32025"
;*************************************************
; In these example programs, a block of data from
; 410..41FH (SRC1) is copied to 420..42FH (DEST)
; and a block of data from 400..40FH (SRC2) is
; copied to DEST.
;*************************************************

          NAME      'prog1'        ; name of this example program

          EXT       DEST           ; DEST,SRC1, and SRC2 are global
          EXT       SRC1
          GLB       SRC2

          AORG      0              ; absolute origin of the program is
                                   ; at address 0.

          B         START          ; Branch to START

          PROG

START                              ; Start of program
          LRLK      AR0,DEST       ; destination memory pointer
          LRLK      AR1,SRC1       ; source memory pointer
          LARK      AR3,0FH        ; loop counter

          LARP      AR1            ; load auxiliary register pointer

LOOP1                              
          LAC       *+,0,AR0       ; load accumulator from source pointer
          SACL      *+,0,AR3       ; store accumulator to destination pointer
          BANZ      LOOP1,*-,AR1   ; loop until AR0=3

          LRLK      AR2,SRC2       ; source memory pointer
          LRLK      AR0,DEST       ; destination memory pointer
          LARK      AR3,0FH        ; loop counter continues until data is
                                   ; loaded

          LARP      AR2            ; load auxiliary register pointer

LOOP2
          LAC       *+,0,AR0       ; load accumulator
          SACL      *+,0,AR3       ; store accumulator
          BANZ      LOOP2,*-,AR2   ; loop until AR3=0
          
          B         START          ; branch to START

          DATA                     ; data segment of program

SRC2
          DW        0fH,0eH,0dH,0cH     ; data
          DW        0bH,0aH,9,8         ; data
          DW        7,6,5,4             ; data
          DW        3,2,1,0             ; data

          END       START