"80186"
                GLB     Msgs,Init,Cmd_Input,Msg_Dest
                ORG      500H
Msgs
Msg_A           DB      "Command A entered "
Msg_B           DB      "Entered B command "
Msg_I           DB      "Invalid Command "
End_Msgs

                ORG      400H
                ASSUME  DS:ORG,ES:ORG
****************************************************
* The following instructions initialize segment
* registers and set up the stack pointer.
****************************************************
Init            MOV     AX,SEG Msg_A
                MOV     DS,AX
                MOV     AX,SEG Cmd_Input
                MOV     ES,AX
                MOV     SS,AX
                MOV     SP,OFFSET Stk
****************************************************
* Clear previous command.
****************************************************
Read_Cmd        MOV     Cmd_Input,#0
****************************************************
* Read command input byte.  If no command has been
* entered, continue to scan for command input.
****************************************************
Scan            MOV     AL,Cmd_Input
                CMP     AL,#0
                JE      Scan
****************************************************
* A command has been entered.  Check if it is
* command A, command B, or invalid.
****************************************************
Exe_Cmd         CMP     AL,#41H
                JE      Cmd_A
                CMP     AL,#42H
                JE      Cmd_B
                JMP     Cmd_I
****************************************************
* Command A is entered.  CX = the number of bytes in
* message A.  SI = location of the message.  Jump to
* the routine which writes the messages.
****************************************************
Cmd_A           MOV     CX,#Msg_B-Msg_A
                MOV     SI,OFFSET Msg_A
                JMP     Write_Msg
****************************************************
* Command B is entered.
****************************************************
Cmd_B           MOV     CX,#Msg_I-Msg_B
                MOV     SI,OFFSET Msg_B
                JMP     Write_Msg
****************************************************
* An invalid command is entered.
****************************************************
Cmd_I           MOV     CX,#End_Msgs-Msg_I
                MOV     SI,OFFSET Msg_I
****************************************************
* Message is written to the destination.
****************************************************
Write_Msg       LEA     DI,Msg_Dest
            REP MOVSB
****************************************************
* The rest of the destination area is filled
* with zeros.
****************************************************
Fill_Dest       MOV     BYTE PTR [DI],#0
                INC     DI
                CMP     DI,#Msg_Dest+20H
                JNE     Fill_Dest
****************************************************
* Go back and scan for next command.
****************************************************
                JMP     Read_Cmd

                ORG      600H
****************************************************
* Command input byte.
****************************************************
Cmd_Input       DBS     1
****************************************************
* Destination of the command messages.
****************************************************
Msg_Dest        DDS     3EH
Stk             DWS     1       ; Stack area.
                END     Init


