.SA 1
.mc |
.H 1 "		SRM-UX Server ERS - 2/21/90"
.mc
.SP
.H 2 "What is the SRM-UX Server?"
.SP
.P
The SRM-UX server is an HP Series 300 or 800 HP-UX system 
running an HP-UX program, 
/etc/srmd, which emulates the Shared Resource Manager (SRM) host. 
.SP
.H 2 "Hardware required"
.SP
.P
The SRM-UX server will run on any Series 300 or 800 machine which runs 
HP-UX and has a local disk.
(Diskless machines cannot be SRM-UX servers; the performance
would be worse than putting srmd directly on the cluster server, without
saving any significant loading of the cluster server. 
Also diskless machines would not be able to support remote booting 
over LAN cards.)
.P
The Series 300 server communicates with its clients via either 98643A LAN 
cards or 50962A or 98629A SRM cards (actually all flavors of SRM cards 
and SRM wires are supported).  
LAN cards provide increased bandwidth compared to the SRM cards.
An existing SRM network could replace its current SRM host with a Series 300
HP-UX machine, and no other hardware changes would be required.
A server may support both LAN and SRM cards simultaneously.  Other networking
code may use the 98643A LAN card simultaneously with the SRM-UX server.
However the server acquires exclusive access to the 50962A SRM cards.
In particular, the existing srm utilities such as srmcp cannot be used on
the same SRM cards configured for use by the SRM-UX server.  (They may be 
used on SRM cards not used by the server.)
.P
Some Series 200 machines will have to interface to the 
server via SRM cards, because they don't support LAN cards.  LAN cards
are officially supported only in 226's and 236's.  Other Series 200 boxes
are not supported because they don't pass RFI testing.  The 216 power supply
cannot handle LAN cards.
.P
The Series 800 will be supported as an SRM-UX server.  It will
only be supported for LAN interfaces, because SRM card support is not
included in HP-UX on the Series 800.  
(Note that this means that some Series 200's could not use
a Series 800 as a server because there would be no way to connect them
together.)  
(Specific LAN interface card numbers in this ERS refer to Series 300 cards;
Series 800 LAN cards are implied as well unless specifically stated 
otherwise.)
.SP
.H 2 "Software required"
.SP
.P
The SRM-UX server will execute on HP-UX revisions 8.0 or later.  (8.0 is
required because srmd needs more than 60 open files per process in order
to support larger numbers of nodes, and because 8.0 SAM will allow the
addition of new modules which aren't hardwired into a monolithic SAM.)
The SRM-UX server will execute on top of an HP-UX 8.0 AXE system; this will
allow smaller disks on SRM-UX servers.
.SP
.H 2 "Functionality supported"
.SP
.P
SRM-UX is intended to be a functional replacement of the existing SRM.
Most of the existing SRM functionality is provided by the SRM-UX server;
other functionality is provided more directly by HP-UX, especially in
the areas of configuring and administering the server.  This is discussed
in the following sections in more detail.
.SP
.H 3 "Remote booting"
.SP
.P
SRM-UX will support booting of RMB and PAWS clients over either 98643A LAN
cards or 50962A SRM cards. Different mechanisms are used for each card.
The difference is transparent to the RMB and PAWS users.  
.SP
.P
All Series 200 and 300 machines can be booted from the 50962A SRM card
over SRM-UX. Some of the older BOOTROMs may not support booting from
the 50962A card, but all Series 200 and 300 machines can accept
BOOTROM upgrades to allow this (if a machine currently boots from an existing
SRM host, then it can boot from SRM-UX via an SRM card without changing
the BOOTROM).  Booting over SRM cards is completely
handled by the SRM-UX server.
.SP
.P
To the users, booting over LAN cards looks identical to booting over SRM
cards.  The same boot files can be used for either card.  Multiple boot
files can be specified for both RMB and PAWS over either card.
.P
All Series 300 machines will be able to
boot on the 98643A if they have Revision B or later BOOTROMs, and all
can be upgraded to Revision B BOOTROMs if needed.
However, no Series 200 machines will be able to boot over the 
98643A card, due to BOOTROM limitations.  (There is no possible upgrade for
this.)
When using the 98643A
LAN card, booting occurs through the HP-UX diskless boot mechanism, rbootd.  
The HP-UX system administrator must configure the HP-UX machine as a
diskless server to support this.  In addition, 
a small amount of extra administration is required 
in order to maintain information needed for RMB and PAWS diskless boot.
Otherwise, the mechanism is the same as for HP-UX diskless boot clients.
After booting is complete, control is passed off to the SRM-UX server.
.SP

.SP
.H 3 "HP-UX file system access"
.SP
.P
The SRM-UX server emulates SRM operations such as opening files,
reading and writing data to and from files, etc. by performing the
corresponding operations on the server's file system.
>From the RMB and PAWS clients' perspectives, most operations are
identical with the existing SRM.
.SP
.H 4 "Password/Access Control Schemes"
.SP
.P
The main difference between SRM-UX and SRM involves control of file access.
SRM uses a password-per-file scheme, with each password
controlling up to 6 different properties. The SRM control properties
are unrelated to the HP-UX read/write/execute properties. SRM also
supports multiple passwords per file or directory, each with different
property control sets.
.SP
.P
HP-UX's user/group/other-read/write/execute permission set is the one
that must be observed by srmd for protection of the HP-UX users and
processes running on the server machine.  There is no good mapping
of the SRM passwords onto the HP-UX scheme.
.SP
.P
Instead, SRM-UX will employ the native HP-UX permissions. A model
for this in both PAWS and RMB exists in the HFS local file system
drivers for each, introduced in PAWS revision 3.2, and RMB revision
5.0. The model seems satisfactory.  Some existing
SRM-based applications which use SRM-style passwords may need to be 
modified to port to SRM-UX.  It is believed that most applications do
not use SRM-style passwords, and will not need to be modified to run on
SRM-UX.
.P
The server will give an error on receiving a "change protect codes"
packet (used by the RMB PROTECT statement).  The server will ignore SRM
passwords specified in path names used for ordinary file access operations,
which will minimize the application changes required by not supporting
SRM style passwords.
.P
In addition, SRM-UX provides a subtree mechanism,
whereby the RMB or PAWS client sees only a subtree of the HP-UX file system
mount tree, and cannot go above the root of that tree.  Both access
mechanisms are completely configurable by the SRM-UX administrator from
the srmd server machine; the clients are not involved in the configuration
of either access control mechanism.  
(The details of how this is accomplished are discussed in the 
SRM-UX Administrators section of the ERS.)
.SP
.H 4 "File Name Length"
.SP
.P
The SRM supports file names up to 16 characters long.  The default HFS file
system under HP-UX has 14 character file names.  However, an HFS volume
can be configured to support file names up to 255 characters long.  (SRM-UX
completely hides this configuration difference from the RMB and PAWS clients.)
This will allow all files from SRM to move to SRM-UX.  The server will hide
file names longer than 16 characters from the clients. 
(The underlying SRM packets support only 16 characters for each component 
of a path name, and the clients would have to be extensively modified to
handle longer names.)  Therefore, HP-UX applications must restrict 
themselves to file names of 16 characters or less for files they share 
directly with RMB or PAWS.
(Note that HFS disks configured for long file names
cannot be connected directly to RMB or PAWS systems because their HFS 
drivers support only short file name HFS disks.)
.SP
.H 4 "Volume Labels"
.SP
.P
The SRM-UX server will give an error on receiving a "change volume name"
packet (used by the RMB PRINT LABEL statement).  There is no mechanism for
the RMB or PAWS clients to change the emulated volume labels the server 
.mc |
obtains from /etc/srmdconf (described later in this ERS).
.mc
.SP
.H 4 "File Locking"
.SP
.P
The existing SRM implements file locking which allows one SRM client to 
lock out other clients from accessing a file.  The SRM-UX server will 
provide this same exact capability; that is, an SRM-UX client can lock
a file, and other SRM-UX clients will not be able to access it.  However,
the SRM-UX server will NOT prevent other HP-UX processes from accessing
the file.  The option of doing enforcement mode locking was examined,
but it does not work over NFS mounts.  Advisory mode locks are ignored by
many (perhaps most) existing HP-UX programs.  Therefore, applications
which wish to share files with HP-UX processes will have to use other ways
to cooperate.  (Example mechanisms include file ownership and permissions,
lock files, file names, and which directory contains the file. An HP-UX
application can do 'exclusive' opens to lock out SRM-UX clients; however,
the RMB ASSIGN statement does not have the capability to open a file
in 'exclusive' mode, so all RMB files are opened 'shared'.)
.SP
.H 3 "Accessing other remote file systems"
.SP
.P
The SRM-UX server, an HP-UX machine, has the ability to remote mount
file systems on other HP-UX and non-HP-UX machines. The tool
to achieve this is Network File System (NFS), an industry standard
networking solution.
.P
To provide remote file system access for SRM-UX, the root user must first
make sure that NFS is installed on the SRM-UX server machine.  After NFS is
installed, the root user, at any time, can mount remote file systems
for which the server has permission.  E.g.  in order to mount the
directory /users on the remote system hpxyzzy, and access it via the
local path /srmserve/usersxyzzy, make sure /srmserve/usersxyzzy exists
on the SRM-UX server (using mkdir to create directories), then execute:
.P
.nf
.mc |
mount hpxyzzy:/users /srmserve/usersxyzzy -t nfs
.mc
.fi
.P
Now, SRM-UX client workstations can access /users on xyzzy via path
/usersxyzzy on the volume associated with /srmserve. Note that
uids and gids should match on both the SRM-UX server and the remote
NFS-mounted machine, in order to minimize permissions confusion and
problems.  
.P
This capability is provided entirely by the HP-UX system on the SRM-UX 
server, and is completely transparent to the RMB and PAWS clients, and to
srmd itself.  
It provides access to both HP-UX and non-HP-UX machines, including 
machines which don't themselves support SRM-UX.  It is independent of 
which interface card, LAN or SRM, the client uses to access SRM-UX.
.SP
.H 3 "Spooling"
.SP
.P
The SRM-UX server will support printer/plotter spooling by using
the underlying HP-UX spooling functionality.  In addition a frontend to
lp will be supplied to pre-process RMB and PAWS file types, including
stripping off WS headers.  The operation of this frontend will be
transparent to the clients.
Therefore, PAWS and RMB users will be able to do spooling to SRM-UX 
exactly as they currently do for the existing SRM.
.SP
.H 3 "Server Administration"
.SP
.H 4 "Configuration"
.SP
.P
.mc |
Currently, configuration of the SRM-UX server prototype
is done HP-UX style,
.mc
by editing textual configuration files, starting up daemons, etc.
Although not complex compared to many HP-UX sysadmin tasks, it is
completely different than the existing SRM system administration, which is
done from the dedicated SRM console via menus and prompts.
.mc *
.mc
.P
.mc |
The product release of SRM-UX will use the HP-UX system admin tool,
SAM, to administer SRM-UX.  For all preliminary releases before the beta
site releases, the appropriate files
.mc
to be editted will be documented, as explained in the SRM-UX Administrator's
.mc |
Guide section of this ERS.  (The final product documentation will still
include a complete description of how to configure SRM-UX without using
SAM, for those users who prefer not to use SAM, or to help in case SAM
leaves the configuration in a bad state due to a defect in the way SRM-UX
uses SAM.)
.mc
.SP
.mc |
.H4 "Dynamic reconfiguration"
.SP
.P
Some configuration changes will be possible without requiring a shutdown
and restart of the server.  These changes will include adding new volumes,
adding new clients, and adding new spool directories.  Some kinds of 
changes will require doing an srmdreset (described later) on a particular
client before making configuration changes which impact that client.
.SP
.mc
.H 4 "Backup"
.SP
.P
The existing SRM front panel provides a backup facility.  SRM-UX will 
not provide a specific backup capability; instead the underlying HP-UX backup
facility can be used to provide whatever level of backup is required.
.mc *
.mc
.SP
.H 1 "	SRM-UX Administrator's Guide"
.SP
.P
Some terms need brief explanation:
.mc *
.mc
.P
SRM-UX client is a PAWS or RMB machine that "thinks" the SRM-UX is a real SRM.
.P
.mc |
SRM-UX server is an HP Series 300 or 800 HP-UX machine running a special application 
.mc
(srmd) that makes clients think they are speaking to a "real" SRM.
.P
Diskless hub is an HP-UX machine from which other HP-UX machines (or SRM-UX 
clients) can boot over LAN, and on which they can store their files.
.P
Root user or root is the system administrator for a machine running
HP-UX, and has special privileges and powers that other HP-UX users
do not. Root often maintains files that cannot be modified by other
users.  (The SRM-UX administrator will usually need to have root
user capability,
even if he is not the system administrator for the whole HP-UX
system which is acting as the SRM-UX server.)
.P
Link Address is a 6-byte (12-hex-digit) number stored in EPROM on each HP
LAN card, and unique to that card.
.P
Node Number is a 2-digit number settable with switches on the 50962A
SRM card.
.SP
.H 2 "Starting the server process"
.SP
.P
.mc |
The server is started up by invoking /etc/srmd.  (Note - only 1 instance
of srmd is allowed at a time.)  Typically, this will be
.mc
done by adding the following line to /etc/rc :

.nf
	/etc/srmd		# startup the SRM-UX server
.fi
.P
Some of the networking initialization needs to occur before
starting up /etc/srmd.  In the case where $state is "localroot", then this
line should be added between the lines which call csp_start and rbootd_start.
In the case where $state is "standalone", then this line should be added
immediately after the line which calls net_start.  Note that this 2nd case
cannot support booting over the LAN wire because rbootd will not be running
(all other SRM-UX functionality is supported in this case).
A machine with a $state of "remoteroot" is not supported as an SRM-UX server.
.SP
.H 2 "/etc/services file"
.SP
.P
If the SRM-UX server is to support LAN cards, then the following line
must be added to the list of services in /etc/services :

.nf
lansrm 		570/udp			# SRM-UX server
.fi

If the SRM-UX server will only be supporting SRM cards, then this is
not needed.
.SP
.H 2 "Booting from SRM-UX"
.SP
.P
Booting from SRM-UX using a 50962A SRM card is handled entirely by the
SRM-UX server, srmd.  Booting over an SRM card from SRM-UX is identical
to the current SRM, including search rules and locations for autostart files.
The server machine does not have to be configured as
a diskless hub server.
.P
However, booting from SRM-UX on a 98643A
LAN card is actually done using the HP-UX diskless boot daemon, rbootd.
.mc |
The HP-UX machine to be booted from must be an HP-UX 
.mc
diskless hub server, and must be running rbootd. SRM-UX can still be used
for file access and spooling if the server is not executing rbootd, but 
the client must boot elsewhere, either from a different remote system, or 
from a device local to the client such as a hard disc, or floppies.
.SP
.H 3 "/etc/boottab"
.SP
.P
There is a configuration file for rbootd, administered by the root user
on the diskless hub server. It is called /etc/boottab. 
.SP
.H 4 "Booting RMB"
.P
To be able to boot RMB correctly from the SRM-UX server over LAN, a line 
similar to that below must be added to /etc/boottab :
.SP
.nf
basic-srm:HPS300::SYSTEM_BAS:dummy
.fi
.P
The fields in this line are separated by colons.  Some fields allow multiple
items, which are separated by commas.
.mc |
The first field, basic-srm, tells rbootd that the file /etc/srmdconf
.mc
(discussed below) exists and should be processed. Rbootd will cooperate
with srmd to ensure that the boot volume stays on-line for the client 
if the above line is present in /etc/boottab.
The next field is machine type. The only legal value for SRM-UX here is HPS300.
The next field is empty.
.P
The next field is a list of one or more boot files. (Multiple files are
separated by commas.) These files
must be in directory /SYSTEMS on volume 8 as declared in the 
.mc |
SRM-UX /etc/srmdconf file (described in the next section of the ERS). 
.mc
Volume 8 is the only place a boot file
can be booted from.  The usual valid boot names can be used for these
files, such as SYSTEM_BAS.
.P
(Note - the last field in this example is necessary (as of this writing)
only because of a deficiency in rbootd; the file 'dummy' need not 
actually exist.)
.P
This example assumes that RMB's 
STORE SYSTEM statement has been used to make a boot file, SYSTEM_BAS, 
which already contains at least the  LAN and SRM binaries (most systems
will want to include the rest of the binaries needed by the client as well).  
NOTE - This is the 
recommended method of setting up booting of RMB over LAN from SRM-UX.
.P
If the RMB client is configured in this manner, then the client has 
access to a node specific autostart file in the same way as provided by the
current SRM; that is the autostart file is first looked for as
/SYSTEMS/AUTOSTnn, where nn is the 2 digit simulated SRM node number of 
.mc |
the client (see the /etc/srmdconf section for a discussion of simulated
.mc
SRM node numbers).  
If /SYSTEMS/AUTOSTnn does not exist, then the name /AUTOST is
tried, which can provide a generic autostart file for all RMB client nodes.  
.P
Note that the paths /SYSTEMS/AUTOSTnn and /AUTOST are relative to the
.mc |
Root Directory specified for Volume 8 in /etc/srmdconf, described below.
.mc
So the path /SYSTEMS/AUTOST02 as seen by the RMB client is
.mc |
actually /srmserve/SYSTEMS/AUTOST02 in the example /etc/srmdconf
.mc
described in the next section. 
.P
If the boot file does not contain the LAN and SRM binaries, the RMB client 
requires additional assistance from rbootd before it can communicate 
directly with srmd.  The next example basic-srm line shows how this can be
accomplished. 
.SP
.nf
basic-srm:HPS300::SYSTEM_BAS:/AUTOST,/SYSTEMS/CRTB,/SYSTEMS/CRTX,
/SYSTEMS/SRM,/SYSTEMS/LAN        #the printed output in this ERS takes 
multiple lines, but there is only 1 line in the actual file
.fi
.P
The last field contains a list of files that 
rbootd will access for the RMB client before it can communicate with srmd.  
The example includes /AUTOST, and several binaries, including the LAN and
SRM binaries.
This provides a way for RMB to access its autostart file, /AUTOST, which can
in turn do LOAD BIN's of the LAN and SRM binaries.  Once these two binaries
are loaded, RMB can then communicate directly with srmd, and have access to
the full functionality of SRM-UX.  Alternatively, the RMB user could execute 
LOAD BIN's directly from his keyboard in case the autostart file
is not present.
.P
The files in this list can be found on Volume 8, just like 
the SYSTEM_BAS file, except that the full path names, relative to the
root of Volume 8, must be specified.  There is no capability for a node
specific autostart file in this case because the RMB client cannot find
out its node number to generate a /SYSTEMS/AUTOSTnn path name.  The
generic autostart file must be in the root directory of Volume 8; the binaries
can be anywhere in Volume 8, as long as the paths in the LOAD BIN 
statements in the autostart file, or typed from the keyboard, match the
paths in /etc/boottab exactly.
.P
If the LAN and SRM 
binaries are not included in the boot file, and cannot be found in the 
place specified in /etc/boottab,
and the RMB client cannot load the SRM and LAN binaries 
from its local mass storage, then the client will not be able to use SRM-UX.
.SP
.H 4 "Booting PAWS"
.P
To be able to boot PAWS correctly from the SRM-UX server over LAN, a line 
similar to that below must be added to /etc/boottab :
.SP
.NF
paws-srm:HPS300::SYSTEM_P:INITLIB,STARTUP,TABLE
.FI
.SP
.P
Either or both of the basic-srm and paws-srm lines should be added to
/etc/boottab, depending on which systems the SRM-UX server will be booting
over LAN cards. At most one line of each type is allowed in /etc/boottab.
Boot files will be presented to the client's BOOTROM in the order in which
they appear in /etc/boottab.  (If booting over SRM cards, using srmd
directly, the boot files will appear to the client's BOOTROM in the order
they appear in the /SYSTEMS directory, as seen with ls -f on the server.)
.P
The format of the paws-srm line is the same as the basic-srm line format.
The first four fields are respectively, paws-srm to tell
.mc |
rbootd that the file /etc/srmdconf
.mc
(discussed below) exists and should be processed, machine type field, which
must be HPS300 for SRM-UX, an empty field, and a list of one 
or more boot files, separated by commas.  These files
must be in directory /SYSTEMS on volume 8 as declared in the 
.mc |
SRM-UX /etc/srmdconf file (described in the next section of the ERS). 
.mc
Volume 8 is the only place a boot file
can be booted from. The usual valid boot names can be used, for example
SYSP33. 
.P
The next field contains 3 items, the standard Pascal extension boot files.
They can be found in one of two places, but must be on Volume 8, just
like the SYSTEM_P file. More than one set of boot extension files can
be specified by listing them separated by commas. E.g. :
.SP
.nf
paws-srm:HPS300::SYSTEM_P,SYSP33:INITLIB,STARTUP,TABLE,INITP33,
STARTP33,TABLEP33		# the printed output in this ERS takes 
multiple lines, but there is only 1 line in the actual file
.fi
.SP
.P
The search rules for these files are NOT the same as for RMB.  
The first place 
these files are looked for is in /WORKSTATIONS/SYSTEMnnnnnn, where nnnnnn
is the last 6 digits of the PAWS client LAN card Link address.
.P
If /WORKSTATIONS/SYSTEMnnnnnn does not exist, the path /WORKSTATIONS/SYSTEM
is searched for the 3 extension boot files. If neither of these 
paths exist, or if the INITLIB file is not found, the boot will fail with
an error  -10. If the STARTUP or TABLE files are not found, booting will
be completed, but the PAWS client system may be practically unusable.
Both of these paths are relative to the root directory for volume 8, as
.mc |
described in the /etc/srmdconf section below.
.mc
.P
The names of the INITLIB, STARTUP and TABLE programs should
follow the standard rules, based on the name of the SYSTEM_P file.
E.g. if the system file has the name SYSP33, the other files should be
named INITP33, STARTP33, and TABLEP33.
.P
Once booting is complete and TABLE has executed, rbootd is no longer
used by the PAWS client. From here, srmd on HP-UX and the SRM driver in
the PAWS INITLIB file take over. If srmd is not running or the proper
modules are not in INITLIB, the PAWS client system will probably be unusable.
.SP
.mc |
.H 2 "/etc/srmdconf"
.mc
.SP
.P
.mc |
The file /etc/srmdconf
.mc
is used to configure srmd, defining how it emulates an SRM host for 
each PAWS or RMB client.  It should be owned by the root
user, and should have permissions of rw-r--r--, so that other users
can examine but not modify it.
.mc |
An example srmdconf file is shown below:
.mc
.SP
.nf
#----------------------------------------------------------
VOLUME-TABLE

# Volume Descriptions
#
# Volume     Disk                   Temp         Root
#  Name    Volume #    Uid  Gid   Directory    Directory
#----------+---------+----+-----+------------+----------
SRM_LW     :   8     : 17 :   9 :            : /srmserve
ROOT_LW    :   9     :    :     : /tmp       : /
QUIST_LW   :  10     :    :     : /tmp       : /users/quist
BAYES_LW   :  10     :    :     : /tmp       : /users/bayes
JWH_LW     :  10     :    :     : /tmp       : /users/jwh
DEW_LW     :  10     :    :     : /srmtmp    : /users/dew
SCHMIDT_LW :  10     :    :     : /tmp       : /users/jws
PRINTER    :  11     :    :     : /tmp       : /PRINTER

LAN-CLIENTS

#     note - the printed output in this ERS takes multiple lines
#     for each entry, but there is only 1 line per entry in the actual file
.mc |
# Client         Client    Client Server Client
# Link Address   Internet   Node  Node   Name    Uid  Gid  Umask  Volume List
#---------------------------------------------------------------------------
 0x80009000937 : 15.2.48.60 :  1 :  0  : Quist : 106 :  20 : 022 : SRM_LW,
.mc
ROOT_LW, QUIST_LW # Rob Quists Workstation

.mc |
 0x80009003542 : 15.2.48.61 :  2 :  0  : Bayes : 101 :  20 : 022 : SRM_LW,
.mc
ROOT_LW, BAYES_LW # Scott Bayes Workstation

.mc |
 0x800090133D4 : 15.2.48.62 :  3 :  0  : Jeff  : 213 :  20 : 022 : SRM_LW,
.mc
ROOT_LW, JWH_LW # Jeff Hendershot 300 Workstation

.mc |
 0x80009006679 : 15.2.48.63 :  4 :  0  : Jeff2 : 213 :  20 : 022 : SRM_LW,
.mc
ROOT_LW, JWH_LW # Jeff Hendershot 9836A Workstation

.mc |
 0x8000903D63D : 15.2.48.64 :  5 :  0  : Willis: 200 :  20 : 022 : SRM_LW,
.mc
ROOT_LW, DEW_LW # Dave Willis Workstation

SRM-CLIENTS	# allowed on Series 300 servers only

# SRM Card Clients
#
.mc |
# Server's   Client    Client                      Volume
# Dev File  Node Num    Name     Uid   Gid  Umask  List
#---------+----------+-------- +-----+-----+-----+---------------------------
/dev/srm  :    32    : Schmidt : 103 : 20  : 022 : SRM_LW,ROOT_LW,SCHMIDT_LW 
/dev/srm  :    52    :         : 123 : 20  : 022 : SRM_LW,PRINTER   # PRINTER
.mc

SPOOL-ENVIRONMENT

# The following environment variables are pre-initialized 
# for spooling processes.
#
#  SHELL 		- defaults to /bin/sh, unless overridden
#  TZ    		- inherited from the OS, if it is set there,
#			  otherwise defaults to MST7MDT
#  SRMSPOOLFILENAME	- defaults to the full pathname to the file
#			  being spooled (e.g. /srmserve/PRINTER/xyzzy)
#  PATH			- defaults to /bin:/usr/bin. Recommend that
#			  it be set to include paths needed for all
#			  commands used in spooler execution

PATH=/bin:/usr/bin:/usr/contrib/bin:/usr/local/bin
SHELL=/bin/ksh


SPOOL-TABLE

# Spooling Services
#
# Spool Directory   Priority	         Spooling Command
#------------------+--------+------------------------------------------
.mc |
/srmserve/PRINTER  :    3   : srmdlpfilter | lp -dljet -oraw $PRIORITY
/srmserve/EPRINTER :    7   : srmdlpfilter | lp -depoc -oraw $PRIORITY
.mc

.fi
.SP
.mc |
.H 3 "Format of /etc/srmdconf"
.mc
.SP
.P
.mc |
There are 5 keywords that introduce the various blocks of srmdconf.
.mc
They are: VOLUME-TABLE, LAN-CLIENTS, SRM-CLIENTS, SPOOL-ENVIRONMENT,
and SPOOL-TABLE. They must appear in the order given, and in uppercase,
exactly as shown in the example, except that an SRM-CLIENTS block is not
.mc |
allowed on Series 800 servers. Each block in srmdconf describes a
.mc
different part of the configuration.  For all blocks, fields within each
entry in the block are separated by ":" characters. Fields must appear
in the order seen in the example (the same order as they are discussed below.)
A comment can appear as the last item in any line of the file, and is
introduced by the "#" character; anything after a "#" is ignored by
srmd or rbootd until the start of the next line.  Blank
lines may be inserted anywhere in the file to improve readability.
.SP
.mc |
.H 3 "What /etc/srmdconf accomplishes"
.mc
.SP
.P
.mc |
The SRM-UX administrator uses /etc/srmdconf to accomplish the following
.mc
tasks:
.SP
.H 4 "Control of file access"
.P
The administrator controls which RMB and PAWS clients can access which
pieces of the HP-UX file system on the SRM-UX server machine.  
The set of allowed accesses may be different for each client.  
Note that the binding of access permissions to clients is different from
the normal terminal based HP-UX access permissions.  With terminals, the
permissions depend on which user is logged into the terminal.  In SRM-UX,
the permissions are tied to the client machine itself, not to the person
who is using that machine.
.SP
.H 4 "Emulation of SRM node numbers for LAN cards"
.P
LAN and SRM interfaces are managed in different ways. 
For the LAN card, there are no such things as node
numbers, which the SRM driver and protocol depend on to know where to
connect to, and how to direct data. Therefore srmd will emulate SRM node 
numbers for each LAN card it communicates with. 
Two node numbers need to be emulated:
the SRM host node number and the client node number.
.P
Such emulation is not necessary for the 50962A card, as the
required node numbers exist and are settable using switches on the cards.
.mc |
Hence, the format of the LAN-CLIENTS and SRM-CLIENTS blocks of /etc/srmdconf
.mc
are somewhat different.
.SP
.H 4 "Set up of spooling services"
.P
Finally, the SRM-UX administrator may provide printer and plotter spooling
to the RMB and PAWS clients. 
.SP
.H 3 "The Volume Table"
.SP
.P
Keyword: VOLUME-TABLE
.SP
.P
The volume table contains names and descriptions of "volumes"
(SRM volume emulations) that will be presented to PAWS or RMB clients.
Each volume is a subtree of the current mount tree of the HP-UX host
(including any accessible remote file systems previously mounted
by NFS utilities) and is described by one line of text
in the Volume Table. A description of each field follows:
.P
The Volume Name field is the name of the volume as seen by the client.
It simulates the Volume Label of a real SRM disc. An RMB user uses this
name as the LABEL specifier in the MSI statement, and can see it as part 
of the header on CAT output.  A PAWS user can see
this name by using the Filer List command to list the directory
"/" for the unit to which the volume is associated.  Each line of the
volume table must have a unique volume name.
.P
The Disk Volume # field is the emulated disk volume number as it would
be seen on a real SRM.  Volume 8 is special; booting from SRM-UX is 
supported only from this volume.  Only one volume 8 is allowed in the 
volume table.  There may be multiple volumes with other volume numbers, but
a given client may access only 1 volume with a given number.
See the PAWS Client ERS for details of how this field is used in CTABLE.
RMB does not use this field; it only uses volume labels for SRM disks.
.P
The Uid field is a User or Owner ID value that will be assigned to files
and directories created through the srmd server. It is an override of
the value specified in the LAN-CLIENTS and SRM-CLIENTS sections of
.mc |
srmdconf. If the uid field is empty, the value in the client services
.mc
section will control.
.P
The Gid field is similar to the uid field, providing group ID assignment
for newly created files and directories.
.P
The Temp Directory provides a mapping for the file name 
/WORKSTATIONS/TEMP_FILES. For many operations, the PAWS SRM driver
creates temporary files which it stores on the SRM in the directory
/WORKSTATIONS/TEMP_FILES. It is often not convenient to provide the
directory /WORKSTATIONS/TEMP_FILES at the root of each SRM-UX subtree;
this field tells srmd to convert that file name to one
which is more convenient, and is accessible in the subtree.  If the
path starts with a leading "/" it is an absolute path name on the server
(for example /tmp).
Otherwise it is evaluated relative to the root directory field for its
volume (next paragraph). 
If the field is empty (or spaces), no conversion is done.
.P
Root Directory provides the path on the HP-UX machine to which the
simulated SRM tree is attached. Specifying the root of the SRM ("/")
from the PAWS or RMB client goes to this directory.
Specifying ".." from there will not go above the root directory
.mc |
specified in srmdconf for the volume.
.mc
.SP
.H 3 "The LAN Card Clients Table"
.SP
.P
Keyword: LAN-CLIENTS
.SP
.P
The Client Link Address field specifies  the LAN link address of the
98643A interface on the PAWS or RMB machine to which service is to
be provided. It is a 6-byte number (12 digits hex) which is factory-set
by HP to be unique. Many Series 300 computer BOOTROMs report this
number; if it is reported, it will appear on the left side of the 
screen, on the line where the existence of the 98643A card is reported.
If the BOOTROM does not report the Link Address, see the installation
manual that came with  the 98643A card (or the computer's installation
manual if the LAN interface is built in) for information on determining it.
.P
The Client Internet Address field specifies the internet address of
the client.  Each client is required to be on the same subnet as the 
SRM-UX server.  The last part of the internet address must be unique
on the subnet.  If there are also HP-UX machines on the same subnet, care
is required to avoid duplication of internet addresses.  The information
.mc |
in the /etc/hosts.local and /etc/hosts files should help avoid collisions with 
internet addresses assigned to HP-UX machines.  If a 
given machine sometimes runs HP-UX LAN code, and sometimes is a PAWS or RMB
client of SRM-UX, it should use the same internet address for 
both cases.
.mc
.P
Client Node is the 2-digit emulated SRM client node number that srmd
pretends the LAN-based client to be. 
RMB returns this number in response to a "status(sc, 6)" command. 
The range is 0..63, although numbers less
than 10 should normally be reserved for servers, not clients.
PAWS ignores this node number during boot, and when assigning a "*" 
directory, using instead the unique 6-digit hex number taken from the 
last six digits of the LAN link address. 
.P
Server Node is the 2-digit emulated SRM host node number the server
machine pretends to be when using the LAN card to communicate with
the client specified in the Client Link Address field. One server
machine may only pretend to be one server node for any given
client interface; for a different client interface, it may pretend
to be another host node (e.g. host node 1). Any client may have more
than one interface plugged in, allowing more than 
one emulated host node. 
RMB users put the Server Node value in MSI specifiers, 
as in ":REMOTE 21,<Server Node value>".
The Server Node value is used in the ba parameter
of tea_srm calls in the PAWS CTABLE program.
.P
.mc |
Client Name is an optional string, up to 10 characters long, that assigns
a unique name to the client, which can be used by the front panel commands
such as srmdreset and srmdstat to refer to a client by name instead of by
node number.  Note that the name must be unique across both the LAN-CLIENTS
and SRM-CLIENTS blocks.  If a name is not given for a client, then this 
field must be empty or all blanks.
.P
.mc
Uid is the HP-UX User Id to be assigned to all new files and directories
created by this client using srmd, unless overridden in the Volume Table.
The uid will also be used for jobs submitted to the HP-UX print spooler
for this client.
(A value must be specified in this field, even if overridden in all
Volume Table entries.)
.P
Gid is the HP-UX Group Id to be assigned to all new files and directories
created by this client using srmd, unless overridden in the Volume Table.
(A value must be specified in this field, even if overridden in all
Volume Table entries.)
.P
Umask is the HP-UX umask to be applied to all new files and directories
created by this client using srmd. See the HP-UX reference manual,
section (1) for details.  
.P
Volume List is a list of emulated volumes
chosen from the Volumes Table above. It specifies which volumes in the
Volumes table can be accessed by each client.  This list, together with
the volume table, is the primary way that
the SRM-UX administrator controls which pieces of the HP-UX file system
that each client may access.
.SP
.H 3 "The SRM Card Clients Table"
.SP
.P
Keyword: SRM-CLIENTS
.SP
.P
.mc |
This section of srmdconf is relevant only to 50962A cards.  This section
.mc
is allowed only on Series 300 servers because Series 800 servers do not
support SRM cards.
The first field, Dev File, is the full path to the device special
file in the SRM-UX server on which srmd is to provide service.
The root user would set up an srm device file via:
.SP
.nf
/etc/mknod /dev/srm c 13 0xnn0000   # nn is the SRM card's select code
.fi
.P
The Client Node Num is the node number set on the switches on the 50962A
card in an RMB or PAWS srmd client machine. It, along with the dev file
specified above, specifies from which clients srmd will accept a
connection request.  (With one exception, the Client Node Numbers 
in the SRM-CLIENTS block
are completely separate from the Client nodes in the LAN-CLIENTS block;
that is, the numbers are not required to be unique across the two blocks,
and don't have to be unique for nodes using different /dev/srm device files.
The exception to this rule occurs when setting up client specific AUTOST
files for RMB clients - in that case unique 2 digit node numbers are required
because all of the AUTOSTnn files will be in the /SYSTEMS directory on
Volume 8.)
.P
.mc |
The remaining fields (Client Name, Uid, Gid, Umask, and Volume List) have the 
.mc
same definitions as the corresponding fields in the LAN-CLIENTS table.
.SP
.H 3 "The Spool Environment Table"
.SP
.P
Keyword: SPOOL-ENVIRONMENT
.SP
.P
This block provides an HP-UX environment for the spooling processes
to "live in." When a file is closed in a spooling directory, srmd will
.mc |
pass an open file descriptor for the file to an HP-UX shell process 
specified in
.mc
the Spooling Services Table (next section.) This process
needs some "environment" in which to operate. Default values are 
provided for the following variables: SHELL, TZ, SRMSPOOLFILENAME, and
PATH.  This block can be used to over-ride the defaults for these
variables, and/or to set up additional variables to
provide more power and flexibility to the spooling process. (See
the "Bourne Shell" section of the HP-UX manual "Shells and
Miscellaneous Tools" for details on shell and environment variables,
and piping.)  
.P
The first and only field on each line
(except for an optional trailing comment)
is the variable assignment field. It always has the format:
.SP
.P
variable=value
.SP
.P
.mc |
See the sample srmdconf listing for examples.
.mc
.SP
.H 3 "The Spooling Services Table"
.SP
.P
Keyword: SPOOL-TABLE
.SP
.P
.mc |
This section of srmdconf provides flexible descriptions of how SRM
.mc
printer and plotter spooling is to be emulated by SRM-UX. See the
Shared Resource Management System Manager's Guide for details on
spooling in the SRM environment. The first field is a Spool Directory
name. It is an absolute path on the SRM-UX server system from which
files are to be print-spooled by srmd.
.P
The second field, which is optional, specifies the Priority to use 
for jobs from the PRIORITY sub-directory of the Spool Directory.  It must
have a value between 0 and 7, inclusive.
The current SRM supports a high-priority spooling mechanism by using an
optional PRIORITY sub-directory in spooling directories.  Files placed in
a PRIORITY sub-directory are spooled ahead of files placed in the main
spooling directory.  
The same mechanism will be supported by the SRM-UX server.  Srmd will
check for files to be spooled in 
the PRIORITY sub-directory (if it exists) for each Spool Directory.
If the Priority field has a value of 7, for example, then the shell 
variable $PRIORITY will
be set to '-p7' for each job from the PRIORITY sub-directory.  
This value will be used as an argument to lp to specify a higher 
priority for jobs from the PRIORITY sub-directory, if the $PRIORITY
argument is included in the lp invocation in the Spooling Command (discussed
next).  Srmd will set the PRIORITY shell variable to the null string for 
jobs from the main spooling directory so they will be submitted with the
default priority.
If no value is specified in the Priority field,
or the $PRIORITY argument is not included in the lp invocation in the
Spooling Command,
then all jobs from that Spool Directory, including the PRIORITY sub-directory,
 will be submitted with the default priority.
.P
The third field, Spooling Command, is an HP-UX shell
command sequence to be executed in order to perform the spooling
operation. (It will be a Bourne shell sequence unless the SHELL variable
has been set to something else in the SPOOL-ENVIRONMENT block, or !#ksh is
the first line of the shell script.)
It is passed to /bin/sh (or the current value of SHELL)
by srmd, along with the contents
of the spool file. The full pathname of the file (e.g.
"/srmserve/PRINTER/Scott-job.UX") is passed in to this
command sequence as $SPOOLFILENAME. See the manual page for sh(1)
for shell programming information.
The spool file will be removed after being printed.  The administrator
should NOT put an explicit "rm $SPOOLFILENAME" in the command pipeline.
The Spooling Command will be executed with the client's uid.  
Therefore, if it is necessary to cancel an lp request (for example), 
root user capability will not be required.  (This would still have to 
be done from HP-UX.)
.P
How print spooling is done depends partly
on how the HP-UX system's own print spooling is set up. However,
from the RMB or PAWS user's point of view, all that is required is to
.mc |
place a text file into a spooling directory on SRM-UX (for example, with
a copy or link operation).
.mc
.P
For example, from the PAWS EDITOR, when the file is ready for printing,
one could Quit, Save, and specify a file name such as
#5:/PRINTER/Scott-job.text. The printout should soon
appear on the printer of the SRM-UX server machine. The file will be
removed after it is spooled. 
>From RMB, the user could execute a SAVE or
COPY statement to place a file to be printed in the PRINTER directory.
.P
For the 
above example SPOOL-TABLE, if the file is named Scott-job.text, and
is in the directory /srmserve/PRINTER, srmd will execute the command
.mc |
"srmdlpfilter | lp -dljet -oraw $PRIORITY", passing an open file descriptor 
for the file to be spooled to srmdlpfilter, 
.mc
and setting the shell variable $SPOOLFILENAME to 
.mc |
"/srmserve/PRINTER/Scott-job.text". The command first invokes srmdlpfilter, 
.mc
which is a special front end to lp provided as part of the SRM-UX
.mc |
product. Srmdlpfilter will remove the WS header from the file, and translate
.mc
the .text format to the standard HP-UX vi-compatible format.  (A complete
.mc |
discussion of srmdlpfilter is given in the next section.)
The result of srmdlpfilter is piped to the 
.mc
standard HP-UX line printer spooler, lp, which tells it to
print its input to spooler device ljet (a printer), using the
device-dependent option raw. 
.P
The pathname specified in the Spool Directory field is absolute
and is not modified by any volume specification. For example,
a PAWS client might have two volumes, one at unit #5, starting at "/srmserve",
and the other at unit #46, starting at "/". To spool to the
above spooler, the client could specify a path of either "#5:/PRINTER"
or "#46:/srmserve/PRINTER".
.mc |
.P
When srmd is shutdown, it will attempt to spool files in the Spool Directory
before terminating.  Files which didn't get spooled at shutdown, will be
spooled the next time srmd is started.
.mc
.SP
.mc |
.H 3 "srmdlpfilter"
.mc
.SP
.P
.mc |
Srmdlpfilter is a special frontend to the standard HP-UX spoolers which is
.mc
being provided as part of the SRM-UX product.  It will remove WS headers
from the front of any files which have them.  
It will examine the file name of the file to be printed, and pre-pend
the appropriate ENVIRONMENT file if one exists (after first removing the
WS header from the ENVIRONMENT file if it has one).  (See the existing
SRM manual for details on ENVIRONMENT files; SRM-UX handling of them will
be compatible with the current SRM.)  Files without a WS header will be passed
through unchanged.  Other file types, such as ASCII and .text, will be
translated to the standard HP-UX vi-compatible format.  The SRM's FF prefix
on the spool file name will be ignored; the standard HP-UX spoolers do 
the appropriate pagination by default.
.P
.mc |
The SRM-UX administrator does not have to include srmdlpfilter in the Spool
.mc
Command pipeline; however, a Spool Command  which invokes lp directly will 
successfully print only standard HP-UX files.
(Standard HP-UX files are created by using the suffix ".UX"
in PAWS revision 3.2 and later, or by using the plain CREATE statement in
RMB.)
.SP
.mc |
.H 3 "The example /etc/srmdconf"
.mc
.SP
.P
.mc |
In the example /etc/srmdconf file, a PAWS or RMB client using the
.mc
98643A interface with Link Address 0x80009000937 has access to
three volumes. One volume, SRM_LW, is defined to 
be the subtree under "/srmserve".  Attempts by the RMB or PAWS user to
prefix via this volume to "/" will always leave him at /srmserve.
As a matter of fact, /srmserve will usually be set 
up as a small "SRM world", with its own /WORKSTATIONS directory,
its own /SYSTEMS directory, etc. Booting and ordinary SRM tasks can
all be accomplished from within /srmserve.
.P
Link Address 0x80009000937 has access to two other volumes as well,
ROOT_LW and QUIST_LW. ROOT_LW is prefixed to "/" on the HP-UX
file system. This volume provides access to the whole HP-UX
file system, if read/write/execute permissions on the HP-UX
system so allow. It is a volume intended for uses
of SRM-UX such as data-sharing with RMB-UX or HP-UX itself,
or access to remote file systems mounted via 
NFS on the HP-UX server. QUIST_LW is prefixed to the HP-UX
home directory that user gets as his "home" directory when
logging in to the HP-UX server machine under HP-UX; this is convenient
for those who use both RMB or PAWS, and HP-UX, and wish to share 
data between them.  Files and directories created on the volume
SRM_LW will be created with uid=17, gid=9, 
according to the override specified in the Volume table.
Those created on volumes ROOT_LW and QUIST_LW will have uid=106,
gid=20, as there is no override. Directories created via any of the volumes
will have permissions 755 (rwxr-xr-x), as the umask for the client is 022;
ordinary files will have permissions 644 (rw-r--r--).
.P
Temporary files created by the SRM driver on the PAWS client will
appear in /srmserve/WORKSTATIONS/TEMP_FILES for volume SRM_LW, and in
/tmp for volumes ROOT_LW and QUIST_LW.
.P
An RMB user would use the LABEL field in his MSI statement to choose 
between SRM_LW, ROOT_LW, and QUIST_LW for any given mass storage operation.
A PAWS user would not have to modify 
CTABLE to talk to volume SRM_LW, as it
is disk Volume 8 on host node 0 (Server Node) on select code 21, which
matches the default CTABLE values. However, he would have to modify 
and recompile CTABLE if he wanted to access 
ROOT_LW and/or QUIST_LW, as disk volumes 9 and 10 are not
defaults of CTABLE. (See the PAWS Client ERS for details on how to do this.)
.P
Another client machine, for example, 0x80009003542, will see a
different view of the same SRM-UX host machine. This other machine
sees volume 8 the same, but files and directories created on
volume 9 (ROOT_LW) will have uid=101 instead. This machine also has 
access to another volume, volume 10, BAYES_LW, with root at
/users/bayes. Files and directories created here will have uid=101,
gid=20, which are this user's uid and gid when he logs in to HP-UX
on the server.
.P
No provision is made to allow the RMB or PAWS users
.mc |
to change any of the items specified in /etc/srmdconf. This is the
.mc
province of the SRM-UX administrator.
.mc *
.mc
.SP
.H 1 "	   Migration of Files from SRM to SRM-UX"
.SP
.P
.mc |
A tool, named srmdrestore, will be provided as part of the SRM-UX product 
which will read
.mc
SRM 3.x backup tapes, and selectively copy files to the HP-UX file
.mc |
system.  Srmdrestore will be similar to cpio -i, except that it will have
.mc
to read the proprietary SRM backup format, and it will pre-pend WS
headers to the front of the files it reads in.  SRM backup tapes older
than 3.0 will not be supported, because they use a different format than
3.x tapes.  There will be no facility for writing SRM backup tapes from
.mc |
srmdrestore.  A preliminary man page for srmdrestore is attached to the end of
this ERS.
.mc
.P
Other possible migration mechanisms are still under investigation.  It 
has not been decided if any additional ones will be provided as part of
the SRM-UX product.
.mc |
.SP
.H 1 "		Front Panel Interface"
.SP
.P
Several new HP-UX commands will be part of the SRM-UX product which will 
provide functionality similar to some of the existing SRM console commands.  
Srmdreset will be analogous to the SRM's REMOVE_USER command.
Srmdshut will be analogous to the SRM's SYSTEM DOWN command.  Srmdstat, with 
various options, will be analogous to the SRM's FILES, USERS, and NODES
commands.  Preliminary man pages for srmdreset, srmdshut, and srmdstat are
attached to the end of this ERS.
.PH ""
.SK
.nf
SRMDRESTORE(1)						2/21/90


NAME
    srmdrestore - copy in files from SRM backup tapes 

SYNOPSIS
    srmdrestore [-dtuvmf] [-U<uid>] [-G<gid>] [-M<mode>] [patterns] 

DESCRIPTION

    Srmdrestore, with various options, provides a mechanism to 
    import files from SRM 3.x backup tapes.

    Path names in the SRM backup are interpreted relative to the
    current directory.

    Only files with names that match 'patterns' are selected. 
    (See regexp(5) for the Pattern Matching Notation.)  Multiple
    'patterns' can be specified.  If no 'patterns' are specified, 
    all files are selected.

    Ownership and permissions of the files are defaulted to the 
    current user, and his umask, unless overridden by specifying 
    -U, -G, and/or -M options.  Note that SRM passwords on the
    SRM backup tape are ignored.

    The d, t, u, v, m, and f options are based on cpio(1).

  Options

    -d		Create directories as needed.

    -t		Print only a table of contents of the SRM backup.
		No files are created.

    -u		Copy unconditionally (normally, an older file will
		not replace a newer file with the same name).

    -v		Verbose:  cause a list of file names to be printed.

    -m		Retain previous file modification time.  This option
		is ineffective on directories that are being copied.

    -f		Copy in all files except those in 'patterns'.

    -U<uid>	The created files will be owned by 'uid', instead of
		the current user.

    -G<gid>	The created files will be part of group 'gid', 
		instead of the current user's group.

    -M<mode>	The created files will have permissions of 'mode',
		instead of the current user's umask.  (Ordinary 
		files will have their execute bits cleared.)

ERRORS

EXAMPLES

FILES

SEE ALSO

EXTERNAL INFLUENCES
  Environment Variables
    LANG determines the language in which messages are displayed.
.fi
.SK
.nf
SRMDRESET(1M)						2/1/90


NAME
    srmdreset - reset SRM-UX clients

SYNOPSIS
    srmdreset -a|-n<name>|-s<dev file><node>|-i<internet>  [<files>]

DESCRIPTION

    Srmdreset provides the SRM's REMOVE_USER functionality.

    One of -a, -n, -s, or -i must be specified.

    -a specifies that all clients are to be reset.  If no 'files' are
    specified, then all open files for all clients are unlocked and 
    closed.  If one or more 'files' are specified, then the specified 
    'files' are unlocked and closed for all clients which have them 
    open.

    -n specifies that user 'name' is to be reset, where 'name'
    is the Client Name from the LAN-CLIENTS or SRM-CLIENTS blocks
    of /etc/srmdconf.  If no 'files' are specified, then all of the
    client's open files are unlocked and closed; otherwise only the
    specified 'files' are unlocked and closed.

    -s specifies that the SRM client with node number 'node', on 
    the SRM card specified by 'dev file', is to be reset.  If no
    'files' are specified, then all of the client's open files are
    unlocked and closed; otherwise only the specified 'files' are
    unlocked and closed.

    -i specifies that the LAN client with Internet address 'internet'
    is to be reset.  If no 'files' are specified, then all of the
    client's open files are unlocked and closed; otherwise only the
    specified 'files' are unlocked and closed.

    Only the super-user can execute srmdreset.

ERRORS

    Errors will occur on the following conditions:

    [ESRCH]	The SRM-UX daemon is not running when srmdreset 
		is executed.

    [ENOENT] 	The client specified by -n, -s, or -i cannot be 
		found in the LAN-CLIENTS or SRM-CLIENTS blocks 
		of /etc/srmdconf.

    [ENOENT]	One or more of 'files' does not exist. ('Files'
		which do exist will still be closed.)

EXAMPLES

FILES
    /etc/srmdconf
    /etc/srmdpipe

SEE ALSO
    srmdshut(1M),srmdstat(1)

EXTERNAL INFLUENCES
  Environment Variables
    LANG determines the language in which messages are displayed.
.fi
.SK
.nf
SRMDSHUT(1M)						2/1/90


NAME
    srmdshut - terminate the SRM-UX daemon

SYNOPSIS
    srmdshut

DESCRIPTION

    Srmdshut provides the SRM's SYSTEM DOWN functionality.  Note
    that the SRM's powerfail option is NOT supported.

    Srmdshut will do a "graceful" shutdown of the SRM-UX daemon.
    Incoming client requests will be disabled, and then all open 
    files will be unlocked and closed before terminating the
    daemon process.  Srmdshut will wait for the daemon to 
    terminate.

    The SRM-UX daemon can be restarted by executing /etc/srmd.

    Only the super-user can execute srmdshut.

ERRORS

    Errors will occur on the following condition:

    [ESRCH]	The SRM-UX daemon is not running when srmdshut 
		is executed.

FILES
    /etc/srmdpipe

SEE ALSO
    srmdreset(1M),srmdstat(1)

EXTERNAL INFLUENCES
  Environment Variables
    LANG determines the language in which messages are displayed.
.fi
.SK
.nf
SRMDSTAT(1)						2/15/90


NAME
    srmdstat - obtain status information on SRM-UX clients

SYNOPSIS
    srmdstat [ -n<name> | -s<dev file><node> | -i<internet> ]
    srmdstat -f<files>
    srmdstat -u
    srmdstat -p
    srmdstat -c

DESCRIPTION

    Srmdstat, with various options, provides the SRM's FILES,
    USERS, and NODES functionality.

    No more than 1 option is allowed per execution of srmdstat.

    If no option is specified, srmdstat outputs a list of all
    active clients, and lists all of the files each client has open.

    -n lists the files that user 'name' has open, where 'name'
    is the Client Name from the LAN-CLIENTS or SRM-CLIENTS blocks
    of /etc/srmdconf.

    -s lists the files that the SRM client with node number 'node',
    on the SRM card specified by 'dev file', has open.

    -i lists the files that the LAN client with Internet address 
    'internet' has open.

    -f lists the clients which have the specified 'files' open.

    -u lists all clients which have open files.  A count of how many
    files each client has open is also output.

    -p lists which of the clients in the LAN-CLIENTS and SRM-CLIENTS
    blocks of /etc/srmdconf that srmd can communicate with.  This
    provides a rudimentary check of whether or not the client is
    powered on, and whether or not the client's interface card and
    interconnection with the server are working.  This will also 
    include a count of how many clients are active versus how many
    clients are configured in /etc/srmdconf.

    -c provides output showing how srmd configured itself based on
    /etc/srmdconf.  This will include a count of how many clients are
    configured in /etc/srmdconf.  (This option may not be provided if 
    SAM does a complete validation of /etc/srmdconf as it is entered.)

ERRORS

    Errors will occur on the following conditions:

    [ESRCH]	The SRM-UX daemon is not running when srmdstat 
		is executed.

    [ENOENT] 	The client specified by -n, -s, or -i cannot be 
		found in the LAN-CLIENTS or SRM-CLIENTS blocks 
		of /etc/srmdconf.

    [ENOENT]	One or more of 'files' specified by -f does not 
		exist. ('Files' which do exist will still be listed.)

EXAMPLES

FILES
    /etc/srmdconf
    /etc/srmdpipe

SEE ALSO
    srmdreset(1M),srmdshut(1M)

EXTERNAL INFLUENCES
  Environment Variables
    LANG determines the language in which messages are displayed.
.fi
.mc

