.H 1 "Setpasswords DAM call in HFS"
The setpasswords call supports "subcalls" in hfsdam.
There are two classes of subcalls, volume and file related subcalls.
.P
Volume class
.br
.DL
.LI "login"
.LI "umask"
.LE
.P
File class"
.br
.DL
.LI "open"
.LI "chmod"
.LI "chown"
.LI "chgrp"
.LI "chatime"
.LI "chmtime"
.LE
.P
For all calls, a FIB is passed in, and fwindow points at an array of
h_setpasswd_entry(see MISC). Fpeof is the number of valid entries in fwindow^.
The DAM processes all entries till it gets an error,
or completes successfully.
If it gets an error, ioresult is set, all changes made so far still remain.
The number of successfully completed commands is returned in fpeof.
The FIB may be modified whether or not there is an error, 
so BEWARE.
.P
For all subcalls, the h_setpasswd_entry.command is the call command
(eg chown), and new_value is an integer that the call may use.
.P
Only notable failure conditions are given. Ie things like failure to traverse
path are not specified here; do what other DAM calls do.
.P
The class of the first command sets the class of the setpasswords call.
For volume related commands it is only possible to pass one command
(fpeof = 0).
If a passentry in the array is not in this class, ioresult := ibadvalue, and
the call is exited.
This happens because volume and file class calls have 
different FIB setups which are not compatible with each other.
If an unrecognized command is encountered, the call exits with ioresult := 
ibadvalue.
.P
If (fvid <> unitable^[funit].uvid) and (fvid <> rootname(unit))
then ioresult := zmediumchanged (for removable media protection)

.H 2 "Volume class calls"
These don't deal with specific files, but instead set up information on
how the DAM should handle the unit or all files on it.
.P
The FIB need not be open (it can be, but be careful, ffpw has
part of the filename for an open FIB). Funit is the unit to which the 
DAM applies the call, and fvid should be the name of funit.

.AL
.LI "login"
Ftitle is reserved for user logname, ffpw is the passwd you wish 
to use (/etc/passwd unsupported in 3.2), the new_value is the user number.
.P
3.2 Version specifics:
.P
There is one "secret" password that works, and new_value is
ignored.
If the password matches the ffpw, "superuser" mode is set.
If ffpw is '' or does not match the secret word, then default 
uid/gid are set.
In superuser mode, you have uid=0, gid=1, and permissions are completely
ignored.
Default (the only state other than "superuser" in 3.2) is uid=PAWS_UID,
and gid=WS_GID (PAWS_UID and WS_GID are 17 and 9 respectively and are
exported from HFSTUFF). 
.P
If future versions support /etc/passwd, then ftitle is treated as 
user name (if we support login by name), new_value is NOT ignored if 
we support login by user number, and gid is set from /etc/passwd 
if login is successful.
.P
Failure conditions:
.br
(ffpw <> '') and (ffpw <> secretpassword) ==> ioresult := ibadpass
.LI "umask
new_value is the lower 9 bits of umask (in decimal) for the unit.
Umask in the DAM gets set to new_value binand 511.
.LE

.H 2 "File class calls"
These deal with specific files and inodes, and can modify the inodes of the
files as below.
.P
Except for the open call, the FIB is expected to be open
on a file or directory.
Openfile, createfile, overwritefile, and opendirectory all are adequate.
Openparentdir prepares the FIB for setpasswords calls on the parent directory.
The pathid is the file inode, foldfileid is the parent inode of the
file, ftid+ffpw is the basename of the file, funit is the unit
number.
If pathid = no_inode, or pathid = raw_inode, the FIB is
considered closed, and ioresult := inotopen, otherwise an error
could occur during get_inode(pathid), which causes exit from DAM.
At exit the FIB may have been changed.
.P
For open, ftitle is a path, and pathid, foldfileid are ignored.
The FIB is prepared for other file class calls on the file or
directory represented by the ftitle, if there is no traversal
error. The only permissions needed for open are x permissions
down to but not including the target file/dir. The FIB will
be left not freadable, not fwriteable after open. Open can be used
on any file type (eg pipes, etc).
.P
The open command can also be used to open a file for a later catpasswords
call.
.AL
.LI "open"
.br
new_value is ignored.
.LI "chmod"
.br
new_value is the lower 12 bits of the inode mode. The FILER should mask
to only the lower 9 bits before calling chmod. Mode is set to
new_value binand 4095.
.LI "chown"
.br
new_value is the owner number. It is valid in the range 0..65535.
.LI "chgrp"
.br
new_value is the group number. It is valid in the range 0..65535.
.LI "chatime"
.br
new_value is the time in seconds since midnight 1-Jan-70 to which 
di_atime is to be set.
.LI "chmtime"
.br
new_value is the time in seconds since midnight 1-Jan-70 to which 
di_mtime is to be set.
.LE
.P
To do a chmod, chown or chgrp owner permissions are rquired.
For the other commands in this class you need owner or write permission.
.P
It is possible to pass several commands to setpasswords.
However open can only be passed as the first command, otherwise it will
result in an ibadvalue error.
All the other commands can be called more than once (in one setpasswords call).

.H 1 "Catpasswords DAM call in HFS"
Catpasswords returns information on the current "login" state in HFSDAM
if the FIB passed in (pathid) indicates an non opened file/directory.
Specifically, it returns information that is complementary to the 2
"volume class" subcalls of setpasswords, login and umask.
.P
If the FIB passed in indicates an opened file this call returns uid, gid
and mode of this file.
In this case the file has to be opened with either the setpasswords
open call or with openfile, opendirectory, openparentdirectory or 
createfile.
In other words catpasswords takes a FIB that has been set up in the same way
as for setpasswords.
Fwindow however is a pointer to an h_catpasswd_ids.
