.fi
.ce
.ul
CATSEYE Support in PAWS 3.21
.sp
PAWS 3.21 will be the first version to support the CATSEYE displays. There
are 3 versions of the CATSEYE display:
.AL
.LI
LCC - Low Cost Color CATSEYE. This is intended to be a "replacement" 
for hexagon.
It has 6 planes (2 overlay, 4 display), 1024 x 768 displayable pixels, 1MB of 
framebuffer (1/4 MB
off-screen). No flashing H/W cursor.
.LI
HRM - High Resolution Monochrome CATSEYE. A new model, it has 2 planes (1
overlay, 1 display), no color capability, 1280 x 1024 displayable pixels,
2MB of framebuffer (3/4 MB offscreen). No flashing H/W cursor.
.LI
HRC - High Resolution Color CATSEYE. Another new model, it has 10 planes
(2 overlay, 8 display), 1280 x 1024 displayable pixels, 2MB of framebuffer
(3/4 MB offscreen). No flashing H/W cursor.
.LE
.SP 
HRM and HRC are collectively referred to as HRX.
.SP
PAWS 3.21 will provide "soft framebuffer" support for all of these models.
It will not employ any line-drawing or other "graphics engine" hardware built
in to any of these, except for using the window-mover for character writes
and screen clears. Both alpha and DGL graphics support will be provided.
.SP
CATSEYE will be supported on all S300 SPUs supported at PAWS 3.2 release
(expected list 310, 320, 330, 350).
.SP
Following are two detailed explanation sections, one each for the alpha 
driver
and the DGL driver. Interactions 
between the alpha and DGL drivers are explained in
the appropriate sections.
.bp
.ul
CATSEYE Alpha Support
.SP
A new driver will be written to handle all 3 CATSEYE versions. 
A new driver is desirable 
because there are architectural, timing, and feature differences between
CATSEYE and its nearest relative, Topcat (Bobcat display driver hardware).
We expect that this new driver will also provide average 2X - 3X performance
increase in character writing speed over Topcat displays on the same CPU,
especially for dense text. This is due to a minor internal redesign of the 
driver, which is based on the CRTC driver.
.SP
The new driver will be called CRTE, and will be supplied in the INITLIB file 
on the BOOT2: disc.
.SP
CRTE will have similar functionality to CRTC, except it will not support
a flashing cursor. CATSEYE hardware does not support a flashing cursor.
.SP
CRTE will support CATSEYE at control address $560000 in DIO I space (this
is an internal select code, not a "real" or external one), and in DIO II
space at any DIO II select code from 132 to 255.
.SP
The driver provides capabilities/support as follows:
.SP
.nf
.ne 22
                   |                      Model
     Function      |     LCC        |      HRM        |       HRC 
================== | ============== | =============== | ================
Screenpix width    |     1024       |     1280        |      1280       
Screenpix height   |      768       |     1024        |      1024       
Width  (characters)|      128       |      128        |       128       
Height (lines)     |       48       |       51        |        51       
Print lines        |       47       |       50        |        50       
Font char width    |        8       |       10        |        10       
Font char height   |       16       |       20        |        20       
Typeahead length   |      119       |      119        |       119       
Background color   |    black       |    black        |     black       
Alpha color        |    white       |    white        |     white       
Language           |  based on kbd  |   based on kbd  |   based on kbd
Font style         |in graphics ROM | in graphics ROM | in graphics ROM
Number font chars  |  3 x 128       |  3 x 128        |   3 x 128       
Cursor style       | 2 x 8 underbar |  2 x 8 underbar |  2 x 8 underbar 
Cursor color       |    white       |    white        |     white       
DGL interaction    |share DGL planes| share DGL planes| share DGL planes
Togglealpha        | disabled       | disabled        |  disabled       
Togglegraphics     | disabled       | disabled        |  disabled       
Default colormap   | same as 98547A |  no colormap    |same as 98700-8pln
                   |                |                 |                 
.SP
.fi
Note that setup for LCC is the same as for Hexagon (98547A).
.SP
Internals users can and do change some of the above values for previously
supported displays. In general the same changes can be made the same way
for CATSEYE on PAWS as they were for Topcat on PAWS.
Values which can be changed and their ranges are:
.SP
Width in characters:		
.in +3
any n, 20 <= n <= <screenpix width> div <character width> 
.in -3
.SP
Height in lines:		
.in +3
any n, 1 <= n <= <screenpix height> div <character height>
.in -3
.SP
Background color: 
.in +3
changed by changing color map entry 0 (LCC/HRC only).
.in -3
.SP
Alpha color:	
.in +3
changed by sending characters 136..143 to CRT (can be disabled) (LCC/HRC only). 
.br
Also 
changed by changing color map entries 0..7 (LCC/HRC only).
.in -3
.SP
Language:	
.in +3
Language automatically selected based on keyboard installed at bootup.
.in -3

.bp
.ul
CATSEYE DGL Support
.SP
DGL will support all CATSEYEs as "soft frame buffers". 
Except for graphics_clear, all drawing operations will be done by the CPU, 
rather than by
the CATSEYE assist hardware.
.SP
DGL will normally access CATSEYE using either address 3 or 6 in the 
display_init call.
In DGL, 3 talks to the current console device (which could be a CATSEYE), while
6 accesses an alternate "internal" graphics display (which could be CATSEYE,
when alpha is being displayed on some other device).
.SP
CATSEYE hardware cannot
be used in DIO I address space, except at the "select code" that corresponds
to 3 or 6; therefore display_init (3.. or display_init(6.. are the only
ways to access it from DGL in DIO I space.
.SP
DGL will support CATSEYE in DIO II address space. 
In DIO II space, CATSEYE will be
specified by passing display_init a select code between 132 and 255 (the
only select codes recognized by DIO II).
.SP
DGL will provide monochrome graphics on HRM, 64 colors (same as hexagon) on
LCC, and 256 colors on HRC. Resolutions will be 1024 x 752 on LCC, and
1280 x 1004 on HRx, increasable to 1024 x 768 on LCC and 1280 x 1024 on HRx
by disabling typeahead.
.SP
All DGL display functions that are applicable to raster displays will be
functional with CATSEYE, with the note that HRM supports only monochrome
graphics. LCC will default to the same color map as 98547A, and HRC will
default to the same color map as 98700-8plane. This is the same color map
that is used by the alpha driver.
.bp
