.fi
.ce
PAWS 3.21 Project ERS
.SP
.SP
PAWS 3.21 is a "maintenance" revision. It features no major enhancements.
Its purpose is to provide support for new hardware in the Series 300 line and
its peripheral product lines, 
and to fix bugs that have showed up from previous revisions.
.SP
The MUSTS for the project are:
.AL
.LI
CATSEYE support (all of 98548A, 98549A, 98550A) for both alpha and DGL
graphics.
.LI
VME (98646A) support in 3.21, and on models 330 and 350.
.LI
Fix or otherwise resolve all bugs known at MR time with weights >= 5.
.LE
.SP
The HIGH WANTS are:
.SP
.AL
.LI
Support PAINTJET as an alpha color printer, and a color dump device both
from the keyboard "dump" keys and from DGL.
.LI
Qualify ECC memory boards for use with PAWS3.21.
.LE
.SP
The WANTS are:
.SP
.AL
.LI
Fix or otherwise resolve all bugs known at MR time with weights < 5.
.LI
Qualify 68030 and 68882 on PAWS 3.21.
.LE
.SP
All MUST items will be included. High wants and wants will 
be chosen for implementation
according to priority, available time, available manpower.
.SP
Detailed descriptions follow, where warranted.
.bp
.fi
CATSEYE Support in PAWS 3.21
.sp
PAWS 3.21 will be the first version to support the CATSEYE displays. There
are 3 versions of the CATSEYE display:
.AL
.LI
LCC - Low-cost-CATSEYE. This is intended to be a "replacement" for hexagon.
It has 6 planes (2 overlay, 4 display), 1024 x 768 displayable pixels, 1MB of 
framebuffer (1/4 MB
off-screen). No flashing H/W cursor.
.LI
HRM - High Resolution Monochrome CATSEYE. A new model, it has 2 planes (1
overlay, 1 display), no color capability, 1280 x 1024 displayable pixels,
2MB of framebuffer (3/4 MB offscreen). No flashing H/W cursor.
.LI
HRC - High Resolution Color CATSEYE. Another new model, it has 10 planes
(2 overlay, 8 display), 1280 x 1024 displayable pixels, 2MB of framebuffer
(3/4 MB offscreen). No flashing H/W cursor.
.LE
.SP 
HRM and HRC are collectively referred to as HRX.
.SP
PAWS 3.21 will provide "soft framebuffer" support for all of these models.
It will not employ any line-drawing or other "graphics engine" hardware built
in to any of these, except for using the window-mover for character writes
and screen clears. Both alpha and DGL graphics support will be provided.
.SP
CATSEYE will be supported on all S300 SPUs supported at PAWS 3.2 release
(expected list 310, 320, 330, 350).
.SP
Following are two detailed explanation sections, one each for the alpha 
driver
and the DGL driver. Interactions 
between the alpha and DGL drivers are explained in
the appropriate sections.
.bp
CATSEYE Alpha Support
.SP
A new driver will be written to handle all 3 CATSEYE versions. 
A new driver is desirable 
because there are architectural, timing, and feature differences between
CATSEYE and its nearest relative, Topcat (Bobcat display driver hardware).
We expect that this new driver will also provide average 2X - 3X performance
increase in character writing speed over Topcat displays on the same CPU,
especially for dense text. This is due to a minor internal redesign of the 
driver.
.SP
The new driver will be called CRTE. It will be provided on the discs BOOT:
and BOOT2:, so as to be available for initial booting, as shipped. This will
require some other driver be removed from BOOT:. The driver xxx will be removed
from BOOT: (both single and double-sided versions), and placed on CONFIG:.
.SP
CRTE will have similar functionality to CRTC, except it will not support
a flashing cursor. CATSEYE hardware does not support a flashing cursor.
.SP
CRTE will support CATSEYE at control address $560000 in DIO I space (this
is an internal select code, not a "real" or external one), and in DIO II
space at any DIO II select code from 132 to 255.
.SP
The driver provides capabilities/support as follows:
.SP
.nf
.ne 22
                   |                      Model
     Function      |     LCC        |      HMC        |       HCC 
================== | ============== | =============== | ================
Screenpix width    |     1024       |     1280        |      1280       
Screenpix height   |      768       |     1024        |      1024       
Width  (characters)|      128       |      128        |       128       
Height (lines)     |       48       |       51        |        51       
Print lines        |       47       |       50        |        50       
Font char width    |        8       |       10        |        10       
Font char height   |       16       |       20        |        20       
Typeahead length   |      119       |      119        |       119       
Background color   |    black       |    black        |     black       
Alpha color        |    white       |    white        |     white       
Language           |  based on kbd  |   based on kbd  |   based on kbd
Font style         |in graphics ROM | in graphics ROM | in graphics ROM
Number font chars  |  3 x 128       |  3 x 128        |   3 x 128       
Cursor style       | 2 x 8 underbar |  2 x 8 underbar |  2 x 8 underbar 
Cursor color       |    white       |    white        |     white       
DGL interaction    |share DGL planes| share DGL planes| share DGL planes
Togglealpha        | disabled       | disabled        |  disabled       
Togglegraphics     | disabled       | disabled        |  disabled       
Default colormap   | same as 98547A |  no colormap    |same as 98700-8plane
                   |                |                 |                 
                   |                |                 |                 
.SP
.fi
Note that setup for LCC is the same as for Hexagon (98547A).
.SP
Internals users can and do change some of the above values for previously
supported displays. In general the same changes can be made the same way
for CATSEYE on PAWS as they were for Topcat on PAWS.
Values which can be changed and their ranges are:
.SP
Width in characters:		
.in +3
any n, 20 <= n <= <screenpix width> div <character width> 
.in -3
.SP
Height in lines:		
.in +3
any n, 1 <= n <= <screenpix height> div <character height>
.in -3
.SP
Background color: 
.in +3
changed by changing color map entry 0 (LCC/HCC only).
.in -3
.SP
Alpha color:	
.in +3
changed by sending characters 136..143 to CRT (can be disabled) (LCC/HRC only). 
.br
Also 
changed by changing color map entries 0..7 (LCC/HCC only).
.in -3
.SP
Language:	
.in +3
Language automatically selected based on keyboard installed at bootup.
.in -3

.bp
CATSEYE DGL Support
.SP
DGL will support all CATSEYEs as "soft frame buffers". 
Except for graphics_clear, all drawing operations will be done by the CPU, 
rather than by
the CATSEYE assist hardware.
.SP
DGL will normally access CATSEYE using either address 3 or 6 in the 
display_init call.
In DGL, 3 talks to the current console device (which could be a CATSEYE), while
6 accesses an alternate "internal" graphics display (which could be CATSEYE,
when alpha is being displayed on some other device).
.SP
CATSEYE hardware cannot
be used in DIO I address space, except at the "select code" that corresponds
to 3 or 6; therefore display_init (3.. or display_init(6.. are the only
ways to access it from DGL in DIO I space.
.SP
DGL will support CATSEYE in DIO II address space. 
In DIO II space, CATSEYE will be
specified by passing display_init a select code between 132 and 255 (the
only select codes recognized by DIO II).
.SP
DGL will provide monochrome graphics on HRM, 64 colors (same as hexagon) on
LCC, and 256 colors on HRC. Resolutions will be 1024 x 752 on LCC, and
1280 x 1004 on HRx, increasable to 1024 x 768 on LCC and 1280 x 1024 on HRx
by disabling typeahead.
.SP
All DGL display functions that are applicable to raster displays will be
functional with CATSEYE, with the note that HRM supports only monochrome
graphics. LCC will default to the same color map as 98547A, and HRC will
default to the same color map as 98700-8plane. This is the same color map
that is used by the alpha driver.
.bp
.fi
PaintJet Support in PAWS 3.21
.SP
PAWS 3.21 will be the first version to support the PaintJet graphics
printer.
.SP
PaintJet will be supported both with the least-common-denominator printer
driver (primary-color alpha, and monochrome alpha and graphics dump), and
with a set of user-installable dump drivers, which dump alpha and graphics
in color. In DGL, it will support screen dumps the way Quietjet does
(monochrome black), or in color; the user passes a parameter to the dump
procedure, specifying which of two color dump algorithms to use, when
color dump is needed.
.SP
PaintJet Non-DGL Operation
.SP
PAWS does not know what printer is connected to the SPU. It assumes that
a printer is there, and assumes it can understand lowest-level PCL. It makes
the assumption that the printer is monochrome. However the printer driver does
not try to interpret the outgoing data stream, so essentially any data can be
sent to the printer device.
.SP
This lack of knowledge of device type makes it impossible for us to choose
or vary printer driver operation to tune it to the printer, without MAJOR
development. The problem is complex, and any solution would ultimately 
be heuristic. We choose to solve it by defaulting to the LCD 
(Least-Common-Denominator) driver.
.SP
Therefore, we will supply the existing pre-3.21 LCD driver in the INITLIB 
that we ship, and will make
available extra dump drivers on auxiliary existing discs (DOC:). The user 
will be
charged with deciding whether he/she wants extra capability, and has the 
appropriate printer H/W. Once the decision is made, installing the selected
driver merely requires executing the object file from the supplied disc, or
including it in INITLIB in order to make installation more permanent.
.SP
We will also provide source for these extra drivers (on DOC:), as they are very 
"hackable" code, and do not require MODCAL for compilation. The sources will be
heavily commented, but we will not document modifying them in any of the
product manuals. For this reason, and for the reason that the dump drivers
are not "real" autoconfiguring drivers, they will be supplied on DOC:,
rather than on CONFIG: or ACCESS:.
.SP
Characteristics of alpha operation:
.SP
Control characters in the data stream will do any special control of the
printer functions. This is very similar to ThinkJet and QuietJet operation.
The user reads the printer manual to discover printer capabilities, and their
control character sequences, then inserts them in the data stream.
.SP
.nf

    eg. WRITELN(LISTING,'Hello '#27'&v1Sworld'#27'&v0S'); {untested code}
    prints 'Hello ' in black text, then 'world' in red, on one line

.fi
Unfortunately, this control language is different than that used for the
CRT driver, and the colors have different indices. The same effect 
(swapping black and white) on the CRT is achieved with:
.SP
.nf

    eg. WRITELN(LISTING,'Hello '#137'world'#136); {untested code}
    prints 'Hello ' in white text, then 'world' in red, on one line

.fi
There is no intent to attempt to have the OS match these up in either 
the printer or the alpha CRT driver. Application writers must account for the
difference, as is true for all other printers in all PAWS revs.
.SP
If pre-3.21 code which accesses a printer is run, operation will be 
indistinguishable from, for example, QuietJet operation. 
This provides a backwards compatible default.
.SP
.SP
Screen dump driver
.SP
We will provide flexibility in the screen dump driver when targeting
PaintJet. The screen dump driver is invoked by pressing the "DUMP GRAPHICS"
key (shift f7 on ITF), or by calling dumpgraphicshook from a program.
On bitmapped displays the alpha and graphics dumps are the same; on alpha
machines, they are different. The object code supplied will always take over
both alpha and graphics dump drivers on bitmapped displays. If the user 
wishes more selectivity,
he or she may edit and recompile the sample sources provided.
.SP
Characteristics of screen dump drivers:
.SP
.nf
.ne 10
                        |                   Driver 
    Characteristic      |       LCD     |  linesdump    | areadump
======================= | ============= | ============= | ==========
pixel mapping across    |     1:1       |     1:2       |    1:2   
pixel mapping down      |     1:1       |     1:2       |    1:2   
print rotation          |      0        |    90 deg     |   90 deg
color transform         |to mono (black)| 2x2 cell appx |error distribution
speed                   |printer speed  |< printer speed|<< printer speed
                        |               |               | 
.fi
.SP
The "pixel mapping" says how many printer pixels will be generated for
each screen pixel. The color dumps will both expand each screen pixels to
a 2x2 cell, to increase color accuracy.
.SP
Note that LCD may "lose" some pixels from the right of the screen, if the
screen has many pixels across. The color drivers may lose pixels from the
bottom of the screen, if the screen is "deep", and may spread the dump across
more than one page.
.SP
The LCD dump screen driver treats PaintJet as a mono black 
dump device. The linesdump driver
is good for dumping color text, line drawings, etc with accurate pixel 
representations at the cost of color accuracy. The areadump will dump filled 
areas, etc with reasonable color accuracy, at the possible expense of
lost pixels, blurriness, etc. The user can choose what is best for him
or her by installing the desired version. The non-internals user cannot 
switch freely among the drivers.
.SP
.SP
.nf
Proposed filenames:
	LINESDUMP	(object code file)
	AREADUMP	(object code file)
	LINESDUMP.TEXT	(source code file)
	AREADUMP.TEXT	(source code file)
.fi
.SP
No source is currently provided for the LCD driver. The oject for this driver
is contained in one of CRT/CRTB/CRTC/CRTD (or CRTE), depending on the CRT used.
.bp
PaintJet DGL Operation
.SP
.SP
DGL provides a procedure for doing many kinds of device dependent operations.
One use is to dump the current graphics screen (not DGL "window") to the system
printer. The procedure takes an "opcode" parameter, which tells it what 
operation to perform. We will add 2 new opcodes to request pixel-accurate
color dumps, and color-optimized dumps, corresponding respectively to the
"linesdump" and "areadump" characteristics
noted in the alpha screen dump table above.
.SP
The standard dump screen driver treats PaintJet as a mono black 
dump device. The linesdump driver
is good for dumping color text, line drawings, etc with accurate pixel 
representations at the cost of color accuracy. The areadump will dump filled 
areas, etc with reasonable color accuracy, at the possible expense of
lost pixels, blurriness, etc. The user can choose what is best for him
or her by invoking the dump procedure with the appropriate request parameter.
Existing code will run as before, with a PaintJet substituting nicely for a
QuietJet.
.SP
.SP
.nf
The procedure is called output_esc, and currently defined opcodes are:
	52:	mono 1:1 no-rotation dump
	54:	used only for 98542A and 98543A
.SP
.SP
Proposed new opcodes are:
	1055:	corresponds to linesdump
	1056:	corresponds to areadump
.fi
.SP
.SP
Opcodes 1055 and 1056 "expect" a PaintJet as the system printer, and may
produce strange results if some other printer is connected. They support only
the following display models:
.nf
.SP
98545A, 98547A, 98549A, 98550A, and 98700A 4 and 8 plane.
.fi
.SP
They will not support 9836C or 98627A (Moonunit).
