.fi
.ce
CATSEYE Support in PAWS 3.21
.sp
PAWS 3.21 will be the first version to support the CATSEYE displays. There
are 3 versions of the CATSEYE display:
.AL
.LI
LCC - Low-cost-CATSEYE. This is intended to be a "replacement" for hexagon.
It has 6 planes (2 overlay, 4 display), 1024 x 768 displayable pixels, 1MB of 
framebuffer (3/4 MB
off-screen). No flashing H/W cursor.
.LI
HMC - High Resolution Monochrome CATSEYE. A new model, it has 2 planes (1
overlay, 1 display), no color capability, 1280 x 1024 displayable pixels,
2MB of framebuffer (3/4 MB offscreen). No flashing H/W cursor.
.LI
HCC - High Resolution Color CATSEYE. Another new model, it has 10 planes
(2 overlay, 8 display), 1280 x 1024 displayable pixels, 2MB of framebuffer
(3/4 MB offscreen). No flashing H/W cursor.
.LE
.SP
PAWS 3.21 will provide "soft framebuffer" support for all of these models.
It will not employ any line-drawing or other "graphics engine" hardware built
in to any of these. Both alpha and DGL graphics support will be provided.
.SP
CATSEYE will be supported on all S300 SPUs.
.SP
Following are four detailed explanation sections, one each for the alpha 
driver, the alpha driver internals,
the DGL driver, and one for the DGL drivers internals. Interactions 
between the alpha and DGL drivers are explained in
the appropriate sections.
.bp
.ce
Alpha Support
.SP
A new driver will be written to handle all 3 CATSEYE versions. 
A new driver is desirable 
because there are architectural, timing, and feature differences between
CATSEYE and its nearest relative, Topcat (Bobcat display driver hardware).
.SP
The new driver will be called CRTE.
.SP
CRTE will have similar functionality to CRTC, except it will not support
a flashing cursor. CATSEYE hardware does not support a flashing cursor.
.SP
CRTE will support CATSEYE at control address $560000 in DIO I space (this
is an internal select code, not a "real" or external one), and in DIO II
space at any DIO II select code from 132 to 255.
.SP
The driver will wake up in a default mode as follows:
.SP
.nf
.ne 22
                   |                       Model
     Function      |     LCC        |      HMC        |       HCC 
================== | ============== | =============== | ================
Screenpix width    |     1024       |     1280        |      1280       
Screenpix height   |      768       |     1024        |      1024       
Width  (characters)|      128       |      128        |       128       
Height (lines)     |       48       |       51        |        51       
Print lines        |       47       |       50        |        50       
Font char width    |        8       |       10        |        10       
Font char height   |       16       |       20        |        20       
Typeahead length   |      119       |      119        |       119       
Background color   |    black       |    black        |     black       
Alpha color        |    white       |    white        |     white       
Language           |  based on kbd  |   based on kbd  |   based on kbd
Font style         |in graphics ROM | in graphics ROM | in graphics ROM
Number font chars  |  3 x 128       |  3 x 128        |   3 x 128       
Cursor style       | 2 x 8 underbar |  2 x 8 underbar |  2 x 8 underbar 
Cursor color       |    white       |    white        |     white       
DGL interaction    |share DGL planes| share DGL planes| share DGL planes
Chr(136..144) color|  enabled       | disabled        |   enabled       
Togglealpha        | disabled       | disabled        |  disabled       
Togglegraphics     | disabled       | disabled        |  disabled       
                   |                |                 |                 
                   |                |                 |                 
                   |                |                 |                 
.SP
.fi
Most of these defaults, as well as other properties, will be changeable by the
internals programmer. Defaults for LCC are the same as for Hexagon (98547A).
Values which can be changed and their ranges are:
.SP
Screenpix width: 
.in +3
any n, 0 <= n <= actual displayable pixel width
.in -3
.SP
Screenpix height: 
.in +3
any n, 0 <= n <= actual displayable pixel height
.in -3
.SP
Width:		
.in +3
any n, 0 <= n <= <screenpix width> div <character width> + <intercharacter
spacing>
.in -3
.SP
Height:		
.in +3
any n, 0 <= n <= <screenpix height> div <character height> + <interline
spacing>
.in -3
.SP
Print lines:    
.in +3
any n, up to <height> (typeahead interaction possible)
.in -3
.SP
Background color: 
.in +3
changed by changing color map entry 0 (LCC/HCC only).
.br
changed to transparent (all CATSEYE), ie only "on" pixels in font
character affect screen.
.in -3
.SP
Alpha color:	
.in +3
changed by sending characters 136..143 to CRT (can be disabled) (LCC/HRC only). 
.br
Also 
changed by changing color map entries (LCC/HCC only). Can use any color
in color map.
.in -3
.SP
Language:	
.in +3
changeable to map kana instead of roman8 or vice versa for characters 128..255.
.in -3
.SP
Font char width:
.in +3
any n, 1 <= n <= <screenpix width>
.in -3
.SP
Font char height: 
.in +3
any n, 1 <= n <= <screenpix height>
.in -3
.SP
Font style:	
.in +3
changeable to any pattern for any character. 
.in -3
.SP
Number font characters: 
.in +3
Font indexing to <= 32767 (8-bit, 14-bit, or 16-bit
character indexing)
.in -3
.SP
Cursor style:	
.in +3
any character cell size pattern. Cursor replacement rule can be
changed to allow "blot", complementing, etc cursor.
.in -3
.SP
Cursor color:	
.in +3
any color in color map (LCC/HCC only)
.in -3
.SP
DGL interaction:
.in +3
changeable to allow separate alpha/graphics planes (LCC/HCC
only [note: can support on HRM if we use "phantom plane" for display. This is
advised against by H/W ERS]).
.br
number alpha planes = n, 0 <= n <= <number hardware planes>
.br
number DGL planes = m, m = <number hardware planes> - <number alpha planes>
.br
Alpha may dominate DGL, or vice versa (depends on user
changing color map entries).
.br
Alpha planes should always be high-order block of planes,
DGL planes will be remaining low-order planes.
.in -3
.SP
Chr(136)..chr(143) color:
.in +3
can be disabled so these are printed as graphic characters.
.in -3
.SP
Togglealpha:
.in +3
can be usefully enabled when alpha/graphics plane split is in effect.
.in -3
.SP
Togglegraphics:
.in +3
can be usefully enabled when alpha/graphics plane split is in effect.
.in -3
.bp
.ce
Alpha Driver Internals ERS
.SP
A new record will be added to SYSDEVS to provide the above flexibility, as
well as some capabilities yet to be described.
The record will be called crtparamrec, defined as below:

.nf

type

fontopcodetype = (getfontchar, putfontchar, swapfontchar,
		  getcursorchar, putcursorchar, swapcursorchar);

fontdatatype = packed array[0..maxint] of byte;

fontdataptr = ^fontdatatype;	{must point to word boundary }

fontproctype = procedure(opcode:fontopcodetype; fontindex:integer;
			 anyvar fontdata:fontdatatype; var ok:boolean);
			 
fontinforec = record
	charwidth,			{defaults 	: LCC = 8, 16 }
	charheight	: shortint;			: HxC = 10, 20 }
	
	fb_fontstartx,			{defaults: LCC = (0,768) }
	fb_fontstarty	: shortint;	{          HxC = (1024,0) }
	fb_fontchars_per_line,    	{defaults: LCC = 128 }
					{          HxC = 96 }
	fb_fontlines	: integer;	{defaults: LCC = 3 }
					{          HxC = 4 }

	nfontchars	: integer;	{default = 3 x 128 }
	
	fontextend	: fontdataptr;	{default = NIL}
	
	fb_cursorstartx,		{defaults: LCC = (800,128) }
	fb_cursorstarty	: shortint;	{	   HxC = (1792,32) }
	cursorcolor	: integer;	{default = 2^<hardware planes>-1}
	
	fontproc	: fontproctype; {default = dummyfontproc}
      end;

type
	fontmovecount 	= (onemove, twomoves);
	charcodesize	= (c8bit, c14bit, c16bit);
	colormap_proc_type = procedure(index : integer; r, g, b : integer);
	
crtiocontrolrec = record
	alphaplanes	: integer;	{binary pattern of form 11..00}
	
	writexoffset,			{pixel offsets for lower left corner}
	writeyoffset	: integer;
	
	font_replrule1,			{repl rule for move 1, 0..15 }
	font_replrule2	: shortint;	{repl rule for move 2, 0..15 }
	nfontmoves	: fontmovecount;{one or two moves per character }
	
	cursor_replrule	: shortint;	{rule 0..15 }
	
	char_code_size	: charcodesize;	{for decoding input buffer, as single
					 chars, or words (14 or 16 bit) }
	
	togglealpha,		{TRUE=disable alpha planes display when 
				 alphastate=TRUE }
	togglegraphics,		{TRUE=disable graphics planes display when 
				 graphicstate=TRUE }
	copy_under_cursor,	{TRUE=save char pattern before writing
				 cursor, restore after removing cursor }
	use_fib_xy,		{FALSE=ignore fxpos, fypos from fib}
	disable_low_ctl,	{TRUE=chr(0)..chr(31) not interpreted}
	disable_hi_ctl,		{TRUE=chr(128)..chr(143) not interpreted}
	copy_to_abuf	: boolean; {TRUE=copy input to abuf for dump alpha}

	set_colormap_proc	: colormap_proc_type; {sets ANY colormap entry}
      end;

crtparamrec = record
	fontinfo	: fontinforec;
	iocontrol	: crtiocontrolrec;
	capabilities	: capability_descriprec;
      end;

var
	crtparams : crtparamrec;


.fi
Fonts in the CRTE driver will be stored in a line-plane-row major sequence. 
Font characters will each reside in only one plane of the offscreen area,
and CATSEYE's ability to blit from one plane to many, and control color
by setting FBEN will used to move the character to the appropriate planes.
Line-plane-row major order means that if there is
more than 1 hardware plane, fonts will be stored this way:
.nf
	fill up the first line of fontchars
	goto next plane and fill up the line "underneath" the last one
	when all planes filled, got to next row down (line) and start again
.fi
The sequence is then x-axis, plane-depth axis, y-axis. Planes fill from
LSB to MSB.
.SP
This approach leaves as much real-estate open as possible in a rectangle
in off-screen frame-buffer for the internals user.
.bp
.ce
DGL Support
.SP
DGL will support all CATSEYEs as "soft frame buffers". Except for area fill
and graphics_clear, all drawing operations will be done by the CPU, 
rather than by
the CATSEYE assist hardware.
.SP
DGL will normally access CATSEYE using either address 3 or 6 in the 
display_init call.
In DGL, 3 talks to the current console device (which could be a CATSEYE), while
6 accesses an alternate "internal" graphics display (which could be CATSEYE,
when alpha is being displayed on some other device).
.SP
CATSEYE hardware cannot
be used in DIO I address space, except at the "select code" that corresponds
to 3 or 6; therefore display_init (3.. or display_init(6.. are the only
ways to access it from DGL in DIO I space.
.SP
DGL will support CATSEYE in DIO II address space. 
In DIO II space, CATSEYE will be
specified by passing display_init a select code between 132 and 255 (the
only select codes recognized by DIO II).
.SP
DGL will provide monochrome graphics on HRM, 64 colors (same as hexagon) on
LCC, and 256 colors on HRC. Resolutions will be 1024 x 752 on LCC, and
1280 x 1004 on HxC, increasable to 1024 x 768 on LCC and 1280 x 1024 on HxC
by disabling typeahead.
.SP
All DGL display functions that are applicable to raster displays will be
functional with CATSEYE, with the note that HMC supports only monochrome
graphics.
.bp
.ce
DGL Driver Internals ERS
.SP
DGL will be able to restrict itself to using only a least-significant-bit
subset of the planes, so as to allow CRTE to scroll alpha without affecting
graphics. To do this requires some internals knowledge. DGL will of course
lose half its colors for each alpha plane separated out.
.SP
DGL will provide (default) monochrome graphics on HRM, 64 colors on LCC,
and 256 colors on HRC. DGL will not use the 2 overlay planes on the HRC.
.SP
DGL will not steal the last four lines in the off-screen frame buffer for
area fill pattern storage. It will area fill using the CATSEYE three-operand-
replacement rule and the pattern registers. This was not an option on previous
display architectures we supported.
.SP
