		INSTRUCTIONS FOR USING BTEST

Btest is a program that allows register level access to Catseye display
boards.  It emulates commands used in the software simulator of the RUG
and BARC chips.  To compile the program, type

	cc -o btest btest.c

The program assumes that two special device files exist for each Catseye
board in the system.  Only one Catseye may be in DIO I space, all other
boards must reside in DIO II space.  Typing the command

	btest

will start the program using the default device files

	/dev/catseye
	/dev/cat_fb

where /dev/catseye is used to map in the control space, /dev/cat_fb is used to
map in the frame buffer space.  If you have more than one board installed, you
may invoke btest using as arguments device files other than the default.  For
example, typing

	btest /dev/catseye1 /dev/cat_fb1

would map in a board in the first DIO II space, assuming you had created the
appropriate devices files.  Devices files for a DIO I space and the first
DIO II space are shown below.

	0 crw-rw-rw-	1 root	other	10 0x005601 Mar 20 12:52 /dev/catseye
	0 crw-rw-rw-	1 root	other	10 0x002020 Mar 20 12:52 /dev/cat_fb

	0 crw-rw-rw-	1 root	other	10 0x010001 Mar 24 09:15 /dev/catseye1
	0 crw-rw-rw-	1 root	other	10 0x012020 Mar 24 09:16 /dev/cat_fb1



Once btest has mapped the display board, it responds with a prompt.  All 
commands are one character and must be followed by a space (ok, so it doesn't
use a real parser, but we're hardware hacks, not software) before typing
any arguments.

Btest version 6.00 supports the following commands:

	b [0] [1]       - execute display ROM
	f r address <u><l><b> - frame buffer read
	f w address <u><l><b> data - frame buffer write
	h               - help
	l               - set loop mode for next command
	q               - quit
	r address       - read register
	s file          - run old style stream file (add 0x4000)
	S file          - run new style stream file
	w address data  - write register
	x               - wait for RUG to go non-busy
	X               - wait for IRIS to go non-busy
	! [command]     - shell escape

arguments in brackets are optional.  All other arguments must be given or
btest will print an error message.  Each command is described below.

	b - execute display ROM.  This command allows you to set the state
	    of the board to what it would be following a boot up of the
	    host SPU.  It reads the contents of the ID/display ROM on each
	    display card and sets up the board accordingly.  The option 
	    '1' will execute one ROM command at a time so you can step
	    through the reset operation.  The '0' option is the same as
	    no options.

	f - frame buffer read/write.  This command allows you to read or
	    write the frame buffer.  Depending on the byte/bit per pixel
	    mode set in BARC, the data will come from or be written to all
	    planes or just one.  The 'address' argument is the address into
	    the frame buffer.  It, like all numeric fields, may be either
	    decimal or hexadecimal.  When specifying a hexadecimal number,
	    prepend the number with '0x', e.g. 0x4206 (the address of RUG
	    COMMAND register).  The fourth argument must be one of 'u', 'l'
	    or 'b' to specify upper byte, lower byte or both you wish to
	    read or write.  This corresponds to the upper and lower data 
	    strobe.  When writing to the frame buffer you must also specify
	    the data as the fifth argument.  Assuming BARC has been set up 
	    for byte/pixel accesses

		f r 0x0000 b

	    will read the first two pixels of the frame buffer and

		f w 0x0010 u 255

	    will write a single byte with all ones to pixel 16.

	h - help.  This command prints a list of available commands.

	l - set loop mode.  This command allows you to constantly (approx.
	    every 200 uS) execute the following register or frame buffer 
	    read or write command.  Hitting the <BREAK> key will return
	    the program to command level.  The commands

		l
		r 0x4800

	    will continually read the register at 0x4800 (Catseye STATUS)
	    until the <BREAK> key is hit.  It will then print out the
	    contents of the register.

	q - quit.  Exit btest.

	r - read register.  This command allows you to read a Catseye register.
	    The 'address' may be either hexadecimal or decimal.  The command

		r 0x4800

	    reads the contents of the Catseye STATUS register.		


To simplify such things as register set-up, test generation, or board
configuration, btest has the ability to execute files called stream files
which may contain any of the commands (except quit and shell escape) described
here.  These files are created by placing one command per line.  The "#"
character is treated as a comment delimiter, allowing comments to be placed
in the files.  An example of a stream file follows the command description.

	s - run old style stream file.  This command is included for
	    compatibility with the RUG - BARC chip simulator.  It adds
	    the register offset (0x4000) to all register reads and writes
	    in a stream file.

	S - run new style stream file.  This command has the same effect
	    as the 's' command but does not add the register offset.  This
	    means that all register commands must be the same as you would
	    type in from the command line.

	w - write register.  This command allows you to write a register on
	    the board with the specified data.  The command

		w 0x4210 512

	     would write 512 to the register at address 0x4210 (XSRC).

	x - wait for RUG to go non-busy.  This command should follow any
	    triggers of the RUG chip.  It prevents following commands from
	    changing the state of the board until RUG has finished its
	    current operation.

	X - wait for IRIS to go non-busy.  This command should follow any
	    read or write triggers of the IRIS chip.  It prevents following
	    IRIS accesses from corrupting the current color map read or write.

	! - shell escape.  This command spawns a csh from with btest.  An
	    option system command may be included on the line.

An example stream file follows.  Assuming the name of this file was
'demo.stream', typing the command

	S demo.stream

would load and execute it.



	# Example stream file
	# this stream file draws one of each primitive
	#
	w 0x4510 0x0100  # set V/B to Vector mode
	w 0x4512 0x0000  # set TCNTRL for no three op rule
	w 0x4514 0x0000  # set ACNTRL for byte/pixel access
	w 0x4516 0x0000  # set PNCNTRL for inner plane blits
	w 0x4500 0xff00  # set FBEN0 for all primary 8 planes enabled
	w 0x4504 0x0100  # set TCREN0 to read replacement rules from plane 0
	w 0x4508 0xff00  # set TCWEN0 to allow RR modifications on all planes
	w 0x4502 0x0300  # set PRR = source
	w 0x4506 0x0003  # set WRR = source
	w 0x450c 0x0000  # set TRR = 0
	#
	# set color
	w 0x450e 0x0300  # set COLOR0 register for color map entry 3
	#
	# set RUG up for horizontal vector (0,0) to (200,0)
	w 0x4204 0x0000  # set CONTROL for no clipping or page mode cycles
	w 0x4206 0x0010  # set COMMAND for vectors 
	w 0x4210 0       # set XSRC = 0
	w 0x4212 0       # set YSRC = 0
	w 0x4214 200     # set XDST = 200
	w 0x4316 0       # set YDST = 0 and trigger the vector
	x                # Wait for RUG or next write would bus error
	#
	# set up for non-horizontal vector (0,0) to (16,16)
	w 0x4214 0x0010
	w 0x4316 0x0010
	x 
	#
	# set up for line type horizontal vector
	w 0x420c 0xcccc  # set LTYPE register with alternating bits
	w 0x420e 0x0ee0  # set LTP for magnification factor of 2
	w 0x4206 0x0050  # set command to enable linetype
	w 0x4212 0x03ff  # YSRC = 1023
	w 0x4214 0x0100  # XDST = 256  (remember, XSRC already set to 0)
	w 0x4316 0x03ff  # YDST = 1023 and trigger
	x 
	# set up for circle
	w 0x4206 0x0030  # set COMMAND for unfilled circle
	w 0x4200 0x0200  # XCENTER = 512
	w 0x4212 0x0080  # YCENTER = 128
	w 0x430a 0x0010  # RADIUS = 16 and trigger
	x
	#
	# set up for filled circle
	w 0x4306 0x00f0  # set COMMAND for filled circle and trigger
	x
	#
	# set up for polygon fill
	w 0x4206 0x00d0  # set COMMAND for polygon fill
	w 0x4208 0x0200  # set FX with x ANCHOR point
	w 0x420a 0x0100  # set FY with y ANCHOR point
	w 0x4210 0x0200  # first x point of the triangle
	w 0x4212 0x0104  # first y point of the triangle
	w 0x4214 0x0250  # second x point of the triangle
	w 0x4316 0x0114  # second y point of the triangle and trigger
	x
	#
	# set up for a blit (blit the linetype line under the first line)
	w 0x4510 0x0000  # set VB for blit mode
	w 0x4206 0x0090  # set COMMAND for blit
	w 0x4210 0x0000  # source x
	w 0x4212 0x03ff  # source y
	w 0x4214 0x0000  # destination x
	w 0x4216 0x0011  # destination y
	w 0x4208 0x0050  # width
	w 0x430a 0x0001  # height and trigger
	x
	#
	# quit if this was streamed into btest with the command
	#              btest < demo.stream
	q

