/*****************************************************************************/
/*                                                                           */
/* hrclens : a magnification program that runs on the Catseye HRC board.     */
/*           magnify a region by 2, 4, 8 or 16.  Use the overlay planes to   */
/*           display the cursor and display window.                          */
/*                                                                           */
/* usage:    hrclens [mag] | [destx desty] | [mag destx desty]               */
/*                                                                           */
/*           where mag : magnification factor (2, 4, 8 or 16) default: 8     */
/*                 destx, desty : upper left corner of display window        */
/*                                default 0,0                                */
/*                                                                           */
/*****************************************************************************/
#include <stdio.h>
#include <starbase.c.h>
#include "graphicslib/lib.c.h1"

#define SOURCE 3
#define XOR 6

int maxx, maxy;         /* screen size */
int ovlcmap[4][3] = {
    0, 0, 0,            /* transparent */
    0, 0, 0,            /* black */
    255, 255, 255,      /* white */
    255, 0, 0 };        /* red */

main(argc,argv)
int argc;
char *argv[];
{
    int mouse;              /* input device file descriptor */
    int but_one, but_two;   /* values of mouse buttons */
    int cx, cy;             /* current cursor location */
    int done;
    int changed;            /* set if cursor has moved from last time */
    int mag;                /* magnification - 2, 4, 8 or 16 */
    int offset;             /* offset to draw cursor around blit area */
    int planes;             /* number of planes this display board has */
    int destx, desty;       /* start of enlarged area */
    unsigned char background[258][258];


    /* determine what parameters were passed to lens */
    switch (argc) {
	case 2 : mag = atoi(argv[1]);
		 destx = 0;
		 desty = 0;
		 break;
        case 3 : mag = 8;
                 destx = atoi(argv[1]);
		 desty = atoi(argv[2]);
                 break;
	case 4 : mag = atoi(argv[1]);
		 destx = atoi(argv[2]);
		 desty = atoi(argv[3]);
                 break;
        default: mag = 8;
		 destx = 0;
		 desty = 0;
                 break;
    }

    if ((mag != 2) && (mag != 4) && (mag != 8) && (mag != 16)) {
        fprintf(stderr,"Magnification must be 2, 4, 8 or 16.\n");
        exit(1);
    }


    offset = 256/mag + 1;

    /* set up mouse */
    if ((mouse = gopen("/dev/locator",INDEV,"hp-hil",INIT)) == -1)
	exit(1);
    Init(FALSE,FALSE,TRUE);

    InquirePlanes(&planes);
    if (planes != 8) {
	printf("Incorrect display card, only works on HRC.\n");
	exit(-1);
    }

    InquireSize(&maxx,&maxy);
    if (destx > maxx - 258) destx = maxx - 258;
    if (desty > maxy - 258) desty = maxy - 258;

    mapping_mode(mouse,TRUE);
    vdc_extent(mouse,0.0,0.0,0.0,(float) maxx,(float) maxy,0.0);

    /* save background where window will go */
    ReadBlock(destx,desty,258,258,background);

    /* erase area where window will go */
    InteriorStyle(FALSE,INT_SOLID);
    FillColorIndex(0);
    Rectangle(destx,desty,destx+257,desty+257);

    /* draw window in overlay planes */
    /* make sure to intialize overlay color map in case it is garbage */
    EnableOverlay(TRUE);
    ClearScreen();
    DefineColorTable(0, 4, ovlcmap);
    InteriorStyle(TRUE,INT_HOLLOW);
    LineColorIndex(2);
    Rectangle(destx,desty,destx+257,desty+257);
    DrawingMode(6);                                /* for cursor */
    EnableOverlay(FALSE);

    /* main loop */
    done = FALSE;
    while (!done) {

        read_mouse(mouse,&cx,&cy,&but_one,&but_two);

	update_cursor(cx,cy,FALSE,&changed,offset);

	if ((changed) && (but_one))
	    PixReplicate(cx+1,cy+1,destx+1,desty+1,offset-1,mag);

        if (but_two)
            done = TRUE;

    }

    /* erase cursor and drawing box */
    update_cursor(cx,cy,TRUE,&changed,offset);

    EnableOverlay(TRUE);
    DrawingMode(3);
    InteriorStyle(FALSE,INT_SOLID);
    FillColorIndex(0);
    Rectangle(destx,desty,destx+257,desty+257);
    EnableOverlay(FALSE);

    /* Restore background */
    WriteBlock(destx,desty,258,258,background);

    gclose(mouse);
}




read_mouse(fid,x,y,b1,b2)
int fid;
int *x, *y, *b1, *b2;
{
    int valid, value;
    float rx, ry, rz;

    sample_locator(fid,1,&valid,&rx,&ry,&rz);
    sample_choice(fid,2,&valid,&value);
    *x = (int) rx;
    *y = maxy - (int) ry;
    *b1 = value & 0x1;
    *b2 = value & 0x2;
}





update_cursor(x,y,erase,moved,offset)
int x, y;
int erase;
int *moved;
int offset;
{
    static int first = TRUE;
    static int oldx = 0, oldy = 0;

    *moved = ((x != oldx) || (y != oldy)); 

    /* update cursor or erase */
    if (*moved || erase) {

	EnableOverlay(TRUE);

	/* erase old cursor if this is not the first time */
        if (!first) 
	    Rectangle(oldx,oldy,oldx + offset, oldy + offset);
        else
            first = FALSE;

	/* draw new cursor if this is not an erase */
        if (!erase) 
            Rectangle(x,y,x + offset,y + offset);

        oldx = x;
        oldy = y;
	EnableOverlay(FALSE);
    }
}


