




			Catseye Graphics Library


                        FOR INTERNAL HP USE ONLY
			This library has NOT been
			formally tested and is
			intended to be used
			ONLY AS A GUIDE!!!




                            List of commands 
                            ---- -- --------

Drawing Primitives
------- ----------
	Circle
	ClearScreen
	Draw
	Line
	Move
	Polygon
	Polyline
	Rectangle


Blit Primitives
---- ----------
	BlockMove
	BlockMoveType
	PackedReadBlock
	PackedWriteBlock
	PixReplicate
	ReadBlock
	WriteBlock


Board Control
----- -------
	Close
	DefineDeviceFiles
	Init


Attribute Control
--------- -------
	AwaitVerticalRetrace
	BlinkPlanes
	ClipEnable
	ClipLimits
	DefineColorTable
	DisplayEnable
	DrawingMode
	FillColorIndex
	InteriorStyle
	LineColorIndex
	LinetypeEnable
	LoadPattern
	LoadPatterns
	SetLinetype
	WriteEnable




Inquiries
---------
	InquirePlanes
	InquirePointers
	InquireSize
	ReadColorTable


Overlay Control
------- -------
	EnableOverlay
	EnableTransparency


Pick Commands
---- --------
	ReadPickBit
	SetPickMode


Double Buffer Commands
------ ------ --------
	DoubleBuffer
	EnableDoubleBuffer


Serial Port Control
------ ---- -------
	SerialMode







NAME: AwaitVerticalRetrace - wait for vertical retrace before drawing the next
      primitive.

DESCRIPTION:
	AwaitVerticalRetrace sets an internal flag so that the next primitive
	will start drawing at the beginning of the next vertical blanking
	period.

SYNOPSIS:
	void AwaitVerticalRetrace()



NAME: BlinkPlanes - Enable or disable planes from blinking.

DESCRIPTION:
	BlinkPlanes allows the program to enable or disable planes from
	blinking.  Depending on the overlay mode the planes are either in
	the primary plane set or the overlay plane set.

SYNOPSIS:
	void BlinkPlanes(mask)
	unsigned short mask;

INPUT PARAMETERS:
	mask - a mask which determines which planes blink.  Bit 0 of the
	       mask corresponds with the least significant plane.  When
	       a bit position is set to 1 the corresponding plane will blink.

DEFAULTS:
	No planes blinking.


NAME: BlockMove - Blit a region of frame buffer memory from one location to
		  another.

DESCRIPTION:
	BlockMove allows the program to blit a rectangular region of the
	frame buffer from one location to another.  The source of the blit
	may be outside of the clip limits.  Any part of the destination outside
	of the clip limits will be clipped.  The BlockMoveType command sets 
	whether blits will be within planes or between planes.

SYNOPSIS:
	void BlockMove(sx, sy, dx, dy, w, h)
	int sx, sy, dx, dy, w, h;

INPUT PARAMETERS:
	sx, sy : the upper left hand corner of the source region.
	dx, dy : the upper left hand corner of the destination region.
	w : the width of the source region to blit.
	h : the height of the source region to blit.


NAME: BlockMoveType - set how block moves operate.

DESCRIPTION:
	BlockMoveType allows the program to select blits that are within the
	planes or blits from one plane to one or more others.  When BLIT_BETWEEN
	mode has been selected blits may occur between primary planes to or
	from overlay planes.  Otherwise blits occur in the planes selected by
	overlay mode.

SYNOPSIS:
	void BlockMoveType(type, source_plane)
	int type;
	unsigned short soure_plane;

INPUT PARAMETERS:
	type - if BLIT_WITHIN all blits take place within planes,
	       if BLIT_BETWEEN all blits will come from source_plane and
	       be broadcast to all planes that are write enabled.
	source_plane - a 4 bit quantity representing the plane to take
		       the source from.  0 corresponds to plane 0.  Note that
		       the number of planes is dependent on which display card
		       is being used.  If type = BLIT_WITHIN then source_plane
		       is ignored.

DEFAULTS:
	All blits WITHIN planes.



NAME: Circle - draw a filled or unfilled circle.

DESCRIPTION:
	Circle allows the program to draw a filled or unfilled circles of
	specified radius at a specified center point.  If edge mode has been
	set the circles are edged with current line color index and with any
	line type that has been set.  If fill mode is INT_SOLID then the 
	circle is filled with fill color index, if fill mode is INT_PATTERN
	then the circle is filled with the pattern specified by LoadPattern
	or LoadPatterns.

SYNOPSIS:
	void Circle(x, y, r)
	int x, y, r;

INPUT PARAMETERS:
	x, y - the center coordinate.
	r - the radius (should be <= 1023).




NAME: ClearScreen - Clear the displayed portion of the screen.

DESCRIPTION:
	ClearScreen allows the program to clear the displayed portion of
	the screen to color map index 0.  Depending on the overlay mode
	either the primary planes or overlay planes will be cleared.
	ClearScreen is affected by any clip limits that are smaller than
	the screen limits.  In this way, non speed critical applications 
	can clear only a portion of the screen easily.

SYNOPSIS:
	void ClearScreen()



NAME: ClipEnable - enable or disable pixel clipping in RUG.

DESCRIPTION:
	ClipEnable allows the program to enable or disable pixel clipping
	in RUG.  The clip limits are set up with ClipLimits.  Different
	clip limits may be maintained for the primary planes and the overlay
	planes.

SYNOPSIS:
	void ClipEnable(flag)
	int flag;

INPUT PARAMETERS:
	flag - set TRUE for clipping enabled, FALSE for clipping disabled.

DEFAULT:
	Clipping enabled.



NAME: ClipLimits - set DC clip limits for RUG chip.

DESCRIPTION:
	ClipLimits allows the program to set the pixel clip limits in the RUG
	chip.  Whether or not clipping actually performed depends on ClipEnable.
	Depending on overlay mode the clip limits apply for either the primary
	planes or the overlay planes.

SYNOPSIS:
	void ClipLimits(x1, y1, x2, y2)
	int x1, y1, x2, y2;

INPUT PARAMETERS:
	x1, y1 : The clip limits for the upper left corner of the clipping 
		 region.
	x2, y2 : The clip limits for the lower right corner of the clipping 
		 region.

DEFAULTS:
	x1, y1 = (0,0)
	x2, y2 = (1279, 1023) for HRC, Monochrome
	       = (1023, 767) for LCC



NAME: Close - unmap the Catseye display.

DESCRIPTION:
	Close allows the program to unmap the Catseye display card from
	virtual memory.  This command and the DefineDeviceFiles command
	allow the use of multiple display cards in a system and with one
	program.  After this command has been called, any further operations,
	except the Init command, will cause termination of the program.

SYNOPSIS:
	void Close()



NAME: DefineColorTable - allow modification of the color map.

DESCRIPTION:
	DefineColorTable allow the program to change some or all of the
	color map entries in the IRIS color map chip.  Depending on the
	overlay mode either the primary color map or the overlay color
	map will be modified.  DefineColorTable returns 0 if it was able
	to change the color map, -1 if the parameters were out of bounds.

SYNOPSIS:
	int DefineColorTable(start, num, cmap)
	int start, num;
	int cmap[];

INPUT PARAMETERS:
	start - the starting index to change.
	num - the number of entries to change, starting with the one pointed
	      to by start.
	cmap - an array (num * 3) of integers (0-255) used to define the
	       new values for the color map.  The order is

		     cmap[i][0] = red
		     cmap[i][1] = green
		     cmap[i][2] = blue



NAME: DefineDeviceFiles - set the device files to use in Init.

DESCRIPTION:
	DefineDeviceFiles allows the program to set new device files to use
	when initializing the graphics library with Init.  This procedure
	must be called prior to Init.

SYNOPSIS:
	void DefineDeviceFiles(cname, fname)
	char *cname, *fname;

INPUT PARAMETERS:
	cname - a pointer to the name of the device file to use for the
		control space, e.g. "/dev/catseye1".
	fname - a pointer to the name of the device file to use for the
		frame buffer space, e.g. "/dev/cat_fb1".

DEFAULTS:
	cname = "/dev/catseye"
	fname = "/dev/cat_fb"



NAME: DisplayEnable - enable certain planes to be displayed.

DESCRIPTION:
	DisplayEnable allows the program to set which planes are to be
	displayed.  Depending on overlay mode the planes will either
	be in the primary plane set or the overlay plane set.  Care should
	be taken when using DisplayEnable while in double buffer mode.

SYNOPSIS:
	void DisplayEnable(mask)
	int mask;

INPUT PARAMETERS:
	mask - a mask that is used to determine which planes are enabled to
	       be displayed.  The least significant bit corresponds to the
	       least significant plane.  Planes are enabled when their 
	       corresponding bits are 1.

DEFAULTS:
	All primary planes enabled.



NAME: DoubleBuffer - swap between frame buffer banks.

DESCRIPTION:
	DoubleBuffer allows the program to switch between banks of frame buffer
	planes during double buffering.  It also clears the hidden bank.
	Depending on the overlay mode, either the primary or overlay planes
	are double buffered.  DoubleBuffer has no effect if the overlay mode
	is different than what it was when double buffering was enabled.
	Only one set of planes may be active for double buffering at one time.

SYNOPSIS:
	void DoubleBuffer(flag)
	int flag;

INPUT PARAMETERS:
	flag - indicates which bank to display.  Only the least significant
	       bit is used allowing flag to be a counter.  If the the least
	       significant bit is even, the least significant planes are
	       displayed while the most significant planes are enabled to
	       be modified.



NAME: Draw - draw a line from the current position to the coordinate specified.

DESCRIPTION:
	Draw allows the program to draw a line from the current position to
	the coordinate specified.  The current position is then updated to
	the specified coordinate.  The line is drawn in a color specified
	by LineColorIndex and with any line type specified by SetLineType if
	line type is enabled.

SYNOPSIS:
	void Draw(x, y)
	int x, y;

INPUT PARAMETERS:
	x, y - the coordinate point the line is drawn to.



NAME: DrawingMode - change the current replacement rule for drawing primitives.

DESCRIPTION:
	DrawingMode allows the program to change the replacement rule used
	for all primitives.  This affects blits and pattern area fills also.
	If the mode is outside the range defined below no change occurs.

SYNOPSIS:
	void DrawingMode(mode)
	int mode;

INPUT PARAMETERS:
	mode - defines the combination of source and destination values:

	mode	resulting destination value
	----	--------------------------------------------
	  0	ZERO
	  1	source AND destination
	  2	source AND NOT destination
	  3	source
	  4	NOT source AND destination
	  5	destination
	  6	source EXCLUSIVE OR destination
	  7	source OR destination
	  8	NOT source AND NOT destination
	  9	source EXCLUSIVE NOR destination
	 10	NOT destination
	 11	source OR NOT destination
	 12	NOT source
	 13	NOT source OR destination
	 14	NOT source OR NOT destination
	 15	ONE

DEFAULTS:
	Drawing mode = 3 (source)



NAME: EnableDoubleBuffer - enable or disable double buffering.

DESCRIPTION:
	EnableDoubleBuffer allows the program to enable or disable double 
	buffering.  When enabling double buffering it intializes the color 
	map and sets the appropriate write and display masks.  When disabling
	double buffering it restores the original color map.  Depending on 
	the overlay mode, double buffering occurs in the primary planes or 
	the overlay planes.

SYNOPSIS:
	void EnableDoubleBuffer(flag)
	int flag;

INPUT PARAMETERS:
	flag - set TRUE to enable double buffering, FALSE to disable
	       double buffering.

DEFAULTS:
	Double buffering disabled.



NAME: EnableOverlay - enable following commands to use the overlay planes.

DESCRIPTION:
	EnableOverlay allows the program to use the overlay planes.  When
	overlay is enabled all following primitives will be drawn on the
	overlay planes.  When overlay is disabled all following primitives
	will be drawn to the primary planes.  This command has no effect if
	the device was not initialized to use overlay planes.

SYNOPSIS:
	void EnableOverlay(flag)
	int flag;

INPUT PARAMETERS:
	flag - set TRUE to enable use of overlay planes, FALSE to enable use
	       of primary planes.

DEFAULTS:
	All operations occur in primary planes.



NAME: EnableTransparency - set whether the overlay planes are transparent or
			   not when their value is 0.

DESCRIPTION:
	EnableTransparency allows the program to select whether the overlay
	planes are transparent when their value is 0.  If transparency is
	disabled then the color displayed will be that of entry 0 in the 
	overlay color map.  EnableTransparency has no effect if overlay
	mode was not selected.

SYNOPSIS:
	void EnableTransparency(flag)
	int flag;

INPUT PARAMETERS:
	flag - set TRUE to enable transparency, FALSE to use overlay color map
	       index 0 to determine the color.

DEFAULTS:
	Transparency is enabled.



NAME: FillColorIndex - change the current fill color

DESCRIPTION:
	FillColorIndex allows the program to change the color used in filling
	polygons, rectangles and circles.  Whether the color chosen uses
	the primary color map or the overlay color map depends on the overlay
	mode.

SYNOPSIS:
	void FillColorIndex(color)
	int color;

INPUT PARAMETERS:
	color - an index into the selected color map.  It may have the
		following ranges:

		Display     Primary     Overlay
		-------------------------------
		  HRC       0..255       0..3
		  LCC       0..63         -      (Overlay planes not selected)
		  LCC       0..15        0..3    (Overlay planes selected)
		  Mono      0..1          -  

DEFAULTS:
	Fill color index = 1



NAME: Init - Configure lib and open communication with the board.

DESCRIPTION:
	Init initializes the catseye display board.  It must be the first
	procedure called before using the display board.  Init assumes that
	two null driver dev files are installed and configured for the address 
	of the board plugged into the computer.  The dev files are:

			/dev/catseye
			/dev/cat_fb

	This procedure assumes that all IRIS timing and BARC identification
	has been done (e.g. the initialization commands stored in the ID
	ROM have been executed).  Init returns 0 for a successful 
	initialization, -1 for failure.

SYNOPSIS: 
	int Init(clr, init_cmap, overlay)
	int clr, init_cmap, overlay;


INPUT PARAMETERS:
	clr - The screen is cleared if TRUE, it is left as is if FALSE.
	init_cmap - Load a default color map if TRUE, do not change the
		    color map if FALSE.
	overlay- Enable use of overlay planes.  Note that for the LCC display 
		 card, this will restrict the number of main planes to 4. This
		 has no effect for the Monochrome card which (for this library)
		 does not support double buffering or overlay mode.



NAME: InquirePlanes - obtain the number of planes currently allocated for
      the primary drawing planes.

DESCRIPTION:
	InquirePlanes allows the program to determine how many planes are
	available for primary drawing planes.  For the LCC board this number
	may be reduced when overlay planes are enabled.

SYNOPSIS:
	void InquirePlanes(n)
	int *n;

OUTPUT PARAMETERS:
	n : the number of planes available.

DEFAULTS:
	n = 8 for HRC
	n = 6 for LCC
	n = 1 for Monochrome



NAME: InquirePointers - obtain pointers to the control space and frame
      buffer space on the display card.

DESCRIPTION:
	InquirePointers allows the program to obtain pointers to the control
	space and the frame buffer of the display card.  Register definitions
	can be found in the lib.c.h2 header file.  When using the frame
	buffer pointer, data going to the frame buffer is modified by
	the current replacement rule and write enable.

SYNOPSIS:
	void InquirePointers(control, frame_buffer)
	unsigned char **control, **frame_buffer;

OUTPUT PARAMETERS:
	control - a pointer to the control space.
	frame_buffer - a pointer to the frame buffer.



NAME: InquireSize - obtain the maximum DC coordinates of the display card.

DESCRIPTION:
	InquireSize returns the maximum x and y screen coordinates of the 
	catseye display card currently being used.

SYNOPSIS:
	void InquireSize(x, y)
	int *x, *y;

OUTPUT PARAMETERS:
	x, y : the maximum DC coordinate values.

DEFAULTS:
	x = 1023, y = 767 for LCC
	x = 1279, y = 1023 for HRC, Monochrome



NAME: InteriorStyle - set attributes for following polygon calls.

DESCRIPTION:
	InteriorStyle allows the program to set up filling mode and perimeter
	mode for polygons, rectangles and circles.

SYNOPSIS:
	void InteriorStyle(edge_mode, fill_type)
	int edge_mode, fill_type;

INPUT PARAMETERS:
	edge_mode: set TRUE to edge primitives, FALSE to not draw edges.
		   Edges are drawn with current line types.
	fill_type: set to INT_HOLLOW for no filling, INT_SOLID to fill with
		   current fill color or INT_PATTERN to fill with patterns
		   loaded with LoadPattern or LoadPatterns.

DEFAULTS:
	edge_mode = TRUE
	fill_type = INT_HOLLOW



NAME: Line - draw a line from a start coordinate to a stop coordinate.

DESCRIPTION:
	Line allows the program to draw a line from a starting corrdinate to
	a stopping coordinate.  Line updates the current position pointer to
	the stopping coordinate.  The line is drawn with the color specified
	with LineColorIndex and with any line type specified by SetLineType
	if line type is enabled.

SYNOPSIS:
	void Line(x1, y1, x2, y2)
	int x1, y1, x2, y2;

INPUT PARAMETERS:
	x1, y1 - the starting coordinate.
	x2, y2 - the stopping coordinate.



NAME: LineColorIndex - change the current line color

DESCRIPTION:
	LineColorIndex allows the program to change the color used for drawing
	vectors, unfilled circles or perimeters.  Whether the color chosen uses
	the primary color map or the overlay color map depends on the overlay
	mode.

SYNOPSIS:
	void LineColorIndex(color)
	int color;

INPUT PARAMETERS:
	color - an index into the selected color map.  It may have the
		following ranges:

		Display     Primary     Overlay
		-------------------------------
		  HRC       0..255       0..3
		  LCC       0..63         -      (Overlay planes not selected)
		  LCC       0..15        0..3    (Overlay planes selected)
		  Mono      0..1          - 

DEFAULTS:
	Line color index = 1



NAME: LinetypeEnable - enable or disable linetype.

DESCRIPTION:
	LinetypeEnable allows the program to enable or disable the use of
	linetype in vectors, polylines and edging of polygons, circles and
	rectangles.  Different linetypes may be maintained for primary planes
	and overlay planes.

SYNOPSIS:
	void LinetypeEnable(flag)
	int flag;

INPUT PARAMETERS:
	flag - set TRUE to enable linetype, FALSE to disable linetype.

DEFAULTS:
	Line type disabled.



NAME: LoadPattern - load a pattern into a single plane's pattern RAM.

DESCRIPTION:
	LoadPattern allows the program to load a 16 by 16 pixel pattern
	in the pattern RAM for one plane.  Depending on the overlay mode
	the plane that may be changed will either be a primary plane or an
	overlay plane.

SYNOPSIS:
	void LoadPattern(plane, pattern)
	int plane;
	unsigned short pattern[];

INPUT PARAMETERS:
	plane - the plane number:

		board      Primary     Overlay
		------------------------------
		 HRC        0..8        0..1
		 LCC        0..5         -       (overlay planes not selected)
		 LCC        0..3        0..1     (overlay planes selected)
		 Mono        0
	
	pattern : a pointer to an array of 16 short integers with each integer
	          representing one row in the 16 by 16 pattern.  pattern[0] 
		  corresponds with the top of the pattern (smallest y value)
		  and pattern[15] corresponds with the bottom of the pattern 
		  (largest y value).

DEFAULTS:
	Initially the pattern RAM is undefined.



NAME: LoadPatterns - load a pattern into the pattern RAM on all planes.

DESCRIPTION:
	LoadPatterns allows the program to load a 16 by 16 pixel pattern
	in the pattern RAM for all planes.  Depending on the overlay mode
	the planes affected may either be a primary planes or overlay planes.

SYNOPSIS:
	void LoadPatterns(pattern)
	unsigned char pattern[];

INPUT PARAMETERS:
	pattern : a pointer to an array of 16 by 16 char sized integers with 
		  the least significant byte of each integer representing one 
		  pixel in the 16 by 16 pixel pattern.  pattern[0][0] 
		  correspondes to the top, left most pixel (smallest x and y 
		  values) and pattern[15][15] corresponds to the bottom, right 
		  most pixel (greatest x and y values) in the pattern.

DEFAULTS:
	Initially the pattern RAM is undefined.



NAME: Move - move the current position to the coordinate specified.

DESCRIPTION:
	Move allows the program to move the current position to the coordinate
	specified without actually drawing anything.

SYNOPSIS:
	void Move(x, y)
	int x, y;

INPUT PARAMTERS:
	x, y : the new current position.



NAME: PackedReadBlock - read a packed block of frame buffer memory from one 
      plane into main memory.

DESCRIPTION:
	PackedReadBlock allows the program to read a rectangular region of one
	frame buffer plane into main memory packed 16 pixels/word.  No clipping
	is performed.  Depending on the overlay mode the plane chosen will
	either be a primary plane or an overlay plane.

SYNOPSIS:
	PackedReadBlock(sx, sy, w, h, plane, data)
	int sx, sy, w, h, plane;
	unsigned short *data;

INPUT PARAMETERS:
	sx, sy : the upper left hand corner of the region to read.
	w : the width of the region to read in pixels.
	h : the height of the region to read in pixels.
	plane : the number of the plane to read from:

		Display      Primary     Overlay
		--------------------------------
		  HRC         0..7        0..1
		  LCC         0..5         -      (overlay planes not selected)
		  LCC         0..3        0..1    (overlay planes selected)
		  Mono         0

OUTPUT PARAMETERS:
	data : a pointer to an array of 16 bit words.  Frame buffer data
	       is packed on even word boundries with the upper left most pixel
	       in the most significant bit of data[0].



NAME: PackedWriteBlock - write a packed block of main memory to one or more 
      planes of the frame buffer.

DESCRIPTION:
	PackedWriteBlock allows the program to write a rectangular region of one
	or more frame buffer plane from main memory packed 16 pixels/word.
	No clipping is performed.  Depending on the overlay mode the planes
	chosen will either be primary planes or overlay planes.

SYNOPSIS:
	PackedWriteBlock(sx, sy, w, h, plane_mask, data)
	int sx, sy, w, h;
	unsigned char plane_mask;
	unsigned short *data;

INPUT PARAMETERS:
	sx, sy : the upper left hand corner of the region to write.
	w : the width of the region to write in pixels.
	h : the height of the region to write in pixels.
	plane_mask : a mask that is used to determine which planes are enabled
		     to be modified.  Each bit is interpreted as a plane 
		     enable of that respective plane; i.e., If the least
		     significant bit is 0 then plane 1 is disabled.  If the 
		     2nd bit is 1, then plane 2 is enabled.

	data : a pointer to an array of 16 bit words.  Frame buffer data
	       is packed on even word boundries with the upper left most pixel
	       in the most significant bit of data[0].



NAME: PixReplicate - replicate a rectangular region of pixels.

DESCRIPTION:
	PixReplicate allows the program to take a small rectangular region
	and replicate each pixel by 2, 4, 8 or 16 and then display the new
	image at some other location.  The maximum size of the final region
	can be a maximum of 256 by 256 pixels.  Replication occurs on the
	planes indicated by overlay mode.  Only planes that are write
	enabled are modified.

SYNOPSIS:
	int PixReplicate(sx, sy, dx, dy, delta, mag)
	int sx, sy, dx, dy, delta, mag;

INPUT PARAMETERS:
	sx, sy : the upper left corner of the source region.
	dx, dy : the upper left corner of the destination region.
	delta : the length and width of the source rectangle.
	mag : the magnification factor (2, 4, 8, or 16).

NOTES:
	PixReplicate will return -1 if the magnification is something
	other than the allowed values.  It will also return -1 if the
	delta * mag is greater than 256.



NAME: Polygon - draw the polygon specified by the array passed to the routine.

DESCRIPTION:
	Polygon allows the program to draw a polygon.  The polygon is edged in
	a color specified by LineColorIndex if edge mode has been set by 
	InteriorStyle and with any line type specified by SetLineType.  The 
	polygon is filled in a color specified by FillColorIndex if INT_SOLID 
	mode has been set by InteriorStyle or by a pattern defined by 
	LoadPattern or LoadPatterns if INT_PATTERN mode has been set.

SYNOPSIS:
	void Polygon(num, plist)
	int num;
	int plist[];

INPUT PARAMETERS:
	num - the number of endpoints in the polygon.
	plist - a pointer to an array of points stored in [x, y] form.



NAME: Polyline - draw the polyline specified by the array passed to the routine.

DESCRIPTION:
	Polyline allows the program to draw a polyline.  The polyline is drawn
	in a color specified by LineColorIndex and with any line type specified
	by SetLineType if line type is enabled.

SYNOPSIS:
	void Polyline(num, plist)
	int num;
	int plist[];

INPUT PARAMETERS:
	num - the number of endpoints in the polyline.
	plist - a pointer to an array of points stored in [x, y] form.
		The first point is treated as a point to move to and the
		following points are drawn to.



NAME: ReadBlock - read a block of frame buffer into main memory.

DESCRIPTION:
	ReadBlock allows the program to read a rectangular region of the
	frame buffer into an array in main memory.  Depending on the
	overlay mode the data will come from primary or overlay planes.
	No clipping is performed.

SYNOPSIS:
	void ReadBlock(sx, sy, w, h, data)
	int sx, sy, w, h;
	unsigned char *data;

INPUT PARAMETERS:
	sx, sy : the upper left hand corner of the region to read.
	w : the width of the region to read.
	h : the height of the region to read.

OUTPUT PARAMETERS:
	data : a pointer to an array that is filled with data from the
	       frame buffer.  data[0] holds the upper left corner of 
	       the rectangular region.  Data is packed with the least
	       significant plane in the least significant bit of the
	       byte.



NAME: ReadColorTable - read the contents of the color map.

DESCRIPTION:
	ReadColorTable allow the program to read some or all of the
	color map entries in the IRIS color map chip. Based on the overlay
	mode data will come from the primary or overlay color map.
	ReadColorTable returns 0 if it was able to read the color map, -1 if
	the parameters were out of bounds.

SYNOPSIS:
	int ReadColorTable(start, num, cmap)
	int start, num;
	int cmap[];

INPUT PARAMETERS:
	start - the starting index to change.
	num - the number of entries to change, starting with the one pointed
	      to by start.

OUTPUT PARAMETERS:
	cmap - an array (num * 3) of integers (0-255) used to define the
	       new values for the color map.  The order is

		     cmap[i][0] = red
		     cmap[i][1] = green
		     cmap[i][2] = blue


NAME: ReadPickBit - return the value of the pick bit in RUG.

DESCRIPTION:
	ReadPickBit allows the program to inquire the status of the pick
	bit which was set by the last primitive drawn.  The pick bit will
	be set if the last primitive was drawn inside the clip limits.
	Due to the implemenation of rectangles, rectangles will operate
	correctly only when they are edged.

SYNOPSIS:
	int ReadPickBit()

OUTPUT PARAMETERS:
	ReadPickBit returns TRUE if the pick bit was set, FALSE otherwise.



NAME: Rectangle - draw a filled or unfilled rectangle.

DESCRIPTION:
	Rectangle allows the program to draw a filled or unfilled rectangle.
	If edge mode has been set the rectangle is edged with current line 
	color index and with any line type that has been set.  If fill mode is
	INT_SOLID then the rectangle is filled with fill color index, if fill 
	mode is INT_PATTERN then the rectangle is filled with the pattern 
	specified by LoadPattern or LoadPatterns.

SYNOPSIS:
	void Rectangle(x1, y1, x2, y2)
	int x1, y1, x2, y2;

INPUT PARAMETERS:
	x1, y1 : one corner of the rectangle.
	x2, y2 : the opposite corner of the rectangle.



NAME: SerialMode - set up RUG to take input from the serial input.

DESCRIPTION:
	SerialMode allows the program to set up RUG to take input from the 
	serial input port instead of through the processor port.  The
	primitives that may be drawn through the serial port are vectors,
	hollow circles or filled circles.  Picking and linetype are
	supported by this function.  The primitive color is selected by
	LineColorIndex.  Using any other drawing command will disable
	the serial mode.

SYNOPSIS:
	void SerialMode(mode, radius)
	int mode;
	int radius;

INPUT PARAMETERS:
	mode : set to VECTOR to enable vector drawing, HCIRCLE for hollow
	       circles or FCIRCLE for filled circles.
	radius : the radius for circles (should be <= 1023 pixels)

DEFAULTS:
	Serial mode is disabled.


NAME: SetLinetype - set the linetype in the RUG chip.

DESCRIPTION:
	SetLinetype allows the program to set the 16 bit line type register
	inside of RUG and the magnification factor for the linetype.  Different
	linetypes may be maintained for primary planes and overlay planes.

SYNOPSIS:
	void SetLinetype(mask, mag)
	unsigned short mask;
	int mag;

INPUT PARAMETERS:
	mask - a 16 bit mask that defines the linetype pattern.
	mag - a magnification factor 0-15 to enlarge the pattern with.

DEFAULTS:
	mask = 0xffff
	mag = 15



NAME: SetPickMode - enable or disable pick mode in RUG.

DESCRIPTION:
	SetPickMode allows the program to enable or disable RUG from actually
	drawing to the frame buffer.  When pick mode is set, all unclipped
	pixels are actually generated but not displayed.  If any unclipped
	pixels were generated the pick bit is set.

SYNOPSIS:
	void SetPickMode(flag)
	int flag;

INPUT PARAMETERS:
	flag - set TRUE to enable pick mode, FALSE to disable pick mode.

DEFAULTS:
	Pick mode disabled.



NAME: WriteBlock - transfer data from main memory to the frame buffer.

DESCRIPTION:
	WriteBlock allows the program to move data from main memory into
	a rectangular region in the frame buffer.  Depending on the overlay
	mode data is either written to primary planes or overlay planes.
	No clipping is performed.  Data is only written to planes that
	are write enabled.

SYNOPSIS:
	void WriteBlock(sx, sy, w, h, data)
	int sx, sy, w, h;
	unsigned char *data;

INPUT PARAMETERS:
	sx, sy : the upper left coordinate to start writing data.
	w : the width of the rectangular block.
	h : the height of the rectangular block.
	data : a pointer to the data array.  data[0] corresponds to the
	       upper left coordinate.  Data is packed with the least significant
	       bit corresponding to the least significant plane.



NAME: WriteEnable - select which planes in the frame buffer are modifiable.

DESCRIPTION:
	WriteEnable allows the program to select with a mask which planes can
	be written to in the frame buffer.  Depending on the overlay mode wither
	either the main plane or the overlay planes will be affected.  Care 
	should be taken when using WriteEnable while in double buffer mode.

SYNOPSIS:
	void WriteEnable(mask)
	int mask;

INPUT PARAMETERS:
	mask - a mask that is used to determine which planes are enabled to be 
	       modified.  Each bit is interpreted as the plane enable of that
	       respective plane; i.e., If the least significant bit is 0 then
	       plane 1 is disabled.  If the 2nd bit is 1, then plane 2 is
	       enabled.

DEFAULTS:
	All primary planes enabled.



