.SP
Required Testing
.SP
A. Code reviews
.SP
Non-author code reviews are not deemed necessary, 
given the mechanical nature of the
revisions going into 3.21. The CRTE driver is a close relative of the
CRTC driver found in 3.2, and the DGL modifications are mostly small and
rather isolated.
.SP
B. Coverage testing
.SP
As the design engineer for certain files/modules which have been modified 
since the 3.21 release, I have the primary responsibility for insuring that 
that code is tested. A checklist of modified modules will be used to track 
coverage testing.
.SP 
As revision 3.21 is a PCO on top of 3.2, and as it requires no changes deep
in the system, coverage testing need cover only a limited set of modules.
.SP 
Coverage testing consists of running tests, aimed at testing the changes 
on code which has been bugfixed or enhanced, and on related areas where we 
suspect interactions with the change. These tests are independent of existing
test suites. Where practicable, the tests will be included in the test suites.
.SP 
For purposes of display testing, the 319C+ is considered to be a 330 running
a 98549A board, and will not be qa'd specifically.
.SP 
The files/modules for coverage testing are:
.nf
.SP
   DGL: LIB, GLE_RGL, DGL_POLY, DGL_C_OUT, DGL_RAS, RGL
   HUMAN INTERFACE: CATCRT, CATASM
.SP   
.fi
C. Test Suites
.SP
The following test suite exists for the Pascal display system.  If
practicable, it should be run whenever changes are made in the related
code, and as a minimum, on the latest version of the system in which
related changes have been made.
.SP
.ce
   Graphics test suite (IGTP based)
.SP
D. Specific test Plans
.SP
The following pages contain more detailed test plans for certain areas
of the system which have been modified significantly for this release.
Plans have been done for Graphics and CATSEYE alpha driver.
.nf
     1.  Graphics QA plan 
     2.  CATSEYE alpha test plan


1. Graphics tests
.SP
 Testing Overview
.SP
.nf 
   o Test new h/w and s/w with existing test suites or new tests
     as indicated below, starting at QA entry.
.SP   
   o After fixing all bugs detected in the full QA test re-run full
     QA test set last week before MR, to meet QA exit conditions. For
     this run, will use only h/w combinations which failed previous run,
     as well as any "suspect" combinations.
.SP 2
          
Implementation
.SP
  Run DGL IGTP QA suite against combinations as given in
  the matrices below:
.SP
 Displays
.SP  
          36C 204A 204B 542 543 544 545 547 548 549 550 700-4 627 
  9836C     3        
  320                                     3                    28 
  330                                       3/6 3/6 3/6
  350                                            3                   
.SP  
  (3=primary display setting, 6=secondary display setting, 28=select code)
.SP  
 Effort:  estimate 1 hour per test plus 3 hour setup total for 330, 1
 hour setup for 350, 1 hour setup for 320/547, 3 hours setup for 320/627
 and 2 hours setup for 36C.
.SP
 Total:  (10*1 hour) + (3+1+1+3+2) = 20 engr hours.
.SP
 The 36C, 320/547 and 320/627 tests are regression tests, as are the
 following:
.SP
 Plotters
.SP
  1 Plotter (any model) with 1 Series 300 SPU both as direct connect
    (on-line), and to file (spooled)
  Effort: 1 hour test + 3 hours setup/analysis
.SP
 Locators
.SP
  Test mouse or knob with one CATSEYE display on 1 SPU.  This is not a
  separate test, as the IGTP test suite tests locators when it tests
  displays.
.SP 2

2. CATSEYE alpha testing
.fi
.SP     
The CATSEYE CRTE driver will be tested on each of the 98458A, the
98549A, and the 98550A, on each of the 320, the 330, and the 350 SPUs.
.SP
Testing will consist of exhaustive exercise of the driver using the
standard Pascal utilities such as FILER, EDITOR, etc.  The debugger
window interface will be tested using the PAWS debugger.
.SP
Reentrancy of the driver will be tested by typing at the keyboard
(level 1 interrupt) while display-intensive alpha and graphics
applications such as EDITOR and IGTP test suite are executing.
.SP
Regression testing: the CRTE driver will be installed in an INITLIB,
and the system booted on a 98547A display (any SPU) to ensure it
correctly identifies its hardware.
