/* these are register offsets (bytes) from base address */
#define PATT0 	0x4400
#define OPATT0 	0x4600
#define PATTOFF	0x0020

static void load_pattern (csaddr, src, mask, ovl)
unsigned char *csaddr;
unsigned short *src;
unsigned short mask;
int ovl;
/*
	loads Catseye pattern register from 16x16x8 bit array
		
	csaddr	input	pointer to Catseye control space base address
	src	input	pointer to 16x16x8 bit array
			(accessed as 16-bit words, 1 word/row/plane) 
	mask	input	plane mask indicating planes to be loaded
	ovl	input	boolean (load HRC overlay planes if TRUE)
*/
{
	register unsigned short *destptr;
	register unsigned short rmask; 
	register short i;

	/* set start address of pattern register set */
	if (ovl)
		destptr = (unsigned short *) (csaddr + OPATT0);
	else
		destptr = (unsigned short *) (csaddr + PATT0);

	/* rmask is mask copy actually used to control plane loading */
	rmask = mask & 0xff;
	while (rmask)
	{
		/* if bit is set, load this plane */
		if (rmask & 1)
		{
			/* predecrement is fastest counting loop in C */
			i = 17;
			while (--i)
				/* copy row to destination */
				*destptr++ = *src++;
		}
		else
		{
			/* skipping this plane */
			destptr = 
			(unsigned short *)((unsigned char *) destptr + PATTOFF);
			src += 16;
		}

		/* shift mask right one bit */
		rmask >>= 1;
	}
}

static int update_fill_pattern(source,dest,first_plane,num_planes)
unsigned char *source;
unsigned short *dest;
int first_plane, num_planes;
/*
	load source, which is 4x4 pixel-major, 
		into dest, which is 16x16 plane-major 

	source		input	pointer to 4x4 byte array
	dest		input	pointer to 16x16x8 bit array
				(accessed as 16-bit words, 1 word/row/plane)
	first_plane	input	first plane to load (0..7)
	num_planes	input	number of planes to load
*/
{
	register unsigned char *src_ptr, *ptr;
	register unsigned short *dest_ptr;
	register unsigned short reg,bit,mask,work,plane,lim;

	dest_ptr = dest + (first_plane << 4);
	ptr = source;
	lim = num_planes;

	/* run loop for each plane to be loaded */
	for (plane=0; plane < lim; plane++)
	{
		/* mask will extract correct bit from each source byte */
		mask = 1 << plane;
		src_ptr = ptr;

		/* for each pixel in the y direction */
		for (reg=0; reg<4; reg++)
		{
			/* clear working register */
			work = 0;

			/* for each pixel in the x direction */
			for (bit=0; bit<4; bit++)
			{
				/* shift working register */
				work <<= 1;

				/* if in source, put bit into work register */
				if (*src_ptr++ & mask)
					work |= 1;
			}

			/* replicate working register 4x in x direction 
				(4 bits -> 16 bits) */
			work |= work << 4;
			work |= work << 8;

			/* write result to destination array, 
				replicating 4x in y direction */
			*dest_ptr = work;
			*(dest_ptr+4) =  work;
			*(dest_ptr+8) =  work;
			*(dest_ptr+12) = work;

			/* advance destination pointer to next row */
			dest_ptr++;
		}

		/* skip over the 3 other copies of the data */
		dest_ptr += 12;
	}
}
