.H 1 "LAN Driver ERS"
.ce
HP CONFIDENTIAL
.P                              
The file LAN as supplied with PWS 3.22, contains code which allows access to
HP98643 compatible interface circuitry from the PWS IO library.
.P
The HP98643 is an IEEE802.3 Ethernet compatible interface (card) suitable
for LOCAL AREA NETWORK (LAN) applications.
.P
The file LAN must be executed prior to executing any program which uses the
HP98643 interface.  This may be accomplished by executing LAN in the
AUTOSTART file or by copying LAN into the systems INITLIB.  See the 'Adding
Modules to INILIB' section of the 'Programming and Configuration Topics'
manual.  The LAN file contains the modules IOMPX and LANDVR.  Both modules
should be copied into INITLIB.  These modules must appear some where between
IODECLARATIONS and LAST.   These modules must be appear in the order IOMPX
then LANDVR.
.P
For systems stored on single sided media LAN is in the LIB: volume and on
double sided media systems it is in ACCESS: volume.
.nf
.na
=========================================================================
.ad
.fi
.P                              
The module LANDVR as supplied with PWS 3.3, contains code which allows
access to HP98643 compatible interface circuitry from the PWS IO library.
.P
The HP98643 is an IEEE802.3 Ethernet compatible interface (card).  Some
pertinent points of information for purposes of this document are:
.P
.AL 1
.LI
The data movement rate is 10 megabits/sec. (1.25 megabytes/sec.) actual
data rates depend on the SPU driving the interface and the type of
application.
.LI
This interface is intended for use in a LOCAL AREA NETWORK (LAN) where each
card is identified by a unique 6 byte ETHERNET ADDRESS (ENA). An ENA was
built into the card when it was manufactured.  This process ensures that each
card will have an ENA different from any other card in the world.
.LI
There are three classes of ENAs
.AL a
.LI
A BROADCAST ENA which contains all one bits.
.LI
A MULTICAST ENA which is has the least significant bit of the first
byte set to one.
.LI
All other patterns are used to uniquely identify a card.
.LE     
.LI
Data is transported in blocks called FRAMEs or PACKETs.  FRAMEs contain
a minimum of 60 bytes and a maximum of 1514 bytes.  The first 6 bytes of
every FRAME contain the ENA of the destination card.  The second 6 
bytes of every FRAME contain the ENA of the source card.  After the
two ENA fields, the contents of a FRAME will vary depending on the
requirements of some protocol.  
.LI     
The last 4 bytes of a FRAME contain a CRC code.  These four bytes are
after the 60 to 1514 data bytes.  The card generates this on output
and validates it on input.  Driver code strips it after validation
on input so the user need not be concerned with it.
.LI
The card is highly buffered and has independent input and output paths. 
.LI 
The driver code is interrupt driven, which allows overlapped transfer
operations for Input and Output to be active at the same time.
.LI     
Data is moved between the card and main RAM via a 16K byte block of dual
ported RAM residing on the card.  DMA is neither required or usable.
.LE
.P 2 
.H 2 "SIMPLE SCHEMATIC DIAGRAM"
.P
.nf
.na
						     MAU
terminator                                            |
=----------------=----------------- LAN cable---------=------= terminator
	         | T connector
	      .--+--.
	      | MAU |     Adapter Unit
	      |     |
	      .--+--.             HP98643
	         | cable     | input buffers ---|-->driver code
	         +-----------| control circuitry|<->interprets control info
			     | output buffers<--|---copies data to & from 
                                                    main RAM
.ad
.fi
.P 1
This module is supplied on volume CONFIG: in file LANDVR.  The file
LANDECS (also supplied on CONFIG: ?? ) contains a module LANDECS which
exports declarations useful to applications which require very low level
access to and control of the HP98643 interface circuitry.
.P 
This driver implements the driver table entries IOD_WTC, IOD_RDS and
IOD_TFR to support the IO library IOCONTROL, IOSTATUS and TRANSFER calls.
IOD_INIT and IOD_ISR are the ONLY other IO driver table entries implemented. 
In non ambiguous terms this means that the ONLY way to move data on and off
the card is via IOD_TFR / TRANSFER calls.
.P 2
.H 2 "NOTES ON PROCEDURES IN GENERAL_4"
.P 
Due to limitations in the IO LIBRARY and GENERAL_4 design in particular,
only one input transfer may be active at any given time.  It is possible to
have more than one overlapped output operation in progress. 
.P     
TRANSFER is supported in both Overlapped and Serial modes.  This is the
only TRANSFER procedure fully supported.
.P
TRANSFER_WORD operates exactly like TRANSFER.
The B_W_MODE value is ignored.
.P
TRANSFER_UNTIL operates like TRANSFER except that it is INPUT ONLY and
the transfer count is set according to the amount of SPACE in the buffer. 
The TERM_CHAR value is ignored.
.P  
TRANSFER_END operates like the others except that the transfer count is
automatically set according to the amount of SPACE or DATA in the buffer as
appropriate.  The END_MODE flag is ignored.
.P
The ISC_BUSY function checks both input and output paths, so it is not a
good indicator of the cards ability to accept a particular transfer request.
.P
TRANSFER_SETUP operates as it should, escapes if the driver is not ready
to perform the requested operation.  The calls this procedure makes to
ADDR_TO_TALK and ADDR_TO_LISTEN are not required for LAN operations.  If an
application duplicates the TRANSFER and TRANSFER_SETUP code for use with LAN
only then these calls should be omitted.  This will avoid requiring the
HPIB_1 module to be loaded.
.P
ABORT_TRANSFER can cause all active transfers on the select code to
abort.  This call should be used only as a last resort.  This is the same
call made by the STOP and CLR I/O keys.
.P
All other routines in GENERAL_4 will operate as advertised.
.P
EOT_PROC procedures are supported although the argument passed when
called is a pointer to the BUF_INFO_TYPE record instead of the EOT_PARM
value.  The TERM_CHAR field has special significance.  See below for more
details.
.P   
The USER_ISR field in ISC_TABLE entries is supported only for input.  
See GENERAL NOTES below for more details.
.P
.H 2 "Rules To Keep Your System Working."
.P
.AL 1
.LI
Don't write to ANY of the card registers.
.LI
See rule number 1.
.LI
Don't even think about writing a buffer EOT_PROC until you have read
and understand The Facts Of Life For EOT_PROC Procedures.
.LI
Don't even think about coding references to fields in a LAN_INFO_REC
until you understand everything in this document.
.LI
Don't ever code references to fields in a LAN_INFO_REC
except IO_TEMPS or OUTBUF_PROC.  The rest of the record may change from one
release of the driver to the next.
.LI
Care FULLY read rule 5.
.LE
.P 2
.ul
.H 2 "General discussion for EOT_PROC procedures."
.P
An EOT_PROC procedure is called (for normal operations) whenever the
transfer operation originally requested for a buffer has been completed.  For
input operations this is when the all requested data has been moved from the
card buffer(s) to the user buffer.  For output operations this is when the
card signals that it has sent the FRAME.
.P
Facts Of Life For EOT_PROC Procedures.
.P
.AL 1
.LI
EOT_PROC procedures are always executed as part of an ISR and must obey the
rules of ISRs.  See the SYSTEMS DESIGNER GUIDE (SDG) interrupt chapter.
.LI
understand fact 1.
.LI
understand the BUF_INFO_TYPE record. See the SDG Device I/O chapter.
.LI
understand the IO_TEMP_TYPE record. See the SDG Device I/O chapter.
.LI
The parameter to a LAN EOT_PROC is always a pointer to the
BUF_INFO_TYPE structure for which the transfer has just completed.
.LI
The EOT_PARM is not examined or changed by LAN driver code.
.LI
LAN card configuration parameters can be changed via IOCONTROL
calls.  DON'T try it from an ISR.  See the IOCONTROL section below.
.LI
Only OVERLAP type transfers may be done.  Any other kind
will hang the system.
.LI
DON'T call ABORT_TRANSFER from an ISR.
.LI
OUTPUT transfers can be STARTED from an ISR
if and ONLY if OUT_BUFPTR is nil.
TRANSFER_SETUP enforces this, don't try to get around it.
.LI
An INPUT transfer can be STARTED from an ISR
if and ONLY if IN_BUFPTR is nil.
TRANSFER_SETUP enforces this, don't try to get around it.
.LI
The buffers TERM_CHAR is used as a status variable intended for use by an
EOT procedure. See below.
.LI
The value of the ACTIVE_ISC field of the buffer will always be NO_ISC for for
OUTPUT operations.  The DRV_TMP_PTR field may be used to access the
MY_ISC field of the appropriate select code table entry.
.LE
.P 2 
.H 2 "INTERPRETING TERM_CHAR VALUES"
.P
The symbols used in the following tables for TERM_CHAR value are constants
exported from the module LANDECS.
.P
For an INPUT type EOT_PROC call:
.nf
.na
   TERM_CHAR 
    Value         Interpretation.
----------------+-----------------------
    LB_PENDING    Transfer in progress. Never seen in an EOT_PROC.
    
    LB_EOT        Normal completion.
                  Both input & output operations may be started.
    
    LB_SHORT      Normal completion but the buffer space available was
                  smaller than the incoming frame.  Some data was lost.
                  Both input & output operations may be started.
                  
    LB_TX_ERROR   Never seen in an input EOT_PROC.
    
    LB_ABORT      This call has been made from the STOP KEY ISR or
                  an ABORT_TRANSFER call.
                  If the EOT_PROC sets TERM_CHAR to LB_PENDING before
                  returning then the transfer will be continued (IN_BUFPTR
                  and ACTIVE_ISC restored) otherwise the transfer is 
		  aborted (IN_BUFPTR will remain nil and ACTIVE_ISC will 
		  remain at NO_ISC).
                  Output operations may be started. (see Facts of Life)

                  
    LB_RESET      The card has been reset for reconfiguration or because
                  of a correctable hardware failure.  No data has been 
		  placed in the buffer.  All data on the card has been 
		  lost.
                  This transfer request can not be completed or restarted.
                  If the EOT_PROC sets TERM_CHAR to LB_PENDING before
                  returning then the transfer will be continued (IN_BUFPTR
                  and ACTIVE_ISC restored) otherwise the transfer is 
		  aborted (IN_BUFPTR will remain nil and ACTIVE_ISC will 
		  remain at NO_ISC).
                  Output operations may be started. (see Facts of Life)
                  
    LB_HW_FAILED  The card has been reset.  No data has been placed in the
                  buffer.  All data on the card has been lost.  This 
		  transfer request can not be completed or restarted.  
		  The card is now UN-USABLE!! ... call SERVICE.
                  


For an OUTPUT type EOT_PROC call:
  TERM_CHAR values
    value         interpretation.
----------------+-----------------------
    LB_PENDING    Transfer in progress. Never seen in an EOT_PROC.
    
    LB_SHORT      Never seen in by an output EOT_PROC.
                  
    LB_EOT        Normal completion.
                  OUT_BUFPTR has no relation to the current buffer.
                  Both input & output operations may be started.
                  
    LB_TX_ERROR   The buffer was sent after some difficulty.
                  See driver statistics description for the kinds of
                  errors which may occur. 
                  OUT_BUFPTR has no relation to the current buffer.
                  Both input & output operations may be started.
    
    LB_ABORT      This call has been made from the STOP KEY ISR or
                  an ABORT_TRANSFER call.
                  OUT_BUFPTR may or may not be pointing to this buffer.
                  If the EOT_PROC sets TERM_CHAR to LB_PENDING before 
		  returning then the transfer will be continued (buffer 
		  pointer and ACTIVE_ISC restored) otherwise the 
		  transfer is aborted (buffer pointer will remain nil 
		  and ACTIVE_ISC will remain at NO_ISC).
                  Both input & output operations may be started.
                  
    LB_RESET      The card has been reset for reconfiguration or because
                  of a correctable hardware failure.
                  OUT_BUFPTR may or may not be pointing to this buffer.
                  All data on the card has been lost.
                  This transfer can not be completed or restarted.
                  An input transfer may be started.
                  Output operations may be started. ( if OUT_BUFPTR is
                  nil then the EOT_PROC can issue the transfer request
                  on this buffer ).

    LB_HW_FAILED  The card has been reset.
                  All data on the card has been lost.
                  This transfer request can not be completed or restarted.
                  The card is now UN-USABLE!! ... call SERVICE.
.ad
.fi
.P 2
.H 2 "USING IOREAD_WORD & IOWRITE_WORD"
.P
It is STRONGLY recommended that the registers on this interface not be accessed.
.P
NOTE:  locations above 32767 can not be accessed via IOREAD_WORD or IOWRITE_WORD.
.P
.nf
                                  IOREAD_WORD
                  
     register           interpretation of value
----------------------+---------------------------------------------------------
        0               dio id register
        2               dio status register
    16384               LANCE Data Port,        DON'T EVER USE THIS
    16386               LANCE Address Port
    32768..49150        LANCE dual ported ram
    49152..49278        Nov ram on the interface board.
                        (contains default local link address 
                        stored one nibble per byte)
    
                                IOWRITE_WORD
                                
     register           interpretation of value
----------------------+---------------------------------------------------------
        0               dio id register         DON'T EVER DO THIS
        2               dio status register     DON'T EVER DO THIS
        4               Nov ram store pulse     DON'T EVER DO THIS
    16384               LANCE Data Port,        DON'T EVER DO THIS
    16386               LANCE Address Port      DON'T EVER DO THIS
    32768..49150        LANCE dual ported ram   DON'T EVER DO THIS
    49152..49278        Nov ram (is read only)
.fi
.P 2
.H 1 "USING IOSTATUS & IOCONTROL"
.P
IOSTATUS is used to read information driver pseudo registers.  These calls
may be made at any time and from any where and are of the form
xxx := IOSTATUS(sc,opcode) .  The opcode and other symbols used below are
declared in module LANDECS.  These symbols are shown in upper case in the
tables below.  The name LANCE refers to the main hardware IC chip in the
HP98643 interface circuitry.
.P
.nf
     opcode             interpretation of value
----------------------+---------------------------------------------------------
    
    L_GET_INTLEVEL      interrupt level for the interface
    L_CARD_STATE        function returns ordinal value of the following:
                        The symbols here are of type CARD_STATE_TYPE .
                        value           interpretation
                        ---------------+---------------------------------
                        CS_PRE_INIT     card not yet powered up
                        CS_INIT_FAILED  card buffers incorrectly defined
                        CS_ACK_ERROR    data/address ports not responding
                        CS_CARD_RESET   card stopped
                        CS_LANCE_READY  normal operation
                        CS_HW_FAILED    driver detected a non recoverable
                                        hardware error. card is stopped.
    L_RECONFIG          0=normal operation
                        1=card will reconfigure on next interrupt.
    L_MODE              LANCE mode word, 0 for normal operation.
                        -32768 for promiscuous receiver mode.
                        Other values will indicate that the interface is
                        operating in a test mode. (This condition will only
                        occur if user supplied code sets it)
    L_NUM_RX_BUFS       number of configured receiver buffers
    L_RX_BUF_SIZE       number of bytes in each receive buffer.
                        (LANCE will chain these buffers for large FRAMES.)
    L_NUM_TX_BUFS       max number of concurrent transmit operations 
			allowed.
    L_GET_TX_BUF_SIZE   number of bytes available for transmit buffers
                        The driver allocates from this space as needed.
    L_GET_STATS_LSW     Address of statistics array. (least significant 
			word)
    L_GET_STATS_MSW     Address of statistics array. (most significant 
			word)
    L_GET_FRAME_SIZE    Number of bytes in the last frame received.
                        Intended for use by a USER_ISR_PROC .
    L_LINK_ADDR1        first byte of local link address.
                        bytes are accessed as 
                        eg
                        for i := 0 to 5 do
                        xxxx[i] := IOSTATUS(sc,L_LINK_ADDR1+i);
    L_INPUT_BUSY        1 = input is busy (input transfers
                                           can NOT be started)
                        0 = input is free
                        
    L_OUTPUT_BUSY       1 = output is busy (output transfers
                                            can NOT be started)
                        0 = output is free
                        
    L_MMASK0            bit 0 of the multicast address filter.
                        bits are accesses as offsets from this.
                        eg
                        bit zero accessed xxxx := IOSTATUS(sc,L_MMASK0+0);
                        bit 35   accessed xxxx := IOSTATUS(sc,L_MMASK0+35);
                        up to
                        bit 63   accessed xxxx := IOSTATUS(sc,L_MMASK0+63);
.fi
.P
IOCONTROL calls are used to change driver pseudo registers or cause the
driver to perform some operation not provided for by general IO LIBRARY
routines.  Some of these calls may be made at any time, most either should
not or can not be made from an ISR.  These calls and are of the form
IOCONTROL(sc,opcode,value) . The opcode and other symbols used below are
defined in the module LANDECS.  These symbols are shown in upper case in
the tables below.
.P
.nf
opcode                     value
----------------------+---------------------------------------------------------

L_CARD_STATE            can be used to force a card/driver state
                        The symbols here are of type CARD_STATE_TYPE .
                        Don't try this from an ISR.
                        value           interpretation
                        ---------------+---------------------------------
                        CS_CARD_RESET   stop the card
                        CS_LANCE_READY  try to start normal operations
                                        (immediate reconfigure)
                        other values are ignored.
     
L_FORCE_INTERRUPT  	Force immediate execution of the driver ISR.
                        (does nothing if processor interrupt level is
                        at or higher than the interface interrupt level)
                        
L_RECONFIG         	Set the reconfig flag
                        A value of 0 means normal operation/cancel 
			reconfig request.
                        A value of 1 requests the driver to reconfigure the 
			interface on the next interrupt.
                        Don't do this from an ISR.
     
L_MODE             	Set the Lance mode word,
                        A value of 0 is used for normal operation.
                        A value of -32768 is used for promiscuous 
			receiver mode.
                        Other values are used for interface testing,
                        see the HP98643 ERS documentation and the 
                        United Technologies Mostek MK68590 LANCE 
			Technical Manual.
                        Don't do this from an ISR.
                        
L_NUM_RX_BUFS      	Set the number of configured receiver buffers.
                        This must be a power of 2. eg 1, 2, 4, 8 etc.
                        The driver default is 32.  Max value is 128.
                        Don't do this from an ISR.
     
L_RX_BUF_SIZE      	Set the number of bytes in each receive buffer.
                        (LANCE will chain these buffers for large FRAMES)
                        The value must be at least 64 and should be a
                        multiple of 4.
                        The driver default is 320.
                        Don't do this from an ISR.
                        
L_NUM_TX_BUFS      	Set the max number of concurrent transmit 
			operations allowed.  This must be a power of 2 
			eg 1 2 4 8 etc.  Max value is 128.
                        The driver default is 4. (main SPU normally can't 
			keep more than one busy and occasionally will use 
			as many as three if it is doing nothing but
                        transmitting long buffers)
                        Don't do this from an ISR.
                        
Transmit space     	There is no way to set the transmit space.  It is 
			all of the dual ported ram not used for other 
			purposes and is calculated as :
                        hex('8000')-24-(num_rx_bufs * 4)
                        -(rx_buf_size*num_rx_bufs)-(num_tx_bufs * 4)
                        
L_SET_MULTICAST_ALL  	A value of 0 will disable reception of all 
			multicast addresses.
                        A value of 1 will enable reception of all multicast
                        addresses.
                        The driver default value is 0.
                        
L_INIT_STATS       	Set all counters in driver statistics array to 0.
                        The driver does this operation at driver install 
			time.
     
L_REJECT_FRAME     	This call is intended for use from the 
			USER_ISR procedure to cause a FRAME to be
                        immediately discarded.
                        (and there by avoid even moving it from 
			the card buffer )
                        
L_LINK_ADDR1       	Set first byte of local link address.
                        all bytes are accessed as offsets from this eg.
                        for i := L_LINK_ADDR1 to L_LINK_ADDR1+5 do
                          IOCONTROL(sc,i,xxxx);
                        Will set all six bytes of the address.
                        The driver default is read from the interface Nov 
			ram.
                        Don't do this from an ISR.
                        
L_SET_UISR         Cause USER_ISR in the select code table
                        to be moved to a location in the driver temp area.
                        This will effectively make this permanent.
                        An IOCONTROL(sc,L_CLEAR_UISR,0) must be made before
                        the procedure is unloaded.  This capability is 
			intended for use by P loaded driver type code.
                        Don't do this from an ISR.
                        
                        The presence of an existing permanent ISR can only be
                        checked by examining the PERM_ISR field in the driver
                        temp area. ( this is described in a record in LANDECS )
                       
L_CLEAR_UISR       Cause the permanent USER_ISR procedure to be no longer  
                        accessed by the driver.
                        Don't do this from an ISR.
                        
L_ABORT             	value must be one of:
                        L_INPUT         try to abort any input transfer.
                        L_OUTPUT        try to abort any output transfers.
                        L_ALL_IO        try to abort all transfers.
                        
                        This operation causes an ABORT sequence to be 
			performed for the appropriate buffers.  See 
			above description for LB_ABORT and EOT_PROCs.
                        Don't do this from an ISR.
                        
L_SET_MMASK         	value is a bit number in the mask 0..63 the 
			requested bit is set.
                        
L_CLR_MMASK         	value is a bit number in the mask 0..63 the 
			requested bit is cleared.
    
L_SET_DEFAULT_CONFIG  	This call causes the driver to load all of its 
                      pseudo registers to be set to the driver install 
                      time defaults.
                      See the above notes for Driver default values.
                      The hardware is not reconfigured nor is the 
                      RECONFIG flag set.
                      
                      Link address is set from interface NOV RAM.
                         an io error escape will happen if the NOV RAM
                         can not be read properly.
                      MODE word is set to DEFAULT_MODE . (0)
                      Multicast filter is set to all zeros.
                      Rx_buffer_size is set to DEFAULT_RX_BUFFER_SIZE.
                      (32)
                      Num_rx_buffers is set to DEFAULT_NUM_RX_BUFFERS.
                      (320)
                      Num_tx_buffers is set to DEFAULT_NUM_TX_BUFFERS.(4)
                      Lan stats are set to zero
                      Don't do this from an ISR.
                        
L_SKIP_BYTES     	This call is intended for use byUSER_ISR procedure 
                to cause leading bytes of the current frame to NOT
                be transferred to a user buffer.
.fi
.P 2
.ul
.H 2 "MISCELLANEOUS NOTES"
.P
The USER_ISR procedure will be called on receive interrupts only, and
just before the driver moves data from card buffers.  The parameter is the
address of the first segment of the FRAME and NOT THE VALUE of the EOT_PARM
field.  This segment is always guaranteed to be capable of holding at least
60 bytes and for a particular call will be capable of holding 
IOSTATUS(sc,L_RX_BUF_SIZE) bytes.
.P    
The iocontrol call L_SET_UISR may be used to make copy the USER_ISR to a
permanent location.  The driver will call either the permanent USER_ISR
procedure (if it is setup) or the isc_table copy (if it is setup) in that
order.  It will never call both.  The call L_CLEAR_UISR must be called to
clear the permanent USER_ISR.
.P    
The procedure variable OUTBUF_PROC in the LAN_INFO_REC is called when
ever the OUT_BUFPTR is set to nil i.e. the driver is ready to accept an output
transfer call.  This feature is intended for use by a permanent background
process which needed to send a frame (eg from in an EOT_PROC) but was not
able to because a foreground program was using OUT_BUFPTR at the time. The
recommended sequence is to take over the OUTBUF_PROC, then when called, call
transfer then restore OUTBUF_PROC.
.P
There is no disaster protection for OUTBUF_PROC so it must be cleared
before the procedure it points to is unloaded.   The procedure has one
parameter which is the select code.  It is recommended that only buffers with
EOT_PROCs be used in transfer calls from this procedure.  Failure to do so
could result in stack overflows due to recursion.  This procedure may also be
called from with in an ISR in which case, the available stack space is small.
.P 
The driver code is instrumented to provide various statistics (counters)
of various events.  Most of these are computed directly from information
supplied by the card.
.P     
The declarations for accessing the statistics array are found in LANDECS
and have LAN_STATS_ as the first part of the relevant symbols.
.P
The array is logically divided into three sections.
.nf
1. General information
   a LHW-MERR       memory access error.     normally fatal.
   b    _BABLE      transmit clock failure.  normally fatal.
   c    _RESTARTS   card has been restarted. caused by recoverable
                    hardware errors or user triggered reconfiguration
                    calls.
 
2. Receiver statistics   each entry is a count of the number of
                         frames matching the associated condition.
   a LRX_NO_ERRORS      no detected errors
                        For all of the following, the frame was discarded.
   b    _FRAME_ERR      wrong number of bits
   c    _OFLO_ERR       input fifo overflowed
   d    _CRC_ERR        CRC check failed
   e    _BUFF_ERR       not enough buffer space to complete reception
   f    _MISS_ERR       not enough buffer space to even start a reception
   g    _OTHER_ERR      invalid number of data bytes or internal control 
                        information is wrong.

3. Transmitter statistics   each entry is a count of the number of frames
                            matching the associated condition.
   a LTX_REQUESTS       driver received the request
   b    _NO_ERRORS      transmitted without error
   c    _NO_HEART       failure in collision detection circuit (frame sent)
                        (some non HP MAUs do not support this)
   d    _ONE            exactly one hardware retry required. (frame sent)
   e    _MORE           more than one hardware retry required. (frame sent)
   f    _DEF            hardware delayed on transmit. (frame sent unless 
			other problems)
   d    _UFLO_ERR       fifo underflowed (frame not sent)
   e    _LCOL_ERR       collision occurred to late to recover (frame not 
			sent)
   f    _LCAR_ERR       carrier signal lost (frame not sent)
   g    _RETRY_ERR      hardware tried 16 times to send (frame not sent)
.fi
.P 2
.ul
.H 2 LAN CARD CONFIGURATION
.P
The LAN card supports configurable buffers, and different levels of
input screening.  All of this can be done via IOCONTROL calls.  The defaults
are designed to allow general operation at good performance levels.
.P
The general method for doing reconfigurations is to set the appropriate
values using IOCONTROL calls then do IOCONTROL(sc,L_RECONFIG,1).  The act of
reconfiguring the card will result in an L_RESET type call to all active
buffers.  As you remember, (from the above tables) this is normally fatal to
output transfers.  For applications with no background LAN activity it is
sufficient that the main program (not an EOT_PROC) perform the required
calls.  If background operations are to be maintained then some form of
communication will be needed.
.P
If only one parameter is to be changed then a sequence like the 
following will be sufficient.
.P
.nf
     iocontrol(sc,L_SET_MULTICAST_ALL,1);
     iocontrol(sc,L_RECONFIG,1);
.fi
.P 
If the application is just starting and no interrupts are expected
then an iocontrol(sc,L_FORCE_INTERRUPT,1) would be appropriate following
the L_RECONFIG call.  
.P
If more than one parameter needs to be adjusted as in re-allocating card 
buffer space then something like the following will be needed to ensure that
the reconfiguration doesn't happen until all parameters are set.
.P
.nf
     iocontrol(sc,L_CARD_STATE,ord(CS_RESET)); { stop the card }
     iocontrol(sc,L_NUM_RX_BUFS,16);
     iocontrol(sc,L_RX_BUF_SIZE,640);
     iocontrol(sc,L_RECONFIG,1);
     iocontrol(sc,L_FORCE_INTERRUPT,1);  { restart the card }
.fi     
The last two calls in the above sequence could be replaced by
nf.
     iocontrol(sc,L_CARD_STATE,ord(CS_LANCE_READY));
.fi      
When an application starts up it may want to bring the driver and card
to a known configuration and state.  The iocontrol(sc,L_SET_DEFAULT_CONFIG,1)
may be used to do this.  This is equivalent to making several calls to set
various values.  It does not execute either a RECONFIG or FORCE_interrupt
action.
.P   
Input screening is done by the card based on the destination ENA of
incoming frames and various configuration parameters.  It will either copy
or not copy data from the cable to its buffers in the dual ported RAM.
.P
The levels of input screening are:
.P
.nf
     1. Allow only the cards ENA and the Broadcast ENA. This is the
        powerup default.

     2. Allow the cards ENA the Broadcast ENA plus selected Multicast
        ENAs.  The typical setup is to allow all Multicast ENAs thru, then
        filter with user supplied software.
        
        The call IOCONTROL(sc,L_SET_MULTICAST_ALL,1); will allow all
        Multicast ENAs thru, then call 
	IOCONTROL(sc,L_SET_MULTICAST_ALL,0); 
	will not allow any Multicast ENAs thru.

        Calls may be made to set or clear individual bits in a 64 bit mask. 
        When a Multicast ENA is detected by the hardware, the ENA is
        passed thru a hashing function which maps the ENA to one of the 
	64 bits.  If the bit is on, the frame is passed thru, otherwise it 
	is rejected.  Since there are more than 64 different Multicast 
	ENAs, more than one ENA will map to the same bit.  It has 
	therefore become the practice to do all the filtering in software 
	since it must be done anyway.

     3. Allow all packets thru regardless of destination ENA.  This is
        used by LAN monitoring programs.  The call 
        IOCONTROL(sc,L_MODE,-32768); is used to set promiscuous mode.
        IOCONTROL(sc,L_MODE,0); is used to set normal mode.
.fi
.bp 
