.H 1 "SCSI Investigation Report"
.H 2 "Why do SCSI"
.P
SCSI
(Small Computer Systems Interface, pronounced scuzzy)
disk drives are becoming more and more popular.  The SCSI
disk market "is one of the highest growth product lines in the
industry with an annual growth of 32% compounded per year." \*(Rf
.RS ST
"HP 9000 Series 300 Small Computer Interface (SCSI) Sales Training Manual";
4/88
.RF
.P
In addition, SCSI as a whole is becoming more popular.
"Marketing data predicts that by mid-1989, approximately one
half of all UNIX workstations will have a SCSI interface." \*(Rf
.RS HP
Perlmutter, Paul Q;
"Small Computer Systems Interface";
Hewlett-Packard Journal; October 1988
.RF
Similar marketing data for PWS and RMB does not exist, but
trends in S300 development should not be ignored.
.P
The Compass machine, a S300 50Mhz 68030 SPU due out 12/89 \*(Rf,
.RS
Febvre, Paul; "Compass Product Data Sheet"; 2/89
.RF
will come standard with a LAN interface, but an optional interface
can be purchased that will have LAN, RS422, Centronix,
.ul
and SCSI.  HP-IB will not be available.
.P
The Apex machines, the S300 68040 based SPUs due out 5/90 \*(Rf,
.RS
Schubert, Mike; "Apex Product Data Sheet"; 1/89
.RF
comes optionally with
an internal 600Meg optical disk drive and/or up to 2 internal 3.5"
200M or 100M hard drives.
.ul
SCSI is the only interface that supports these internal disks.
.P
Seeing an internal optical disk drive on the next generation S300 is
not to surprising.
There is a move afoot to place an optical disk drive on all S300 and S800
machines, and use it as a software distribution medium \*(Rf.
.RS
Niland, Bob; "Install and update media, the next generation"; HP Internal
Memo; 4/89
.RF
Industry wide,
.ul
SCSI is the drive of choice for optical disks.
.P
Marketing incentives make
equivalent SCSI disks more attractive than HP-IB disks.
For example, the 7959S (SCSI) lists for $500.00 less than the
7959B (HP-IB).  (7959S: $7225 vs. 7959B: $7725 \*(Rf)
.RS
"HP 9000 Computing Systems - Price Guide"; 5/89
.RF
The price gap between SCSI disks and HP-IB disks is expected
to grow wider.
.P
Industry Standardization and an exceptional feature set is what is making
SCSI so popular today.
SCSI offers easy connectivity to many manufacturer's peripherals because 
of the ANSI standard \*(Rf
.RS AN
"small computer system interface (SCSI)"; ANSI X3.131-1986
.RF
and
the complimentary industry SCSI Common Command Set (CCS) \*(Rf.
.RS CS
"Common Command Set (CCS) of the Small Computer System Interface (SCSI)";
X3T9.2/85-52; Rev 4.B
.RF
.P
.H 2 "What SCSI is"
.P
SCSI
is an I/O
bus designed to 
"provide host computers with device independence within
a class of devices.  Thus, different disk drives, tape drives, printers,
and even communication devices can be added to the host computers without
requiring modifications to generic system hardware or software." \*(AN
.P
SCSI is a "System Level" interface, using standard, high level commands
that are transported from the host to a peripheral.
These commands form the origin of all data transfer on the SCSI bus.
.P
SCSI allows up to 8 devices on its bus, in any combination of hosts and
targets (a target, generally speaking, is a peripheral such as a disk).
All devices can communicate directly with one another.
.P
A popular and prominent feature of the SCSI definition is distributed
arbitration \*(Rf.
.RS
Harrison, Brad;
"Mushrooming SCSI Interface Provides Variety of Implementation";
HARDCOPY; 1/87
.RF
That is, when a target device anticipates
a considerable delay before being able to complete a command (perhaps
due to a head seek), the target device can disconnect from the bus 
and reconnect when it is ready
to continue.
During the disconnect the host (or another host) can initiate commands
with SCSI devices.
.P
Distributed arbitration increases bus utilization.
Generally, system designers
regard 30% bus usage as a maximum before system performance begins
to degrade.  Bus usage is a measure of the time the bus is actually
transmitting data. Tests using the SCSI bus system have shown a
maximum of 50% bus usage. \*(Rf
.RS
Lohmeyer, John;
"Use SCSI devices for multiprocessor, smart I/O systems"; EDN; 1/85
.RF
.P
Finally, SCSI offers high data-transfer rates.
SCSI offers two bus protocols that can be used to transfer
data:  Asynchronous data transfer and Synchronous data transfer.
Asynchronous data transfer is the default method and provides a
data transfer rate of 1.5 Mbytes/sec.
.P
Synchronous data transfer must be agreed upon between the host and
the target device and certain boundaries must be set.  This method
can transfer up to 4 Mbytes/sec.
.P
I have found that SCSI maps well onto the Physical through Transport layers
defined in the Open Systems Interconnection
Reference Model (OSIRM).  For review, each OSIRM layer definition is shown in
Figure 1.
.P
To provide a high degree of device independence, SCSI is defined
from the physical layer through the Transport Layer in one document, the
ANSI SCSI standard \*(AN.
In addition, these layers are purposely interdependent;
requiring a device driver which interfaces on the SCSI I/O bus to support
all layers.
For example, the highest layer of functionality defined in SCSI would
be the Transport Layer.  This is where commands are defined that allow
a Session Layer to transport data to and from another device on the bus.
However at the data link layer (just above the physical), a command can not
be transmitted on the bus unless the bus is in a 'Command Phase'.  In fact,
one of the bus control lines definition is Command/Data.
Thus the lowest layers are dependent on the highest layers
and visa-versa.
.P
However, this is not necessarily bad.
"SCSI is very popular partly because
all levels were designed and specified together, resulting in an I/O
system that is integrated in a consistent and homogeneous style." \*(HP
SCSI devices are grouped into classes.  A set of commands apply to a single
class.
The only thing that differentiates classes are the command sets.  
.P
Commands are communicated to Logical Units that have Logical Blocks and
Logical Block Addresses.
The target device interprets and translates the logical addresses to
the addressing of the physical medium.  For example, a disks physical
address would be a cylinder, track, and sector.
This separation of addressing duties further enhances device independence
and the concept of device classes.
.P
So then, in theory from the Transport layer (command level) on down,
common code can be written that can service all device classes.
And the only unique code need be in the Session Layer where an 
interface for each device class is developed.
.P
In reality, this is just what I am attempting to do, with the exception
that some device dependency is going to have to be passed down from the
Session Layer to the Transport and Data Link layers.
.B
.DS
__________________________________________________________________

.DE
.R
.VL 20
.LI Application\ Layer
Serves as the window between communicating application processes.
.LI Presentation\ Layer
Represents Information to communicating applications-entities in 
a way that preserves meaning while resolving syntax differences.
.LI Session\ Layer
Provides services to establish a session-connection between two
presentation-entities, and to support their orderly data exchange
interactions.
.LI Transport\ Layer
Provides transparent transfer of data between session-entities.
.LI Network\ Layer
Provides the means to establish, maintain, and terminate network-connections
between communicating systems.
.LI Data\ Link\ Layer
Provides functional and procedural means to establish, maintain, and
release data-link-connections among network entities.
.LI Physical\ Layer
Provides mechanical, electrical, functional, and procedural characteristics
to activate, maintain, and deactivate physical connections for bit transmission between data-linked-entries.
.LE
.DS

.FG "The OSI Reference Model layers \*(Rf"
.RS
Padlipsky M. A.; "The Elements of Networking Style";
Prentice Hall,Inc.; 1985
.RF
.B

__________________________________________________________________
.R
.DE
.P
.H 2 "What SCSI is not"
.P
SCSI is not a simple communication medium where any two devices that
can be physically connected can communicate on a byte by byte basis.
It does not compare well to other communication media of this sort such as
RS-232, HP's Datacomm, or HP's GPIO.  Indeed, even HP's HP-IB, when
considered at the lowest level, does not compare well.
SCSI is not a byte oriented communication medium, but is a block oriented
communication medium.
.P
SCSI has to
be thought of as a physical medium of communication that works in concert
with communication protocols at higher levels.  The HP-IB/CS80 combination
begins to compare with SCSI.
.P
SCSI is not a programmer's I/O medium.
To communicate on the SCSI bus, a programmer must implement the
physical, data link,
network, and transport layers.
A programmer may then send/receive commands from other communication
devices.  
If an application encompassing multiple communication devices choose
to use the SCSI bus as a medium, it could be accomplished by providing
an algorithm that uses unique SCSI commands (or unique interpretations of
such).
However, to be successful, the lower layers of SCSI protocol would
have to be adhered to.
.P
For these reasons, SCSI is not a candidate for a complete implementation
into the PWS/RMB I/O subsystems.
For PWS this means that the I/O procedures defined in the PWS Procedure
Library Manual will not be supported, and for RMB this means the
INPUT, OUTPUT, and TRANSFER commands will not work for direct calls
to the SCSI interface.
.P
A user's interface to SCSI can be greatly simplified, however, by providing
a programmable interface to the Transport Level.  This is, in fact,
what I propose to do.
.H 2 "SCSI-1 vs. SCSI-2"
.P
The first ANSI standard for SCSI was published in 1986 \*(AN.
This definition
has many extended and optional commands that can actually lead to
mutually exclusive implementations.
To address this problem,
an industry group has published a SCSI
Common Command Set (CCS) \*(CS.
Most current industry applications support the CCS.
.P
The next version of SCSI is close to being submitted to ANSI.
This version, SCSI-2, is greatly enhanced in device classes, commands,
and also messages.
However, great care is being taken to ensure a SCSI-1 based host can
work with SCSI-2 devices.
.P
The S300 HP-UX SCSI implementation is based on the SCSI-1/CCS standard
and has already ran SCSI-2 based devices.
There are no plans to upgrade the S300 HP-UX implementation to
SCSI-2.
.H 2 "Proposed Architecture"
.P
The following block diagram indicates the basic architecture I propose
to implement:
.DS
.B

__________________________________________________________________
.R

	+-----+-----+-----+-----+-----+
	|     |     |     |     |     |
	|  D  |  T  |  P  |U  R |     |		PWS T.M.s or RMB device
	|  I  |  A  |  R  |S  O |     |		dependent drivers. 
	|  S  |  P  |  I  |E  U | ... |		
	|  K  |  E  |  N  |R  T |     |		In addition, a PWS user
	|     |     |  T  |   I |     |		can write his own
	|     |     |  E  |   N |     |		peripheral driver.
	|     |     |  R  |   E |     |
	+-----+-----+-----+-----+-----+

	+-----------------------------+
	|    SCSI Command Interface   |		Generic Interface to
	|      (Transport Layer)      |		SCSI Bus.  Published.
	+-----------------------------+

	+-----------------------------+
	|     SCSI Message Handler    |		SCSI specific.
	|       (Network Layer)       |		Not published.
	+-----------------------------+
	                                  
	+-----------------------------+
	|      SCSI H/W Interface     |		SCSI specific.
	| (Physical/Data Link Layers) |		Not published.
	+-----------------------------+


.FG "SCSI Block Architecture"

.B
__________________________________________________________________

.R
.DE
.P
A Generic SCSI Driver will comprise the SCSI Command Interface
on down and will be common to both PWS and RMB.
This driver will be implemented as an interrupt driven state machine.
Refer to the preliminary IRS for more details.
.P
To send a SCSI command to a target device and get status back,
a program will interface to the
Generic SCSI Driver.
This interface, discussed in the Preliminary ERS,
will be published in the Procedure
Library for PWS, but not in any RMB manuals.
On top of this interface PWS/RMB (and PWS programmers)
interface to SCSI peripherals, and lower layers of hidden software
ensure proper access and error handling.
.H 2 "What needs to be done"
.P
To support SCSI on PWS and RMB an implementation strategy should be
devised whereby the user will see no difference between the operation
of a SCSI device and any other currently supported device.
.P
As much source code as possible should be common to
both workstations.
.P
.H 3 "For both PWS and RMB"
a Generic SCSI Driver should be developed that implements the
physical through transport layers.  This driver would be common
source for both workstations.  To communicate with any SCSI peripheral
(of any class) both workstations should interface only to this driver.
.H 3 "For PWS"
a TM for each supported device class should be developed that interfaces
to the Generic SCSI Driver.
Currently, only a TM for the direct access device class (disks) has been
investigated.
.P
The TABLE program will have to be modified and auto-configuration,
similar to CS80, should be implemented.
.P
The MEDIAINIT program will have to be modified to directly call the
Generic SCSI Driver to format the SCSI disk (SCSI tape support is
not currently planned).
.P
Named reboot needs to be extended to support reboot to a PWS UNIT
that has a SCSI disk TM.
.P
A new chapter in the PWS Procedure Library manual will
have to be added to describe
the Generic Driver Interface, thereby allowing programmers to support
unique SCSI devices.  In addition, modifications through out the
documentation will be required to describe what files need to be
loaded for SCSI support, and when and how to load them.
.H 3 "For RMB"
a set of device dependent drivers will have to be written to interface
each SCSI device class to the BASIC workstation and the Generic SCSI Driver.
For disks, these drivers will be:
.BL 5 1
.LI
SCSI_dsize: get disk size parameters
.LI
SCSIinit: prepare for a series of reads and writes
.LI
SCSIread: read data from a SCSI disk
.LI
SCSIwrite: write data to a SCSI disk
.LI
SCSIterm: terminate series of reads and writes
.LI
SCSIinitialize: format a SCSI disk
.LI
SCSI_pwrup: perform power up initializations
.LE
.P
RMB does not auto-configure so modifications to a TABLE like
program will not be necessary.  However, the proposed 6.0 volume
specifier will have to include SCSI volumes.
.P
The RMB documentation will have to be modified to describe SCSI usage
and how to obtain it in RMB.
.H 2 "Hardware Resources Required"
.P
.BL 5 1
.LI
SCSI Hard Disk: 7957S, 7958S, or 7959S.  7958S on hand. 
.LI
SCSI Optical Disk: 6300 Model 650/A.  Ordered.
.LI
S300 Piggy Back SCSI Interface: 98265A (replaces high speed HP-IB).
On hand.
.LI
S300 DIO-1 SCSI Interface: 98658A.  Ordered.
.LI
SCSI Bus Logic Analyzer (there is at least one in Fort Collins).
.LE
.H 2 "What will not be done"
.P
Support of SCSI tapes and printers have not been investigated.
SCSI tapes and printers are not supported by S300 HP-UX.
(However SCSI tape support is committed for S300 HP-UX 8.0).
.P
The PWS I/O procedure defined in the PWS Procedure Library Manual
will not be implemented.
.P
The RMB INPUT, OUTPUT, and TRANSFER commands will not work for direct
calls to the SCSI interface (they will work for file access).
.P
RMB Programmers access to the Generic SCSI Driver will not be provided.
.SK
.H 2 "Estimates"
.DS

TASK					50%		90%

Generic Driver Development		2 weeks		3 weeks
Generic Driver Test Development		2 weeks		2 weeks
Generic Driver Test			2 weeks		2 weeks

PWS TM Development			1 week		1 week
PWS TM Test				1 week		2 weeks
PWS CTABLE Modification			3 days		1 week
PWS CTABLE Test				1 week		1 week
PWS MEDIAINIT Modification		2 days		3 days
PWS MEDIAINIT Test			2 days		3 days
PWS Named Reboot Mod & Test		1 day		2 days
PWS Documentation			2 weeks		3 weeks

RMB Disk Driver Development		1 week 		1 week
RMB Disk Driver Test			1 week		2 weeks
RMB Documentation			2 weeks		3 weeks

.DE
.P
From the above estimates, I extract the following summary
information:
.DS

SCSI on PWS and RMB			16.5 weeks	22.5 weeks
SCSI on PWS				12.5 weeks	16.5 weeks
SCSI on RMB				10 weeks	13 weeks

.DE
.P
.B
NOTE:
.R
SCSI Tapes and Printers are not included.
.H 2 "Goals"
.P
Following is a list of
development goals for supporting SCSI
on PWS and RMB.
.BL
.LI
Operationally, the user will perceive no difference between
running a SCSI based disk or a disk based on another communication
protocol.
.LI
All currently supported PWS and RMB Directory Access Methods (LIF, HFS, etc.)
will work without change on a SCSI disk.
.LI
The RMB Mass Storage Volume Specifier will not change.
.LI
As much source as possible will be shared among the PWS and RMB workstations.
.LI
Provide programmer's access to the SCSI bus on PWS.
.LI
Subset of SCSI-1 and CCS support.
.LI
If 3.22 CTABLE can be compiled and run on a PWS workstation with only
512K, then after SCSI CTABLE modifications should still be able to
compile and run with only 512K.
.P
Question: given cheap memory available, should this still be a PWS
requirement?
.LE
.H 2 "Non Goals"
.P
Following is a list of items that are
.ul
not goals and not planned
for SCSI development on PWS and RMB.
.BL
.LI
Support of the I/O procedures and driver hooks defined in the
PWS Procedure Library Manual.
When these procedures and hooks are used to communicate with
the SCSI interface, an error will occur.
.LI
Support of the RMB INPUT, OUTPUT, and TRANSFER commands when
directed to a SCSI interface (they will work for file access).
When these commands are directed to a SCSI interface, an
error will occur.
.LI
Provide programmer's access ot the SCSI bus on RMB.
.LI
SCSI-2 or HPCS 1.0 support.
.LI
SCSI Tape support.
.LI
SCSI Printer support.
.LE
.H 2 "SCSI Version on PWS and RMB"
.P
The SCSI implementation for PWS/RMB will be SCSI-1 based.
This implementation has been chosen for two reasons:
.AL
.LI
All S300 platforms will have a consistent implementation.
(S300 HP-UX SCSI version is SCSI-1 and there are not any plans
to update to SCSI-2 or HPCS 1.0).
.LI
A full SCSI-2 implementation is beyond the current and forseeable
resources for PWS/RMB.
The attitude being if SCSI-2 devices will work with PWS/RMB workstations,
with the caveat that all of the features or host offloading provided
by that device can not be harnessed, then that is OK.
Marketing input would be required to alter this
philosophy.
.H 2 "Common Code: Generic SCSI Driver"
.P
Rocky Mountain Basic, referred to herein as RMB, is developed on the
Pascal Workstation.
Given this, then with care, a common core of code can be developed
and shared among the workstations.
Leveraging the development can lead to lower development
and maintenance costs for both products and a consistent implementation
across both workstations.
.P
.B
NOTE:
.R
Common source for a SCSI driver
precludes the use of the PWS I/O subsystem.  Basic's I/O subsystem
is not compatible with Pascal's.
However,
SCSI is not suited as a general I/O system and therefore this is
not perceived as an issue.
.P
A
.ul
Generic SCSI Driver
that implements the Physical
through Transport layers will be shared among
PWS and RMB.
All software that interfaces to the Generic SCSI Driver
is considered
.ul
Session Layer
software.
.P
Software interfacing to a SCSI device will do so through the
Generic SCSI Driver.  The interface to this driver is discussed
in the next section.
.P
PWS Session Layer programs using the Generic SCSI Driver are:
.BL 5 1
.LI
SCSI Disk Transfer Method
.LI
Table
.LI
Mediainit
.LE
.P
RMB Session Layer programs using the Generic SCSI Driver are the
device dependent drivers.
The RMB device dependent drivers for SCSI are:
.BL 5 1
.LI
SCSI_dsize: get disk size parameters
.LI
SCSIinit: prepare for a series of reads and writes
.LI
SCSIread: read data from a SCSI disk
.LI
SCSIwrite: write data to a SCSI disk
.LI
SCSIterm: terminate series of reads and writes
.LI
SCSIinitialize: format a SCSI disk
.LI
SCSI_pwrup: perform power up initializations
.LE
.P
.H 2 "Generic SCSI Driver Interface"
.P
The Generic SCSI Driver handles SCSI sessions.
To understand the interface to the Generic SCSI Driver, one
must first understand what a SCSI session is.
.H 3 "SCSI Session"
.br
.P
A SCSI session is a term used to represent the standard sequence of events
that take place while a SCSI host communicates with a SCSI target device.
A session consists of arbitrating for the bus, selecting a target
device, sending a command to the device, optionally sending data to or 
getting data from the target device (depends on the command), getting
status back from the target device and finally releasing the bus.
.P
A session can be extended by linking commands together.
A special bit set in the first command tells the target device
that this command is linked to following commands.
After the target device sends status back to the
host, the host (providing the status was good) sends another
command (which may or may not be linked) to the target device.
.P
It is convenient to consider SCSI operations only from the viewpoint of
commands,
and let the transportation of these commands and subsequent data be
left to lower layers of code.
Thus, the Session Layer would format commands, provide buffers for data,
and hand these off to the Transport Layer.
Upon command completion, the Session Layer would receive and interpret
the status.
.P
The interface to the transport layer is the entry point to the
Generic SCSI Driver.
.H 3 "OSI Layering Responsibilities"
.br
.P
For the purposes of this document,
it is inappropriate to go into the details of each layer's responsibility,
however a summary follows.
For those who are familiar with SCSI concepts, but have
not considered OSIRM layering as a parallel, this may prove interesting.
Figure 2 indicates a correspondence between SCSI functionality and some of
the OSI Reference Model layers.
.P
The transport layer ensures proper sequencing of commands,
data, and status and passes information to the network layer
for transportation.
The network layer sets up a path between the host and
target device and maintains it during the communication
of commands, data, and status.
SCSI messages are used for this purpose.
Note that disconnect/reconnect is handled here.
.P
The transport layer works with the data link layer to perform the
path setup, data transfer, and path termination.
For SCSI this means bus arbitration,
proper bus phases, communication mode (asynchronous
vs. synchronous transmission), and memory access (DMA or programmatic).
Communication error handling occurs at this interface as well.
.DS
__________________________________________________________________

.DE
.VL 27
.LI OSIRM\ Layer
SCSI Functionality
.LI Transport\ Layer
SCSI Commands, Data, and Status
.LI Network\ Layer
SCSI Messages
.LI Data/Physical\ Layers
Bus phases, Bus signals that define the bus phases,
Arbitration Protocol, Asynchronous and Synchronous
Data Transfer Protocols, DMA, Parity Errors, Bus
Resets, etc.
.LE
.DS

.FG "OSIRM and SCSI"
.B
__________________________________________________________________

.R
.DE

.H 3 "Interface Details"
.br
.P
The primary access to the Generic SCSI Driver will be through a SessionBlock.
The caller will acquire memory for a SessionBlock, fill out the necessary
parameters, and call the procedure DoSession.
The types of things in the SessionBlock are:
.BL 5 1
.LI
Select Code
.LI
Device Number (similar to HP-IB bus address)
.LI
Logical Unit Number
.LI
Sub Logical Unit Number
.LI
Pointer to SCSI Command
.LI
Command Length
.LI
Buffer In Block.  For input transfers.  Contains such things as:
.BL 5 1
.LI
Pointer to Buffer
.LI
Transfer Length
.LI
Protocol Type (Sync, Async)
.LI
Transfer Type (DMA, Programmatic)
.LI
Overlap Boolean
.LI
Call Back Procedure (If Overlap and this is non-zero, when transfer is
done this procedure is called).
.LI
DoNotDisconnect Boolean.  Allows caller to tell driver not to allow
SCSI disconnect.
.LE
.LI
Buffer Out Block.  For output transfers.  Identical in content to
the Buffer In Block.
.LI
Command Status (placed here upon session completion).
Comes from the Target Device.
.LI
Internal Status (placed here upon session completion).
Non zero if an error has occurred.
.LI
InternalBlock.  This is used internally by the SCSI driver.
.LE
.P
.B
NOTE:
.R
This is not a definitive list.
.P
All of the user provided parameters in the SessionBlock (everything
but the Status parameters and the InternalBlock) will remain
unchanged;
allowing the caller to reuse it.
Of course, the data buffers pointed to by the SessionBlock may be 
modified, if the command generates a data transfer sequence.
.P
The SessionBlock merely contains a pointer to the command to be 
sent to the target device.  It is the caller's responsibility to
acquire memory for the command and properly format it (Commands
are of variable length).
To assist the caller, a procedure will be provided that, given the 
correct information, will format commands.
.P
Extended session through linked commands will be supported by the
SCSI driver.
This is accomplished by means of the same SessionBlock described
previously, however the procedure DoLnSession is called with
an additional parameter that contains the address of a procedure
to call back (LinkedCBProc) when the next linked command 
requires retrieval.
.P
Among the parameters given the LinkedCBProc procedure one will be
a pointer to the SessionBlock.  This procedure fills out the next command
and buffer information in the SessionBlock and returns.
Before returning, the LinkedCBProc should handle any data pointed
to in the SessionBlock or it may be overwritten!
.P
For overlapped sessions that do not have a call back procedure, a
function will be provided that returns a BOOLEAN indicating if
the session has completed or not.
.P
Other procedures provided will enable the caller to abort the current
session, reset a SCSI device, or reset the SCSI bus.
.P
The primary reason for the SessionBlock is to allow distributed arbitration
within PWS/RMB.
This is necessary to support the OVERLAP Transfer required by the
RMB device drivers and widely implemented on other communication media
on PWS.
.H 2 "PWS Software Required"
.P
To use a SCSI disk, the user will have to add the Generic SCSI
Driver and the SCSI Disk Transfer Method to the INITLIB module.
These will be separate files.
The file names are:
.BL 5 1
.LI
Generic SCSI Driver:  SCSILIB
.LI
SCSI Disk TM:  SCSIDISK
.LE
.P
.H 2 "PWS Disk Changes"
.P
THE SCSILIB and SCSIDISK files will be placed on the CONFIG: disk for
single sided media (options 042 and 044), and
on the ACCESS: disk for double sided media (options 045).
.P
.B
NOTE:
.R
The single sided CONFIG disk may not have enough room to support
these changes, and if so other arrangements will have to be made.
.H 2 "PWS Documentation Changes"
.P
The Procedure Library will receive a new chapter describing
the interface to the Generic SCSI Driver.
.P
Workstation System Volumes II will require modifications to describe
how to add SCSILIB and SCSIDISK to the INITLIB.
.H 2 "RMB Software Required"
.P
To use a SCSI device, two binaries will have to be loaded, one
for the Generic SCSI Driver, and one for the SCSI disk drivers.
These files are:
.BL 5 1
.LI
SCSI: Generic SCSI Driver
.LI
SCSIDISK: SCSI disk drivers
.LE
.H 2 "RMB Disk Changes"
.P
THE SCSI and SCSIDISK files will be placed on the DRIVERS disk for
single sided media (options 042 and 044), and
on the DRIVERS & EXTENSIONS disk for double sided media (options 045).
.H 2 "RMB Documentation Changes"
.P
The following BASIC Manuals will require modifications:
.BL 5 1
.LI
Programming Techniques; Volumes 1 & 2
.LI
Using the BASIC System
.LI
Language Reference; Volume 1
.LI
Installing and Maintaining the BASIC System
.LE
.H 2 "SCSI Device Requirements"
.P
Any SCSI device that is supported using the Generic SCSI Driver
will have to support the following SCSI messages:
.BL 5 1
.LI
Identify
.LI
Restore Pointers
.LI
Message Reject
.LI
Abort
.LI
Message Parity Error
.LI
No Operation
.LI
Bus Device Reset
.LI
Command Complete
.LE
.P
These are the CCS required messages.  In addition, the SCSI driver
supports the following messages:
.BL 5 1
.LI
Disconnect
.LI
Save Data Pointer
.LI
Extended Identify
.LI
Extended Synchronous Data Transfer Request
.LI
Linked Command Complete
.LI
Linked Command Complete With Flag
.LI
Initiator Detected Error
.LE
.P
The SCSI features of disconnect (distributed arbitration), synchronous
transfer, and linked commands are supported
by the Generic SCSI Driver.
To allow implementors some freedom, these options
can be turned off via flags in the SessionBlock.  (The synchronous
data transfer option in the SessionBlock may be taken away; it may
not be possible, or at least highly undesirable, to tell a target device not
to do this once it has been told it is OK).
.H 2 "SCSI Disk Requirements & Issues"
.P
Implementing the Session Level Interface to the Generic SCSI Driver
is a unique activity for both PWS and RMB.
However, the final implementation on both workstations should be
functionally equivalent.
Therefore, both workstations will require that target SCSI disks support
these SCSI commands:
.BL 5 1
.LI
Test Unit Ready
.LI
Request Sense
.LI
Format Unit
.LI
Read
.LI
Write
.LI
Inquiry
.LI
Read Capacity
.LI
Read Extended
.LI
Write Extended
.LE
.P
This list is a subset of the CCS required commands, so any disk that
claims CCS conformity for SCSI-1 should, in theory, work with
PWS and RMB.
.P
.B
NOTE:
.R
The S300 HP-UX implementation requires the Mode Sense command, which
is not currently in RMB/PWS required list.  Mode Sense is NOT a
CCS required command.
.P
.B
NOTE:
.R
The target device
.ul
must
support linked commands for the Session Layer software to use them.
Because linked commands are not required for CCS conformance, the
PWS/RMB disk drivers will not use this feature.
.H 3 "SCSI Disk Issues"
.P
The PWS and RMB workstations force the Session Layer of software to acquire
all needed memory when they are first loaded.
SCSI devices, on the other hand, report a Logical Block Size after
initialization and this Block Size is reported in 32 bits.
Unlike CS80 disks, SCSI disks can have all sorts of different block
size and it is dependent on the manufacturer.
Unix, which allows drivers to go off and get memory, does not have
a problem with this, but RMB and PWS must know before hand what size
block to request.
The issue to be resolved is what the average block size of the
many SCSI disks on the market is?
.P
Early feedback indicates a 4K buffer will be sufficient.
.H 2 "SCSI Tapes"
.P
SCSI Tapes will not be supported in the first release of SCSI on
either PWS or RMB.
If they were, a separate PWS TM and RMB device dependent driver
would have to be implemented.
.P
S300 HP-UX does not currently support SCSI tapes although tape
support is committed for release 8.0.
HP SCSI based tape drives are being developed.
.H 2 "SCSI Printers"
.P
SCSI Printers will not be supported in the first release of SCSI on
either PWS or RMB.
If they were, a separate PWS TM and RMB device dependent driver
would have to be implemented.
.P
S300 HP-UX does not support SCSI printers, and currently there are
no plans to do so.
Currently, HP does not make a SCSI printer.
