.H 1 "SCSI Testing"
.H 2 "Overview"
.P
.P
This release will support three new SCSI disks :  the MACE TEAC floppy,
the MACE built-in Quantum hard disk, and the MACE built-in RODIME
hard disk. The SCSI test suite needs to be run on the new MACE SPU's
(362 and 382) with these new disks, and also against at least one
older disk with the new 385 for reqression testing.

There is one version of the TEAC, one version of the RODIME (200
Mbyte), and three versions of the QUANTUM (52, 210, and 425 Mbytes).
All versions of the QUANTUM drive should be tested, if possible.

Also a special series of tests (see below) will be run with the TEAC
floppy drive to ensure proper functioning across all sector sizes.

Note - single sided floppy discs are not supported in the TEAC drive.

.P
.H 3 "Code Reviews"
.SP
A small code review will be required as there were a few changes in the
SCSI driver to support the TEAC floppy drive. This code review will be
conducted by Jeff Hendershot and Charlie Brett.
.H 3 "Coverage testings"
.SP 
Coverage testing consists of running tests aimed at testing the changes 
on code which has been bugfixed or enhanced, and on related areas where we 
suspect interactions with the change. These tests are independent of existing
test suites.
.P
Coverage testing will be required for the 3.25 release as the code was
enhanced slightly to support the TEAC floppy drive and the QUANTUM drive.
No changes were required to support the RODIME drive.
The coverage testing is designed to explicitly test the changes required
to support the TEAC and QUANTUM drives.
.H 3 "Test Suites"
.SP
PaWS has SCSI test suites for the following areas :
.BL 5 1
.LI
ScsiHandleSession routine verification
.LI
SCSI Programmer's interface verification
.LI
Transfer Method (TM) interface verification
.LI
Disc Qualification
.H 2 "Specific Test Plans"
.P
.H 3 "Criteria"
.BL
.LI
Test the SCSI driver with at least one supported disk and the new
33-Mhz 68040 385 SPU to ensure there are no side effects in the SCSI
driver due to support of the new SPU. This testing amounts to
simply running the SCSI test suite with a 385 and a currently supported
disk.
.LI
Test all combinations of the 362/382 with the built-in TEAC, RODIME, and
QUANTUM disk drives. This amounts to running through the SCSI test
suite 10 different times.
.LI
Use special tests to carry out coverage testing of the TEAC floppy drive.
.LI
Use special tests to carry out coverage testing of the QUANTUM drive,
if needed.
.LE
.H 3 "Test Configurations"
.P
The following chart indicates the test matrix to be used for SCSI testing
for 3.25. The rows are SPUs and disc, the columns are test suites and
specific coverage tests.
.P
The abbreviations used in the following chart are:
.VL 5 8 1
.LI HS=
SCSI Handlesession Testing.
.LI CT=
TEAC Coverage Testing.
.LI PI=
Programmer's Interface tests.
.LI TM=
Transfer Method tests.
.LI DQ=
Disc Qualification tests.
.LE
.DS


SPU & discs            Required Testing
_________________________________________________________
382     
   +TEAC               HS,CT,PI,TM,DQ
   +QUANTUM(52)        HS,CT,PI,TM,DQ
   +QUANTUM(210)       HS,CT,PI,TM,DQ
   +QUANTUM(425)       HS,CT,PI,TM,DQ
   +RODIME(200)        HS,PI,TM,DQ
_________________________________________________________
362     
   +TEAC               HS,CT,PI,TM,DQ
   +QUANTUM(52)        HS,CT,PI,TM,DQ
   +QUANTUM(210)       HS,CT,PI,TM,DQ
   +QUANTUM(425)       HS,CT,PI,TM,DQ
   +RODIME(200)        HS,PI,TM,DQ
_________________________________________________________
385+(any supported     HS,PI,TM
     SCSI disc)

.DE
.P
Estimate 2 hours for each matrix row, including test set-up
time, for 50 % planning, and 3 hours for each matrix row for
90 % planning.
.H 3 "Coverage Testing"
.P
.H 4 "TEAC Coverage Testing"
.P
The software changes required for support of the TEAC floppy drive
are designed to allow the drive to work properly with floppy discs
of differing sector sizes (256, 512 and 1024 bytes). The coverage
testing centers on testing functionality while changing floppy discs
which may have varying sector sizes.

.DS
1.) White box test ALL system utilities that operate on files against
    files present on floppy discs inserted in the TEAC drive. 
    Specifically, test :

    MEDIAINIT

    - should work with format options 0,1,2 and 3

    MKHFS

    - should be able to build an HFS floppy with the TEAC

    FILER

    - all file copy and translate utilities
    - unit to unit and volume to volume copy, with same size floppies
    - all other FILER commands

    EDITOR

    - all file save utilities upon exiting the editor

    COMPILER
    ASSEMBLER
    LIBRARIAN

    - just sanity check (open and operate on a file)

    All this testing should be carried out with floppies being inserted
    and removed at random times and with varying sector sizes.

.DE
.H 3 "Estimates"
.DS

.ul
	50		90		Description

	 1 mts days	 1 mts days	Code Review
	 1 mts days	 1 mts days	Test Development
	 3 mts days	 4 mts days	Matrix execution
	 3 mts days	 5 mts days	Defect Repair

	 8 mts days	11 mts days	Total

.DE
