/* HPUX_ID: @(#)checklist.h	27.1     85/04/28  */
/* $Source: /mnt/azure/popcorn/root.port/usr/include/RCS/fstab.h,v $
 * $Revision: 1.1 $	$Author: wallace $
 * $State: Exp $   	$Locker:  $
 * $Date: 84/02/22 14:00:58 $
 *
 * $Log:	fstab.h,v $
 * Revision 1.1  84/02/22  14:00:58  wallace (Kevin G. Wallace)
 * Remove SCCS string.
 * 
 * Revision 1.0  84/02/22  11:24:31  wallace (Kevin G. Wallace)
 * Initial revision
 * 
 * $Endlog$
 *
 * Changes are made to reflect FSD new checklist.5 
 * hn   4/18/85
 */



/*
 * File system table, see checklist (5)
 *
 * Used by dump, mount, umount, swapon, fsck, df, ...
 *
 * The fs_spec field is the block special name.  Programs
 * that want to use the character special name must create
 * that name by prepending a 'r' after the right most slash.
 * Quota files are always named "quotas", so if type is "rq",
 * then use concatenation of fs_file and "quotas" to locate
 * quota file.
 */
#define	CHECKLIST	"/etc/checklist"

#define	CHECKLIST_RW	"rw"	/* read/write device */
#define	CHECKLIST_RO	"ro"	/* read-only device */
#define	CHECKLIST_SW	"sw"	/* swap device */
#define	CHECKLIST_XX	"xx"	/* ignore totally */

struct	checklist{
	char	*fs_spec;		/* special device name */
	char    *fs_bspec;		/* block special file name */
	char	*fs_dir;		/* file system path prefix */
	char	*fs_type;		/* file system type */
	int	fs_passno;		/* pass number on parallel fsck */
	int	fs_freq;		/* dump frequency, in days */
};

struct	checklist *getfsent();
struct	checklist *getfsspec();
struct	checklist *getfsfile();
struct	checklist *getfstype();
int	setfsent();
int	endfsent();
