/* @(#)  HP Windows/9000  fa.h  39.1  11/15/85  16:35:20 */

/*
 * HP Windows/9000 definitions useful for library calls to Fast Alpha routines.
 *
 * The structures defined here are compatible with Fast Alpha systems on
 * other HP computers and terminals.
 */


/************************************************************************
 * BASIC STRUCTURES:
 */

struct fa_coordinate
{
	int x, y;
};

struct fa_rectangle
{
	struct fa_coordinate origin;	/* included in displayed rectangle */
	struct fa_coordinate corner;	/* not included in rectangle	   */
};


/************************************************************************
 * GET/CHANGE DISPLAY PARAMETERS:
 *
 * Structure used by the fagetinfo() and fasetinfo() routines.  All fields
 * are of type int to allow languages other than C to use them.  Expansion
 * space allows field additions without requiring compilation of existing
 * object code.
 */

struct fainfo
{
	struct fa_rectangle size;

	int capabilities;		/* any special capabilities	*/
	int enhancements;		/* valid for this type of FA	*/
	int defaultenhancements;	/* see below			*/
	int cursor;			/* 0 = cannot control; 1 = can	*/
	int fontcellheight;		/* current font height, pixels	*/
	int fontcellwidth;		/* current font width,  pixels	*/
	int foregroundplanes;		/* number on this type display	*/
	int backgroundplanes;		/* number on this type display	*/

	/* following fields specific to HP Windows/9000 */

	int clearbeforewrite;		/* 0 = XOR bits; 1 = clear cell	*/
	int colormode;			/* see below			*/
	int makecurrent;		/* see below			*/

	int ___expansion [17];		/* reserved for future use	*/
};


/************************************************************************
 * DEFAULTENHANCEMENTS FIELD:
 *
 * 
 * Defaultenhancements sets what enhancements will be used when none are
 * given explicitly.
 *
 * They can all be packed (or'd) into an 8-bit quantity.  They are
 * sometimes passed as integers for ease in interfacing to languages other
 * than C, but this is the type for use with fawrite().  They are pushed
 * into the printable ASCII character set by adding the '@' character.
 */

typedef char ENH;

#define	FAOFF		'@'+0x0		/* none		 */
#define	FABLINK		'@'+0x1		/* blinking	 */
#define	FAINVERSE	'@'+0x2		/* inverse video */
#define	FAUNDERLINE	'@'+0x4		/* underlined	 */
#define	FAHALFBRIGHT	'@'+0x8		/* half bright	 */


/************************************************************************
 * COLORMODE FIELD:	(HP Windows/9000 only)
 */

#define	FABONW	0		/* no color, use black on white */
#define	FAWONB	1		/* no color, use white on black */
#define	FACOLOR	2		/* use color if supported	*/
				/* (possible performance cost)	*/


/************************************************************************
 * MAKECURRENT FIELD:	(HP Windows/9000 only)
 *
 * This field tells Fast Alpha when NOT to immediately update (make current)
 * the display after a given operation.  The field is the "or" of these
 * values.  If any type of operation is disabled from update, changes are
 * not visible until a make-current operation is performed (either calling
 * a routine to do a screen update, or setting DO_MC).  Disabling make-
 * current can increase performance.
 */

#define	MCALWAYS	   0x00		/* make current after any op	 */
#define	NOMCONFAWRITE	   0x01		/* no update after write	 */
#define	NOMCONFAROLL	   0x02		/* no update after roll		 */
#define	NOMCONCFLAGTRUE	   0x04		/* none when cursorflag -> true  */
#define	NOMCONCFLAGFALSE   0x08		/* none when cursorflag -> false */
#define	NOMCONFARECTWRITE  0x10		/* none after rectangle write	 */
#define	NOMCONCLEAR	   0x20		/* no update after clear 	 */
#define	DO_MC		   0x80		/* just force an update		 */


/************************************************************************
 * MISCELLANEOUS DEFINITIONS:
 */

#ifndef TRUE
#define TRUE	1
#endif  TRUE

#ifndef FALSE
#define FALSE	0
#endif  FALSE

#ifndef NULL
#define	NULL	0
#endif  NULL

/*
 * Driver values for Fast Alpha initialization:
 * (Assumed to contain at least 16 bits.)
 */

#define	FASERIAL 0x1	/* device driven serially as via RS232		 */
#define	FAWINDOW 0x2	/* display is bit-mapped (e.g. window or ITE)	 */
#define	FAPLANE	 0x4	/* display is a built-in alpha plane, e.g. 9836A */

/*
 * Color bit definitions for multiple-plane systems:
 */

#define FARED	 0x1
#define FAGREEN	 0x2
#define FABLUE	 0x4

/*
 * Roll directions:
 */

#define FAROLLUP     'u'
#define FAROLLDOWN   'd'
#define	FAROLLLEFT   'l'
#define FAROLLRIGHT  'r'

#define FAENHANCE(fd,enhancement,rp)	farectwrite (fd, ' ', enhancement, rp)

/*
 * HP Windows/9000 only:
 */

#define	FACURSORNOMOVE	(-1)		/* invalid cursor coordinate */
