/* HPUX_ID: @(#)pcb.h	27.4		85/06/17 */

/*
 * 68K software process control block
 */

struct pcb
{
  int	pcb_ksp; 	/* kernel stack pointer */
  int	pcb_esp; 	/* exec stack pointer */
	int	pcb_ssp; 	/* supervisor stack pointer */
	int	pcb_usp; 	/* user stack pointer */
	struct  pte *pcb_p0br; 	/* seg 0 base register */
	int	pcb_p0lr; 	/* seg 0 length register and astlevel */
	struct  pte *pcb_p1br; 	/* seg 1 base register */
	int	pcb_p1lr; 	/* seg 1 length register and pme */
/*
 * Software pcb (extension)
 */
#ifdef	WOPR
	int	pcb_szpt; 	/* number of pages of user page table */
	int	pcb_scratch;	/* scratch entry (place holder) */
#else	UMM
	int	pcb_szp0pt; 	/* number of pages of user P0 page table */
	int	pcb_szp1pt; 	/* number of pages of user P1 page table */
#endif	WOPR/UMM
	int	pcb_cmap2;
	int	*pcb_sswap;
	int	pcb_escapecode;
	struct	C__trystuff *pcb_trychain;
	u_char	pcb_flags;	/* machine-dependent flags defined below */
				/* note - assembly language code knows   */
				/*        this field is one byte long.   */

	/* Fields for accessing proper sysent table.  There is one table */
	/* for native object code and a second for compatibility with    */
	/* s200 2.x releases and the Integral PC (aka Pisces).           */
	struct	sysent *pcb_sysent_ptr;
	int	pcb_nsysent;

	int	pcb_float[10];
#ifdef	WOPR
	int	pcb_mc68881[73];
#endif
};

/* bits in pcb_flags */
#define	POP_STACK_BIT	0	/* clean up exception stack after signal */
#define PROBE_BIT	1	/* probe operation in progress */
#define	USER_TRACE_BIT	2	/* trace trap causes user signal */
#define	POP_STACK_MASK	(1 << POP_STACK_BIT)
#define	PROBE_MASK	(1 << PROBE_BIT)
#define	USER_TRACE_MASK	(1 << USER_TRACE_BIT)
#ifdef	WOPR
#define	MULTIPLE_MAP_BIT 3	/* multiple map 68020 address space in 256meg regions */
#define	MULTIPLE_MAP_MASK	(1 << MULTIPLE_MAP_BIT)
#endif

#define	aston() runrun++	/* the best we can do */
