/* HPUX_ID: @(#)vmparam.h	27.5     85/06/27  */

/* defines for various 680x0's */
#define	M68010		0
#define	M68020		1

/*
 * Sizes of the system and user portions of the system page table.
 */
/*
** Explanation of SYSPTSIZE:
**	1) All systems have the first 9 megs (0x900000) defined.  It is
**	   where the kernel code and data, and io space reside.
**	2) USRPTSIZE*NBPG additional bytes of kernel logical space are
**    	   used for mapping user page tables.
**	3) An additional page table is added to cover the other miscellaneous
**	   maps used by the kernel (forkutl, etc) which also need logical space.
**         NOTE: It is assumed that the logical space requirements of these
**	         miscellaneous maps is < 4 megabytes (1 page table).
**	4) The extra NBPG*NPTEPG-1 rounds up to the next page table.
**
**	N.B. SYSPTSIZE for use by locore.s is just the count of kernel page
**	     tables and not the number of ptes.  genassym.c divides SYSPTSIZE
**	     by NPTEPG
*/

#define	SYSPTSIZE	(((0x900000 + USRPTSIZE*NBPG + 2*NPTEPG*NBPG - 1)/ (NPTEPG*NBPG)) * NPTEPG)

/*
** Allow for a total of 2*NPTEPG*NPTEPG ptes (or 2*NPTEPG*NPTEPG*NBPG bytes of
** user logical address space.
*/

#define	USRPTSIZE_WOPR 	(2*NPTEPG)
#define	USRPTSIZE_UMM 	((5*NPTEPG)-2)

#ifdef	WOPR
#define	USRPTSIZE 	USRPTSIZE_WOPR
#endif
#ifdef	UMM
#define	USRPTSIZE 	USRPTSIZE_UMM
#endif

/*
 * The size of the clock loop.
 */
#define	LOOPPAGES	(maxfree - firstfree)

/*
 * The time for a process to be blocked before being very swappable.
 * This is a number of seconds which the system takes as being a non-trivial
 * amount of real time.  You probably shouldn't change this;
 * it is used in subtle ways (fractions and multiples of it are, that is, like
 * half of a ``long time'', almost a long time, etc.)
 * It is related to human patience and other factors which don't really
 * change over time.
 */
#define	MAXSLP 		20

/*
 * A swapped in process is given a small amount of core without being bothered
 * by the page replacement algorithm.  Basically this says that if you are
 * swapped in you deserve some resources.  We protect the last SAFERSS
 * pages against paging and will just swap you out rather than paging you.
 */
#define	SAFERSS		2		/* nominal ``small'' resident set size
					   protected against replacement */

/*
 * DISKRPM is used to estimate the number of paging i/o operations
 * which one can expect from a single disk controller.
 */
#define	DISKRPM		60

/*
 * Klustering constants.  Klustering is the gathering
 * of pages together for pagein/pageout, while clustering
 * is the treatment of hardware page size as though it were
 * larger than it really is.
 *
 * KLMAX gives maximum cluster size in CLSIZE page (cluster-page)
 * units.
 * Note:  KLMAX*CLSIZE must be <= dmmin
 */

/********** THESE CONSTANTS SHOULD BE DEPENDENT ON THE             *****/
/********** CONSTANTS OF THE IMPLEMENTATION (NBPG, DEV_BSIZE, etc) *****/
#define	KLMAX	(8/CLSIZE)
#define	KLSEQL	(4/CLSIZE)		/* in klust if vadvise(VA_SEQL) */
#define	KLIN	(4/CLSIZE)		/* default data/stack in klust */
#define	KLTXT	(4/CLSIZE)		/* default text in klust */
#define	KLOUT	(4/CLSIZE)

/*
 * KLSDIST is the advance or retard of the fifo reclaim for sequential
 * processes data space.
 */
#define	KLSDIST	3		/* klusters advance/retard for seq. fifo */

/*
 * Paging thresholds (see vm_sched.c).
 * Strategy of 9/28/84:
 *	lotsfree is 256k bytes, but at most 1/4 of memory
 *	desfree is  64k  bytes, but at most 1/8 of memory
 *	minfree is  32k bytes,  but at most 1/2 of desfree
 */
#define	LOTSFREE	(256 * 1024)
#define	LOTSFREEFRACT	4
#define	DESFREE		(200 * 1024)
#define	DESFREEFRACT	8
#define	MINFREE		(64 * 1024)
#define	MINFREEFRACT	2

/*
 * Believed threshold (in megabytes) for which interleaved
 * swapping area is desirable.
 */
#define	LOTSOFMEM	2

/*
 * BEWARE THIS DEFINITION WORKS ONLY WITH COUNT OF 1
 */
/*
#define	mapin(pte, v, pfnum, count, prot) \
	(*(int *)(pte) = (pfnum) | (prot), mtpr(TBIS, ptob(v)))
*/
