/* HPUX_ID:  @(#)msgcat.h	27.3    85/03/20  */

#define	NUM_MSG_POS	8	/* Byte pos of number of messages */
#define	DIR_START_POS	12	/* Byte pos of directory starts */
#define	OVERHEAD	DIR_START_POS	/* File overhead size */
#define CATID		"msgcat01"	/* Catalog file ID. */
#define IDLEN		NUM_MSG_POS	/* Catalog file ID. length */
#define SET		"$set"		/* Set command */
#define SETLEN		4		/* Length of "$set" command */
#define DELSET		"$delset"	/* Delete set command */
#define	DELSETLEN	7		/* Length of DELSET command */
#ifndef L_SET
#define	L_SET		0	/* Whence of lseek, set to the address */
#endif
#define	ERROR		-1	/* Functional return to indicate error */
#define	TRUE		1	/* Use as logical value */
#define	FALSE		0	/* Use as logical value */
#define	BUFLEN		12288	/* The length of readbuf */
				/* This sould be multiple of DIRSIZE */
#define	DIRSIZE		12	/* The size of dir */
#define MAX_SETNUM	255	/* Maximum set number */
#define MAX_MSGNUM	32767	/* Maximum message number */
#define MAX_MSGLEN	256	/* Maximum message length */
#define MODE		0664	/* File mode of new catalog file */
#define	E_NO_SET	1001	/* Error - No specified set */
#define	E_NO_MSG	1002	/* Error - No specified message */
#define	E_ILLEGAL_SET	1003	/* Error - Illegal set number */
#define	E_ILLEGAL_MSG	1002	/* Error - Illegal message number */

struct dir {			/* Directory structure */
	short	setnum;		/* Set number */
	short	msgnum;		/* Message number */
	long	addr;		/* Message pointer */
	short	length;		/* The length of the message */
};
typedef	struct dir	DIR;
