/* UNISRC_ID  @(#)direct_access	2.4  85/04/22 */

#ifdef KERNEL
#include "../h/ioctl.h"
#else
#include <sys/ioctl.h>
#endif


/*  Structure used in ioctl's to networking device files.	*/
/*  Ioctl's 'arg' parameter should point to this structure.	*/
    
    struct fis {  int reqtype;
		  int vtype;
		  union {  float  f;
			   int	  i;
			   unsigned char s[100];
			} value;
	       };

/*  Possible arguments for the ioctl's 'request' parameter.	*/

#define NETCTRL	     _IOW(N, 1, struct fis) 
#define NETSTAT	     _IOWR(N, 2, struct fis)	  


/*  structure fis 'vtype' field values					*/
/*									*/
/*  a non-negative value for vtype indicates 's' contains a string of	*/
/*  length 'vtype';  vtype does not account for the trailing null in	*/
/*  'C' language strings						*/

#define FLOATTYPE    -1
#define INTEGERTYPE  -2


/* NETCTRL-only (write-only) values for fis.reqtype  */

#define RESET_INTERFACE		    0	 /* no parameters are needed	 */
#define ADD_MULTICAST		    2	 /* 's' contains the address	 */
#define DELETE_MULTICAST	    3	 /* 's' contains the address	 */
#define ENABLE_BROADCAST	   13	 /* receive broadcast packets	 */
#define DISABLE_BROADCAST	   14	 /* do not receive broadcast	 */
#define LOG_TYPE_FIELD		   51	 /* 'i' contains 'type' field	 */
#define LOG_DEST_ADDR		   52	 /* 's' contains dest. address	 */
#define LOG_READ_TIMEOUT	   53	 /* 'i' contains milliseconds	 */
#define LOG_READ_CACHE		   54	 /* 'i' contains packet count	 */
#define LOG_DSAP		   55	 /* 'i' contains the dsap value	 */
#define LOG_SSAP		   56	 /* 'i' contains the ssap value	 */
#define LOG_CONTROL		   57	 /* 'i' contains control value	 */
#define RESET_STATISTICS	  100	 /* no parameters are needed	 */


/* NETCTRL and NETSTAT (read/write) values for fis.reqtype */
/* certain of these commands may not always be read/write  */
/* see section 4 of the HP-UX reference for particulars	   */

#define LOCAL_ADDRESS		    1	 /* vtype > 0; working address	 */

/* for the following statistics values, the return value for NETSTAT */
/* is an integertype, in 'i'; a NETCTRL resets the statistic to zero */

#define RX_FRAME_COUNT		  101
#define TX_FRAME_COUNT		  102
#define UNDEL_RX_FRAMES		  103  
#define UNTRANS_FRAMES		  104 
#define RX_BAD_CRC_FRAMES	  105 
#define COLLISIONS		  106 
#define DEFERRED		  107 
#define ONE_COLLISION		  108 
#define MORE_COLLISIONS		  109 
#define EXCESS_RETRIES		  110 
#define LATE_COLLISIONS		  111
#define CARRIER_LOST		  112 
#define NO_HEARTBEAT		  113 
#define ALIGNMENT_ERRORS	  114 
#define MISSED_FRAMES		  115 
#define BAD_CONTROL_FIELD	  116 
#define UNKNOWN_PROTOCOL	  117 


/* NETSTAT-only (read-only) values for fis.reqtype  */

#define	    DEVICE_STATUS	5	 /* vtype = INTEGERTYPE		 */
#define	    MULTICAST_ADDRESSES 6	 /* vtype = INTEGERTYPE		 */
#define	    FRAME_HEADER	50	 /* vtype>= 0			 */

/* values returned by DEVICE_STATUS */

#define	    INACTIVE		0
#define	    INITIALIZING	1
#define	    ACTIVE		2
#define	    FAILED		3

/* arg.value.i values for LOG_CONTROL */

#define	    UI_CONTROL		3	 /* unnumbered information; default */
#define	    XID_CONTROL		0xBF	 /* IEEE802 XID frame		    */
#define	    TEST_CONTROL	0xF3	 /* IEEE802 TEST frame		    */

/* device file major numbers */

#define	    DIO_IEEE802		18
#define	    DIO_ETHERNET	19  /* ETHERNET is a XEROX corp. trademark  */
