/* HPUX_ID:  @(#)nl_ctype.h	27.5    85/06/03  */

/*LINTLIBRARY*/
#include	<ctype.h>


#define OK 0
#define FAILED -1

extern int _loadlang;
extern int _faillang;
extern char _nl_ctype[];
extern int ld_nl_ctype();

#define nl_isstar(c,langid,isstar,mask) (langid < 1 || langid == _faillang ? isstar(c):\
					(langid == _loadlang ? (_nl_ctype+1)[c]&(mask):\
					(ld_nl_ctype(langid) == OK ? (_nl_ctype+1)[c]&(mask):\
					 	isstar(c))))

#define nl_isalpha(c,langid)	nl_isstar(c,langid,isalpha,_U|_L)
#define nl_isupper(c,langid)	nl_isstar(c,langid,isupper,_U)
#define nl_islower(c,langid)	nl_isstar(c,langid,islower,_L)
#define nl_ispunct(c,langid)	nl_isstar(c,langid,ispunct,_P)
#define nl_isalnum(c,langid)	nl_isstar(c,langid,isalnum,_U|_L|_N)
#define nl_isprint(c,langid)	nl_isstar(c,langid,isprint,_P|_U|_L|_N|_B)
#define nl_isgraph(c,langid)	nl_isstar(c,langid,isgraph,_P|_U|_L|_N)
#define nl_iscntrl(c,langid)	nl_isstar(c,langid,iscntrl,_C)
