/* STARBASE_ID:sb.c.h   11/15/85   15:38:20 */
/*    (c) Copyright Hewlett-Packard Company, 1985.  
      All rights are reserved.  Copying or other
      reproduction of this program except for archival
      purposes is prohibited without the prior 
      written consent of Hewlett-Packard Company. 
                  
                  
                  RESTRICTED RIGHTS LEGEND
      
      Use, duplication, or disclosure by the Government
      is subject to restrictions as set forth in 
      paragraph (b) (3) (B) of the Rights in Technical
      Data and Computer Software clause in 
      DAR 7-104.9(a).
      
      HEWLETT-PACKARD COMPANY
      Fort Collins, Colorado                              */


/************************************************************************
 *									*
 *	definitions and types to be included with STARBASE application	*
 *	programs							*
 *									*
 ***********************************************************************/

/*  kinds of graphics devices  */
#define OUTDEV				0
#define INDEV				1
#define OUTINDEV			2
#define OUTMETA				3
#define INMETA				4


/*  clear control parameters  */
#define CLEAR_VDC_EXTENT		1
#define CLEAR_CLIP_RECTANGLE		33
#define CLEAR_DISPLAY_SURFACE		65


/*  clip control parameters  */
#define CLIP_TO_RECT			1
#define CLIP_TO_VDC			2
#define CLIP_OFF			3


/*  gopen open_mode parameter masks  */
#define SPOOLED		0x1	/* if this bit is on, output is spooled */
#define INIT		0x2	/* if this bit is on, device initialization
					occurs */
#define THREE_D		0x4	/* if this bit is on, all transformations are 3D */
#define RESET_DEVICE 0x8 /* if this bit is on, hard reset including p1 & p2 */

/* set p1 p2 units */
#define FRACTIONAL		0
#define METRIC			1

/* mapping modes */
#define ISOTROPIC 		0
#define DISTORT			1

/* Starbase linetypes */
#define SOLID 			0
#define DASH 			1
#define DOT 			2
#define DASH_DOT 		3
#define DASH_DOT_DOT		4
#define LONG_DASH 		5
#define CENTER_DASH 		6
#define CENTER_DASH_DASH 	7

/* polygon interior styles */
#define INT_HOLLOW		0
#define INT_SOLID		1

/* Matrix concatenation types */
#define PRE 0
#define POST 1
#define REPLACE 0
#define PUSH 1

/* character switching modes */
#define ISO_7BIT			0
#define ISO_8BIT			1
#define HP_8BIT				2

/* text precision types */
#define STRING_TEXT		0
#define CHARACTER_TEXT		1
#define STROKE_TEXT		2

/* text transformation types */
#define VDC_TEXT				0
#define WORLD_COORDINATE_TEXT	1
#define TOS_TEXT				2

/*  text alignment enumerated types */
#define TA_LEFT				0
#define TA_CENTER			1
#define TA_RIGHT			2
#define TA_CONTINUOUS_HORIZONTAL	3
#define TA_NORMAL_HORIZONTAL		4
	
#define TA_TOP				0
#define TA_CAP				1
#define TA_HALF				2
#define TA_BASE				3
#define TA_BOTTOM			4
#define TA_CONTINUOUS_VERTICAL		5
#define TA_NORMAL_VERTICAL		6

/*  character path and line path enumerated types  */
#define PATH_RIGHT			0
#define PATH_LEFT			1
#define PATH_UP				2
#define PATH_DOWN			3

/*  input device class enumerated types  */
#define ALL	 	0
#define LOCATOR		1
#define CHOICE		4

/*  event queue states */
#define EMPTY_NO_OVERFLOW		0
#define EMPTY_OVERFLOW			1
#define NOT_EMPTY_NO_OVERFLOW		2
#define NOT_EMPTY_OVERFLOW		3

/*  event message link enumerated types */
#define SIMULTANEOUS_EVENT_FOLLOWS	0
#define SINGLE_EVENT			1

/* gerr printing flags */
#define NO_ERROR_PRINTING	0
#define PRINT_ERRORS		1
#define PRINT_WARNINGS		2

/* GLOBAL gescapes */
#define SWITCH_SEMAPHORE 0
#define READ_COLOR_MAP 1
#define BLINK_PLANES 2

/* GLOBAL raster gescapes */
#define R_GET_FRAME_BUFFER 20
#define R_LOCK_DEVICE	   21
#define R_UNLOCK_DEVICE	   22
#define R_GET_WINDOW_INFO  23
#define R_FULL_FRAME_BUFFER  24
#define R_ALLOC_OFFSCREEN  25
#define R_FREE_OFFSCREEN   26
#define R_BIT_MODE		   27
#define R_BIT_MASK		   28
#define R_DEF_FILL_PAT	   29

/* HPGL gescapes */
#define HPGL_WRITE_BUFFER 100
#define HPGL_SET_PEN_NUM 101
#define HPGL_SET_PEN_SPEED 102
#define HPGL_SET_PEN_WIDTH 103

/* HP26XX gescapes */
#define HP26_PRINT_ESC 200
#define HPTERM_PRINT_ESC 200
#define HPTERM_640x400 201

/* GATOR BOX gescapes */
#define GB_NONE 300

/* GATORADE gescapes */
#define GA_NONE 400

/* TOPCAT gescapes */
#define TC_HALF_PIXEL 500

/* HIL gescapes */
#define ENABLE_AUTO_PROMPT 600
#define DISABLE_AUTO_PROMPT 601
#define PROMPT_ON 602
#define PROMPT_OFF 603
#define TRIGGER_ON_RELEASE 604
#define IGNORE_RELEASE 605

/* GKSM gescapes */
#define GKSM_WRITE_ITEM 700
#define GKSM_GET_ITEM_TYPE 701
#define GKSM_READ_ITEM 702
#define GKSM_SKIP_ITEM 703
#define GKSM_INQ_COLOR_NDCES 704
#define GKSM_INQ_PAT_REP 705

/* boolean values */
#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif

/* translation routines */
#define await_event	c_await_event
#define background_color	c_background_color
#define block_move	c_block_move
#define block_read	c_block_read
#define block_write	c_block_write
#define character_expansion_factor	c_character_expansion_factor
#define character_height	c_character_height
#define text_orientation2d	c_text_orientation2d
#define text_orientation3d	c_text_orientation3d
#define character_slant	c_character_slant
#define intra_character_space	c_intra_character_space
#define character_width	c_character_width
#define clip_depth	c_clip_depth
#define clip_rectangle	c_clip_rectangle
#define draw2d	c_draw2d
#define draw3d	c_draw3d
#define echo_type	c_echo_type
#define echo_update	c_echo_update
#define fill_color	c_fill_color
#define line_color	c_line_color
#define line_repeat_length	c_line_repeat_length
#define marker_color	c_marker_color
#define marker_size	c_marker_size
#define marker_orientation	c_marker_orientation
#define move2d	c_move2d
#define move3d	c_move3d
#define perimeter_color	c_perimeter_color
#define perimeter_repeat_length	c_perimeter_repeat_length
#define rectangle	c_rectangle
#define request_choice	c_request_choice
#define request_locator	c_request_locator
#define set_locator	c_set_locator
#define set_p1_p2	c_set_p1_p2
#define text_alignment	c_text_alignment
#define text_color	c_text_color
#define text2d	c_text2d
#define text3d	c_text3d
#define text_line_space	c_text_line_space
#define wc_to_vdc	c_wc_to_vdc
#define vdc_to_wc	c_vdc_to_wc
#define vdc_to_dc	c_vdc_to_dc
#define vdc_extent	c_vdc_extent
#define viewport_justification	c_viewport_justification

typedef union {
	int i[64];
	float f[64];
	char c[255];
} gescape_arg;
