/* HPUX_ID: @(#)cons.h	27.1     85/02/21  */

/*
 Internal keyboard/CRT header file
 */

/*
================================================================================
|	              2622/9836 enhancement types and codes                    |
--------------------------------------------------------------------------------
| half-bright  |   |   |   |   |   |   |   |   | x | x | x | x | x | x | x | x |
================================================================================
| underline    |   |   |   |   | x | x | x | x |   |   |   |   | x | x | x | x |
================================================================================
| inverse video|   |   | x | x |   |   | x | x |   |   | x | x |   |   | x | x |
================================================================================
| blinking     |   | x |   | x |   | x |   | x |   | x |   | x |   | x |   | x |
================================================================================
| end enhance  | x |   |   |   |   |   |   |   |   |   |   |   |   |   |   |   |
================================================================================
| 2622 code    | @ | A | B | C | D | E | F | G | H | I | J | K | L | M | N | O |
================================================================================
| 9836 code    | 00| 02| 01| 03| 04| 06| 05| 07| 08| 0A| 09| 0B| 0C| 0E| 0D| 0F|
================================================================================
NOTE: the 9836 codes are shown in hexadecimal
*/

/* defines for the 9836 enhancement codes */
#define	N_HL	(0x00 << 8)	/* normal                         */
#define H_HL	(0x08 << 8)	/* halfbright                     */
#define U_HL	(0x04 << 8)	/* underline                      */
#define	UH_HL	(0x0C << 8)	/* underline, halfbright          */
#define B_HL	(0x02 << 8)	/* blinking                       */
#define BH_HL	(0x0A << 8)	/* blinking, halfbright           */
#define BU_HL	(0x06 << 8)	/* blinking, underline            */
#define BUH_HL	(0x0E << 8)	/* blinking, underline, halfbright*/
#define I_HL	(0x01 << 8)	/* inverse video                  */
#define IH_HL	(0x09 << 8)	/* inverse, halfbright            */
#define IU_HL	(0x05 << 8)	/* inverse, underline             */
#define IUH_HL	(0x0D << 8)	/* inverse, underline, halfbright */
#define IB_HL	(0x03 << 8)	/* inverse, blinking              */
#define IBH_HL	(0x0B << 8)	/* inverse, blinking, halfbright  */
#define IBU_HL	(0x07 << 8)	/* inverse, blinking, underline   */
#define IBUH_HL	(0x0F << 8)	/* inverse,blink,underline,hlfbrght*/
#define RED_HL	(0x10 << 8)	/* Red Gun On			  */
#define NGREEN_HL (0x20 << 8)	/* Green Gun Off		  */
#define	BLUE_HL	(0x40 << 8)	/* Blue Gun On			  */

/* 2622 terminal emulation defines */

#define	HARD	1	/* hard (power on) reset */
#define	SOFT	2	/* soft reset */

#define	FORWARD     1	/* tab forward */
#define	BACKWARD    2	/* back tab */

#define	TRUE	1
#define	FALSE	0

#define	USER		1
#define	AIDS		2
#define	CLEAR		3
#define MODES		4
#define	MARGINS		5
#define	CONFIG		6
#define	TCONFIG		7
#define	DCONFIG		8
#define	SERVICE		9
#define	SET_USER	10


#define SUPPORTED_LANGUAGES	6	/* must be in sync with enum */
enum languages { ENGLISH, FRENCH, GERMAN, SWEDISH, SPANISH, KATAKANA };

/* console state flags */
#define	ALPHAON		0x01
#define	ALPHA_80_WIDE	0x02
#define SFK_ON		0x04

#define CONSCOUNT	80	/* Size of console output buffer */

struct	iterminal	{

	int	*scr_head;	/* Scroller Commands are added here. */
	int	*scr_tail;	/* Scroller Commands are extracted here. */
	int	scr_count;	/* Number of int's in Scroller Pending Queue. */
	short	*top;		/* First Slot in Top of Full Scroller Memory */
	short	*start;		/* Next Empty Scroller Slot for Top of CRT Image
				** in Scroller Memory */
	short	*crt_start;	/* First Slot in Top of Unlocked CRT Image on
				** CRT */
	short	*stop;		/* Last Filled CRT Slot for Bottom of CRT Image
				** in Scroller Memory */
	short	*crt_stop;	/* Next Empty CRT Slot for Bottom of Unlocked 
				** CRT Image on CRT */
	short	*bottom;	/* Next Empty Scroller Slot for Bottom of Full
				** Scroller Memory */
	short	lines;		/* Number of lines used by CRT Image */
	short	select;		/* Index into Terminal Configuration */
	short	sx;		/* Index into Configuration String */
	char	dsp_funcs;	/* Save of Terminal Configure Display funcs */
	short	first_line;	/* First absolute line on the screen */
	short	last_line;	/* Last absolute line in the scroller */
	char	flds;		/* Field separator */
	char	blkt;		/* Block terminator */
	char	retdef[2];	/* Return definition */

	struct {
		unsigned caps_lock	: 1;
		unsigned caps_mode	: 1;
		unsigned keybd_lock	: 1;
		unsigned mem_lock	: 1;
		unsigned config_lock	: 1;
		unsigned disp_funcs	: 1;
		unsigned local_echo 	: 1;
		unsigned xmit_fnctn 	: 1;
		unsigned remote_mode 	: 1;
		unsigned insert_mode 	: 1;
		unsigned format_mode	: 1;
		unsigned record_mode	: 1;
		unsigned spow_mode	: 1;
		unsigned modify_all	: 1;
		unsigned autolf_mode	: 1;
		unsigned block_mode	: 1;
		unsigned ascii8_mode	: 1;
		unsigned frame_rate	: 1;	/* 0==60 Hz, 1==50 Hz */
		unsigned pad_mode	: 1;	/* 0==Numeric Pad, 1==Graphics Pad */
		unsigned busy		: 1;
		unsigned katakana	: 1;
		unsigned escape		: 1;
		unsigned scroll_lock	: 1;
	} mode;
	char	flags;
	char	c[CONSCOUNT];		/* Character for parser */
	int	count;			/* Number of characters in queue */
	caddr_t	head;			/* Start of character queue */
	caddr_t tail;			/* End of character queue */
	enum 	languages language;	/* language currently being used */
	enum	languages pwr_language;	/* language installed via jumper */
	char  	screenwidth;	        /* number of columns */
	char	screenheight;		/* number of rows */
	short	screensize;		/* size of the display in bytes */
	short	*crtstart;		/* starting address of display memory */
	ushort	enhance;		/* current highlight character */
	short	maxx, maxy;		/* maximum row, column */
	short	xpos, ypos;		/* row, column on crt during scroll */
	short	cxpos, cypos;		/* row, column on crt during configure*/
	char    tabstops[81];		/* tab stop settings */
	short	sfk_clear;		/* Soft key label clear char */
	unsigned char	anychar_state;	/* State of anychar key (0==not active*/
	short	anychar_value;		/* Value of anychar */
	char	key_state;		/* State of f1 thru f8 */
	
};

extern struct iterminal iterminal;

extern char	BELLSTR[];

/* miscellaneous macros */
#define	CONSOLE	&pci_tty[0]
#define	BEEP	kbd_command(BELL,BELLSTR)

extern struct tty pci_tty[];

#define BELL	0xA3		/* set bell information   */


/* CRT io register addresses */
#define CRTBASE  0x510000	/* start of CRT registers        */
#define CRTRPR   1       	/* CRT register pointer offset   */
#define CRTCMD	 3       	/* CRT command register offset   */
 
/* CRT display memory addresses */
#define CRTSFK_26 (0x512704-0x64)	/* start of CRT display memory
				** with 2 rows of sfk labels     */
#define CRTSFK_36 (0x5121A0-0xA0)	/* start of CRT display memory
				** with 2 rows of sfk labels     */
#define SOFTSTART 0x513000	/* start of soft key label area  */

/* CRT cursor offsets */
#define	CRTCUR_26	(0x3381-0x32)	/* start of 9826 cursor */
#define	CRTCUR_36	(0x30CF-0x50)	/* start of 9836 cursor */

/* CRT command register defines */
#define CRTSTRTH 0x0C		/* high byte of crt display address */
#define CRTSTRTL 0x0D		/* high byte of crt display address */
#define HICURSOR 0x0E		/* high byte of cursor address */
#define LOCURSOR 0x0F		/* low byte of cursor address  */

/* configuration address and masks */
#define	ALPHA50		0x01
#define	BIGGRAPH	0x02
#define	HIGHLIGHTS	0x04
#define	NOKBD		0x08
#define	CRTCONFREG	0x10
#define	NOHPIB		0x20
#define	RESERVE2	0x40
#define	RESERVE1	0x80

/* ASCII character defines */
#define	FF	0x0c
#define	US	0x1f
#define	LF	0x0a
#define	CR	0x0d
#define	FS	0x1c
#define	BS	0x08
#define	TAB	0x09
#define	RING	0x07
#define	ESCAPE	0x1b
#define	DEL	0x7f
#define	NUL	0x00

/* Number of Parameters in Action */
#define scroll_params(x)	((x&0xF000)>>12)
/* Scroller Action */
#define	scroll_action(x)	(x&0x0FFF)

#define PRINT_CHAR	0x1000	/* Print_character(c) */
#define	SET_CURSOR	0x2001	/* set_cursor(x,y) */
#define SCROLL_UP	0x0002	/* scroll_up(start_row) */
#define SCROLL_DOWN	0x0003	/* scroll_down(start_row) */
#define	CLEAR_LINE	0x0004	/* clear_line() */
#define CURSOR_DOWN	0x0005	/* cursor_down() */
#define CURSOR_UP	0x0006	/* cursor_up() */
#define	CURSOR_LEFT	0x0007	/* cursor_left() */
#define	CURSOR_RIGHT	0x0008	/* cursor_right() */
#define	INSERT		0x0009	/* insert() */
#define	DELETE		0x000A	/* delete() */
#define	TAB_DIR		0x100B	/* tab(direction) */
#define	SET_TAB		0x000C	/* set_tab() */
#define	CLEAR_TAB	0x000D	/* clear_tab() */
#define	CLEAR_ALL_TABS	0x000E	/* clear_all_tabs() */
#define	ALPHA_ON	0x000F	/* alpha_on() */
#define	ALPHA_OFF	0x0010	/* alpha_off() */
#define	SFK_INPUT	0x1011	/* sfk_input(key) */
#define	DSP_LABELS	0x1012	/* display_labels(mode) */
#define SET_CRT_START	0x0013	/* set_crt_start() */
#define	IND_OVERRUN	0x0014	/* Indicate display scroller overrun */
#define DELETE_LINE	0x1015	/* delete_line(start_row) */
#define INSERT_LINE	0x1016	/* insert_line(start_row) */
#define	ROLL_UP		0x0017	/* roll_up() */
#define	ROLL_DOWN	0x0018	/* roll_down() */
#define LF_CURSOR_DOWN	0x0019	/* lf_cursor_down() */
#define	DOWN_ARROW	0x001A	/* down_arrow() */
#define	UP_ARROW	0x001B	/* up_arrow() */
#define	PREV_PAGE	0x001C	/* prev_page() */
#define	NEXT_PAGE	0x001D	/* next_page() */
#define	AUTOLF		0x101E	/* autolf(state) */
#define	DISP_FUNCS	0x101F	/* disp_funcs(state) */
#define	REMOTE		0x1020	/* remote(state) */
#define	HOME_DOWN	0x0021	/* home_down() */
#define	HOME_UP		0x0022	/* home_up() */
#define	INSERT_MODE	0x1023	/* insert_mode(state) */
#define	CLEAR_SCREEN	0x0024	/* clear_screen() */

#define	SCR_SIZE	200	/* Size of Scroller Action Queue */

/* SOFTKEY definitions */
#define NUMBER_OF_SFKS	8	/* number of soft keys             */
#define	LABEL_SIZE 	8	/* label size for 80 column screen */

extern char *aids_label[];
extern char *modes_label[];
extern char *user_key[];
extern char *user_label[];
extern char *user_defaults[][2];
