/* HPUX_ID: @(#)dbg.h	27.1     85/02/21  */
/*
 * Memory management debugging hooks.
 */
#define DBG_VMEMCHECK	0

/*
 * Process management debugging hooks.
 */
#define DBG_CHKRQS	10

/* 
 * The size of the debug flags array.
 */
#define DBG_NFLAGS	40

/*
 * The dbg macro and external variable declarations.
 */
#ifdef DBG
extern	int	dbgflags[DBG_NFLAGS];
#define dbg(which, proc) \
	if (dbgflags[which]) proc
#define dbgif(which, exp, proc) \
	if (dbgflags[which] && (exp)) proc
#else
#define dbg(a,b) ;
#define dbgif(a,b,c) ;
#endif
