/* HPUX_ID: @(#)file.h	27.7     85/07/08  */


/* 
 * flags- also for fcntl call.
 */
#define	FOPEN		(-1)
#define	FREAD		000001		/* descriptor read/receive'able */
#define	FWRITE		000002		/* descriptor write/send'able */
#define	FNDELAY		000004		/* no delay */
#define	FAPPEND		000010		/* append on each write */
#define	FMARK		000020		/* mark during gc() */
#define	FDEFER		000040		/* defer for next gc pass */

#define FSYNCIO	       0100000		/* Do write through caching */

#define	FREMOTE	01000000		/* File was opened remotely */

/* bits to save after open */
#define	FMASK		(FREAD|FWRITE|FNDELAY|FAPPEND|FSYNCIO|FREMOTE)
#define	FCNTLCANT	(FREAD|FWRITE|FMARK|FDEFER|FREMOTE)

/* open only modes */
#define	FCREAT		00400		/* create if nonexistant */
#define	FTRUNC		01000		/* truncate to zero length */
#define	FEXCL		02000		/* error if already created */


/*
 * Access call.
 */
#ifndef R_OK    CONCERN - F_OK thru R_OK also in unistd.h
#define	F_OK		0	/* does file exist */
#define	X_OK		1	/* is it executable by caller */
#define	W_OK		2	/* writable by caller */
#define	R_OK		4	/* readable by caller */
#endif

/*
 * Lseek call.
 */
#define	L_SET		0	/* absolute offset */
#define	L_INCR		1	/* relative to current offset */
#define	L_XTND		2	/* relative to end of file */

