/* HPUX_ID: @(#)inode.h	27.4     85/03/12  */

/*
 * The I node is the focus of all file activity in UNIX.
 * There is a unique inode allocated for each active file,
 * each current directory, each mounted-on file, text file, and the root.
 * An inode is 'named' by its dev/inumber pair. (iget/iget.c)
 * Data in icommon is read in from permanent inode on volume.
 */

#define	NDADDR	12		/* direct addresses in inode */
#define	NIADDR	3		/* indirect addresses in inode */
				/* fifo's depends on this value */
				/* if this value changes, look */
				/* at icommon.ic_un */

struct inode {
	struct	inode *i_chain[2];	/* must be first */
	u_short	i_flag;
	u_short	i_count;	/* reference count */
	dev_t	i_dev;		/* device where inode resides */
	u_short	i_shlockc;	/* count of shared locks on inode */
	u_short	i_exlockc;	/* count of exclusive locks on inode */
	ino_t	i_number;	/* i number, 1-to-1 with device address */
	struct	fs *i_fs;	/* file sys associated with this inode */
	struct	dquot *i_dquot;	/* quota structure controlling this file */
	union {
		daddr_t	if_lastr;	/* last read (read-ahead) */
		struct	socket *is_socket;
		struct	{
			struct inode  *if_freef;	/* free list forward */
			struct inode **if_freeb;	/* free list back */
		} i_fr;
	} i_un;
	struct i_select {
		struct proc *i_selp;
		short i_selflag;
	} i_fselr, i_fselw;
	struct locklist *i_locklist;	/* locked region list */
	struct 	icommon
	{
		u_short	ic_mode;	/*  0: mode and type of file */
		short	ic_nlink;	/*  2: number of links to file */
		ushort	ic_uid;		/*  4: owner's user id */
		ushort  ic_gid;		/*  6: owner's group id */
		quad	ic_size;	/*  8: number of bytes in file */
		time_t	ic_atime;	/* 16: time last accessed */
		long	ic_atspare;
		time_t	ic_mtime;	/* 24: time last modified */
		long	ic_mtspare;
		time_t	ic_ctime;	/* 32: last time inode changed */
		long	ic_ctspare;
		daddr_t	ic_db[NDADDR];	/* 40: disk block addresses */
		union {
			daddr_t ic_ib[NIADDR]; /* 88: indirect blocks */
			struct {
				short if_frptr;
				short if_fwptr;
				short if_frcnt;
				short if_fwcnt;
				short if_fflag;
				short if_fifosize;
			} ic_fifo;
		} ic_un;
		long	ic_flags;	/* 100: status, currently unused */
		long	ic_blocks;	/* 104: blocks actually held */
		long	ic_spare[5];	/* 108: reserved, currently unused */
	} i_ic;
};

/* file locking hooks -- Sept 1980, John Bass */
struct  locklist
{
     /* NOTE link must be first in struct */
     struct  locklist *ll_link;      /* link to next lock region */
     int     ll_flags;               /* misc flags ** sleeping */
     struct  proc *ll_proc;          /* process which owns region */
     off_t   ll_start;               /* starting offset */
     off_t   ll_end;                 /* ending offset, zero is eof */
};
enum lockf_type {L_LOCKF, L_READ, L_WRITE, L_COPEN};

#define	i_mode		i_ic.ic_mode
#define	i_nlink		i_ic.ic_nlink
#define	i_uid		i_ic.ic_uid
#define	i_gid		i_ic.ic_gid
#define	i_size		i_ic.ic_size.val[1]
#define	i_db		i_ic.ic_db
#define	i_ib		i_ic.ic_un.ic_ib
#define	i_atime		i_ic.ic_atime
#define	i_mtime		i_ic.ic_mtime
#define	i_ctime		i_ic.ic_ctime
#define i_blocks	i_ic.ic_blocks
#define	i_rdev		i_ic.ic_db[0]
#define	i_pseudo	i_ic.ic_db[1]
#define	i_lastr		i_un.if_lastr
#define	i_socket	i_un.is_socket
#define	i_forw		i_chain[0]
#define	i_back		i_chain[1]
#define	i_freef		i_un.i_fr.if_freef
#define	i_freeb		i_un.i_fr.if_freeb
#define i_frptr		i_ic.ic_un.ic_fifo.if_frptr
#define i_fwptr		i_ic.ic_un.ic_fifo.if_fwptr
#define i_frcnt		i_ic.ic_un.ic_fifo.if_frcnt
#define i_fwcnt		i_ic.ic_un.ic_fifo.if_fwcnt
#define i_fflag		i_ic.ic_un.ic_fifo.if_fflag
#define i_fifosize	i_ic.ic_un.ic_fifo.if_fifosize


/* flags */
#define	ILOCKED		0x1		/* inode is locked */
#define	IUPD		0x2		/* file has been modified */
#define	IACC		0x4		/* inode access time to be updated */
#define	IMOUNT		0x8		/* inode is mounted on */
#define	IWANT		0x10		/* some process waiting on lock */
#define	ITEXT		0x20		/* inode is pure text prototype */
#define	ICHG		0x40		/* inode has been changed */
#define	ISHLOCK		0x80		/* file has shared lock */
#define	IEXLOCK		0x100		/* file has exclusive lock */
#define	ILWAIT		0x200		/* someone waiting on file lock */

/* modes */
#define	IFMT		0170000		/* type of file */
#define	IFIFO		0010000		/* fifo */
#define	IFCHR		0020000		/* character special */
#define	IFDIR		0040000		/* directory */
#define	IFBLK		0060000		/* block special */
#define	IFREG		0100000		/* regular */
#define	IFNWK		0110000		/* network special */
#define	IFLNK		0120000		/* symbolic link */
#define	IFSOCK		0140000		/* socket */

#define	ISUID		04000		/* set user id on execution */
#define	ISGID		02000		/* set group id on execution */
#define IENFMT		02000		/* enforced file locking */
#define	ISVTX		01000		/* save swapped text even after use */
#define	IREAD		0400		/* read, write, execute permissions */
#define	IWRITE		0200
#define	IEXEC		0100

#define IFIR 		01		/* fifo read waiting for write flag */
#define	IFIW		02		/* fifo write waiting for read flag */
#define	PIPSIZ		8192		/* fifo buffer size */
#define	FSEL_COLL	01		/* select collision flag */

#define	ILOCK(ip) { \
	while ((ip)->i_flag & ILOCKED) { \
		(ip)->i_flag |= IWANT; \
		sleep((caddr_t)(ip), PINOD); \
	} \
	(ip)->i_flag |= ILOCKED; \
}

#define	IUNLOCK(ip) { \
	(ip)->i_flag &= ~ILOCKED; \
	if ((ip)->i_flag&IWANT) { \
		(ip)->i_flag &= ~IWANT; \
		wakeup((caddr_t)(ip)); \
	} \
}

#define	IUPDAT(ip, t1, t2, waitfor) { \
	if (ip->i_flag&(IUPD|IACC|ICHG)) \
		iupdat(ip, t1, t2, waitfor); \
}
