/* HPUX_ID: @(#)ipc.h	27.1     85/02/21  */
/* @(#)ipc.h	6.1 */
/* Common IPC Access Structure */
struct ipc_perm {
	ushort	uid;	/* owner's user id */
	ushort	gid;	/* owner's group id */
	ushort	cuid;	/* creator's user id */
	ushort	cgid;	/* creator's group id */
	ushort	mode;	/* access modes */
	ushort	seq;	/* slot usage sequence number */
	key_t	key;	/* key */
};

/* Common IPC Definitions. */
/* Mode bits. */
#define	IPC_ALLOC	0100000		/* entry currently allocated */
#define	IPC_LOCKED	0040000		/* structure is locked */
#define	IPC_WANTED	0004000		/* process waiting for lock */
#define	IPC_CREAT	0001000		/* create entry if key doesn't exist */
#define	IPC_EXCL	0002000		/* fail if key exists */
#define	IPC_NOWAIT	0004000		/* error if request must wait */

/* Keys. */
#define	IPC_PRIVATE	(key_t)0	/* private key */

/* Control Commands. */
#define	IPC_RMID	0	/* remove identifier */
#define	IPC_SET		1	/* set options */
#define	IPC_STAT	2	/* get options */

struct ipcmap
{
	short	m_size;
	unsigned short m_addr;
};

#define	ipcmapstart(X)		&X[1]
#define	ipcmapwant(X)		X[0].m_addr
#define	ipcmapsize(X)		X[0].m_size
#define	ipcmapdata(X)		{(X)-2, 0} , {0, 0}
#define	ipcmapinit(X, Y)	X[0].m_size = (Y)-2



