/* HPUX_ID: @(#)lanfunc.h	27.2     85/03/12  */

/*
 * lanfunc.h
 *
 * for configurability, any calls to RFA/LAN code from within
 * the kernel nucleus will be made indirectly through a jump table.
 * 
 * this table is defined here, and initialized in laninit.
 * 
 * this table is declared here, and initialized to nop's in lanfunc.c.
 * When LAN is present in a system, laninit replaces the nop's with
 * appropriate pointers.
 *
 * Warning - lanfunc.c MUST have initialize enough table entries to
 *           cover all the entries here.
 */

/* LAN functions */
#define LAN_EXITHOOK		0
#define LAN_INIT		1

/* RFA functions */
#define	RFA_CLOSE_CDIR		2
#define	RFA_NEWPROC_PARENT	3
#define	RFA_NEWPROC_CHILD	4
#define RFA_SYSCALL		5
#define RFA_LSEEK		6
#define RFA_FSTAT		7
#define RFA_OFSTAT		8
#define RFA_FTRUNCATE		9

/* for declaring the actual table size */
#define LANPROC_SIZE		10

extern	int (*lanproc[])();

#define LANCALL(function) (*lanproc[function])
/* usage: LANCALL(function)(parm1, parm2, ...) */
