/* HPUX_ID: @(#)modem.h	27.5     85/04/01  */
/***********************************************************************
 *
 * file:    modem.h
 *
 *********************************************************************/

#include <sys/ioctl.h>

/* Define the timer ioctl structure */
#define   NMTIMER   6

struct  mtimer {
   unsigned   short   m_timers[NMTIMER];
};

/* Define the bits within the mflag field */
#define MDRS        00000000004   /* Data Rate Select */
#define MDTR        00000000040   /* Data Terminal Ready */
#define MRTS        00010000000   /* Request To Send */
#define MDSR        00002000000   /* Data Set Ready */
#define MDCD        00000400000   /* Data Carrier Detect */
#define MRI         00000000010   /* Ring Indicator */
#define MCTS        00004000000   /* Clear To Send */

/* Define the timer fields */
#define MTCONNECT        0
#define MTCARRIER        1
#define MTNOACTIVITY     2
#define MTHANGUP         3

/* Define the modem ioctl commands */
#define MCGETA      _IOR(M, 1, long)
#define MCSETA      _IOW(M, 2, long)
#define MCSETAW     _IOW(M, 3, long)
#define MCSETAF     _IOW(M, 4, long)
#define MCGETT      _IOR(M, 5, struct mtimer)
#define MCSETT      _IOW(M, 6, struct mtimer)
