/* HPUX_ID: @(#)mount.h	27.3     85/10/31  */

/*
 * Mount structure.
 * One allocated on every mount.
 * Used to find the super block.
 */
struct	mount
{
	dev_t	m_dev;		/* device mounted */
	struct buf *m_bufp;	/* buffer for super block */
	struct inode *m_inodp;	/* pointer to mounted on inode */
	struct	inode *m_qinod;	/* QUOTA: pointer to quota file */
	int	m_flag;		/* status */
	struct inode *m_mount;	/* pointer to mount root inode */
};

/* m_flag values */
#define	MAVAIL	0x0		/* empty */
#define	MINUSE	0x1		/* holds a valid entry */
#define	MINTER	0x2		/* an intermediate state */
#define	MUNMNT	0x4		/* currently being unmounted */

