/* HPUX_ID: @(#)mtio.h	27.4     85/06/28  */

#include <sys/ioctl.h>

/*
 * Structures and definitions for mag tape io control commands
 */

/* structure for MTIOCTOP - mag tape op command */
struct	mtop	{
	short	mt_op;		/* operations defined below */
	daddr_t	mt_count;	/* how many of them */
};

/* operations */
#define MTWEOF	0	/* write an end-of-file record */
#define MTFSF	1	/* forward space file */
#define MTBSF	2	/* backward space file */
#define MTFSR	3	/* forward space record */
#define MTBSR	4	/* backward space record */
#define MTREW	5	/* rewind */
#define MTOFFL	6	/* rewind and put the drive offline */
#define MTNOP	7	/* no operation, sets status only */

/* structure for MTIOCGET - mag tape get status command */

struct	mtget	{
	long	mt_type;	/* type of magtape device */
	long	mt_resid;	/* residual count */
	/* the following registers are device dependent */
	long	mt_dsreg1;	/* status register (msb) */
	long	mt_dsreg2;	/* status register (lsb) */
	long	mt_gstat;	/* generic (device independent) status */
	long	mt_erreg;	/* error register */
};

/*
 * Constants for mt_type
 */
#define	MT_ISTS		0x01
#define	MT_ISHT		0x02
#define	MT_ISTM		0x03
#define MT_IS7970E	0x04
#define MT_ISSTREAM	0x05

/* mag tape io control commands */
#define	MTIOCTOP	_IOW(m, 1, struct mtop)		/* do a mag tape op */
#define	MTIOCGET	_IOR(m, 2, struct mtget)	/* get tape status */

#define	DEFTAPE	"/dev/rmt/0mn"


/*
 * Flags in the minor number
 */
#define MT_DENSITY_MASK	0xC0	/* for extracting density bits */
#define MT_UNIT_MASK	0x30	/* for extracting unit number bits */
#define MT_COMPAT_MODE	0x08	/* don't accept block that crosses eot */
#define MT_SYNC_MODE	0x04	/* don't enable immediate report */
#define MT_UCB_STYLE	0x02	/* don't reposition on read-only closes */
#define MT_NO_AUTO_REW	0x01	/* don't rewind on close */

#define MT_800_BPI	0x00	/* 800 bpi; NRZI format */
#define MT_1600_BPI	0x40	/* 1600 bpi; PE format */
#define MT_6250_BPI	0x80	/* 6250 bpi; GCR format */

