/* HPUX_ID: @(#)privgrp.h	27.2		85/06/27 */

/*
 * Parameters for control of privileged group facility
 */

/*
 * Privileged group definitions
 *
 * All definitions must have the privilege (in upper case) comment
 * so that getprivgrp and setprivgrp may find available privileged
 * groups and associated numbers.  (Don't put privilege (in upper case)
 * anywhere else in this file!)
 */
#define	PRIV_RTPRIO	1	/* PRIVILEGE */
#define	PRIV_MLOCK	2	/* PRIVILEGE */
#define	PRIV_CHOWN	3	/* PRIVILEGE */

/* Multi-word logical or of all privileges.  */
#define PRIV_ALLPRIV(word)	(word == 0 ? 0x7 : 0x0)	/* all privileges */

/* Maximum number of privileged groups in system */
#define PRIV_MAXGRPS	33

/* Size of the privilege mask, based on largest numbered privilege */
#define PRIV_MASKSIZ	2

/* Special group ids recognized by setprivgrp(2) */
#define	PRIV_NONE	-1	/* grant privilege to no one */
#define	PRIV_GLOBAL	-2	/* grant privilege to all */

/* Structure defining the privilege mask */
struct privgrp_map {
    int   		priv_groupno;
    unsigned int	priv_mask[PRIV_MASKSIZ];
};
