/* HPUX_ID: @(#)reboot.h	27.3		85/05/06 */
/*
 * Arguments to reboot system call.
 * These are passed to boot program in r11,
 * and on to init.
 */
#define	RB_AUTOBOOT	0x0000	/* flags for system auto-booting itself */

#define	RB_ASKNAME	0x0001	/* ask for file name to reboot from */
#define	RB_SINGLE	0x0002	/* reboot to single user only */
#define	RB_NOSYNC	0x0004	/* dont sync before reboot */
#define	RB_HALT		0x0008	/* don't reboot, just halt */
#define	RB_INITNAME	0x0010	/* name given for /etc/init */

#define	RB_NEWDEVICE	0x0020	/* name given for device file */
#define	RB_NEWFILE	0x0040	/* name given for file to be booted */

#define	RB_PANIC	0x0080	/* reboot due to panic */
#define	RB_BOOT		0x0100	/* reboot due to boot() */

