/* HPUX_ID: @(#)rfa_user.h	27.1     85/02/21  */
/*
 * rfa_user
 *
 * this file is included only by user.h
 *
 * the rfa_user structure is part of the user structure.
 *
 * NETUNAMS_PER_PROC is also defined in this file.
 *
 * field descriptions
 * ------------------
 *
 *	ur_procmemp		pointer to per-process memory for
 *				this process, or NULL if memory has not
 *				been allocated for this process.
 *
 *	ur_rcdir		pointer to the rfa_inode for the current
 *				working directory if it is remote, or NULL
 *				if the working directory is local
 *
 *	ur_netunam		array of pointers to netunam structures,
 *				representing this process's remote logins
 *	
 *	ur_wasremote		When namei detects a remote path, this
 *				field is incremented.  It is cleared
 *				before every system call.
 *				
 *	The next six fields are the state information saved when namei
 *	detects a remote path.  These are valid only when ur_wasremote != 0.
 *
 *		ur_namei_rwdir
 *			If zero, the remote path starts from the remote
 *			root. Otherwise, the path starts from the current
 *			(remote) working directory.
 *
 *		ur_namei_nsfdev
 *		ur_namei_nsfino
 *			The device and inode numbers of the network special
 *			file used to get to the remote path.
 *
 *		ur_namei_pathp
 *		ur_namei_pathfunc
 *			A pointer to the remote path (in user space), and a
 *			function that returns the characters one at a time.
 *			The function is either uchar or schar.
 *		ur_namei_bufptr
 *			A pointer to a cache buffer which contains the
 *			path name to be parsed
 *
 *
 *
 *	The next two fields are used by the RFA server process.
 *
 *		ur_ids_pushed
 *			The server runs as super-user, but it needs to
 *			be able to do a setuid/setgid when operating on
 *			behalf of a particular user; it then needs to 
 *			return to being super-user so that it can handle
 *			other users.  setuid/setgid doesn't allow this.
 *			RFA creates two new system calls, pushids and popids.
 *			This flag is set by a pushids call, and cleared by
 *			a popids call.  This is simply to enforce that only
 *			the super user can use these new calls.
 *
 *		ur_failremote
 *			If non-zero, then namei will not set ur_wasremote
 *			when a remote path is given, so that the RFA code is
 *			not called.  This field is set by the RFA server,
 *			and inherited by all of its child processes.  Should
 *			never be set for any other process.
 */

#define NETUNAMS_PER_PROC 20

struct rfa_user
{

	struct rfa_procmem *ur_procmemp;

	struct rfa_inode *ur_rcdir;

	struct netunam *ur_netunam[NETUNAMS_PER_PROC];
	
	short	ur_wasremote;
	short	ur_namei_rwdir;
	dev_t	ur_namei_nsfdev;
	ino_t	ur_namei_nsfino;
	int	(*ur_namei_pathfunc)();
	char	*ur_namei_pathp;
	struct buf 	*ur_namei_bufptr;

	short	ur_ids_pushed;
	short	ur_failremote;
};
