/* HPUX_ID: @(#)signal.h	27.6     85/10/04  */

#ifndef	NSIG

#define	NSIG	24	/* NSIG is 1 greater than the highest defined signal */

#define	SIGHUP	1	/* hangup */
#define	SIGINT	2	/* interrupt */
#define	SIGQUIT	3	/* quit */
#define	SIGILL	4	/* illegal instruction (not reset when caught) */
/* CHME, CHMS, CHMU are not yet given back to users reasonably */
#define	SIGTRAP	5	/* trace trap (not reset when caught) */
#define	SIGIOT	6	/* IOT instruction */
#define	SIGEMT	7	/* EMT instruction */
#define	SIGFPE	8	/* floating point exception */
#define	SIGKILL	9	/* kill (cannot be caught or ignored) */
#define	SIGBUS	10	/* bus error */
#define	SIGSEGV	11	/* segmentation violation */
#define	SIGSYS	12	/* bad argument to system call */
#define	SIGPIPE	13	/* write on a pipe with no one to read it */
#define	SIGALRM	14	/* alarm clock */
#define	SIGTERM	15	/* software termination signal from kill */
#define	SIGUSR1	16	/* user defined signal 1 */
#define	SIGUSR2	17	/* user defined signal 2 */
#define	SIGCLD	18	/* death of a child */
#define	SIGPWR	19	/* power-fail restart */
#define	SIGVTALRM 20	/* virtual time alarm */
#define	SIGPROF	21	/* profiling time alarm */
#define	SIGIO	22	/* input/output possible signal */
#define	SIGWINDOW 23	/* window system signal */

#ifdef RT
#define	SIGQIT	3	/* quit */
#define	SIGTRC	5	/* trace trap (not reset when caught) */
#endif


int	(*signal())();

#define	KILL_ALL_OTHERS	0x7fff

/*
 * Signal vector "template" used in sigvector call.
 */
struct	sigvec {
	int	(*sv_handler)();	/* signal handler */
	int	sv_mask;		/* signal mask to apply */
	int	sv_onstack;		/* if non-zero, take on signal stack */
};

/*
 * Structure used in sigstack call.
 */
struct	sigstack {
	char	*ss_sp;			/* signal stack pointer */
	int	ss_onstack;		/* current status */
};

/*
 * Information pushed on stack when a signal is delivered.
 * This is used by the kernel to restore state following
 * execution of the signal handler.  It is also made available
 * to the handler to allow it to properly restore state if
 * a non-standard exit is performed.
 */
struct	sigcontext {
	int	sc_syscall;		/* interrupted system call if any */
	char    sc_syscall_action;      /* what to do after system call */
	char    sc_pad1;
	char    sc_pad2;
	char    sc_onstack;             /* sigstack state to restore */
	int	sc_mask;		/* signal mask to restore */
	int	sc_sp;			/* sp to restore */
	short	sc_ps;			/* ps to restore */
	int	sc_pc;			/* pc to retore */
};


#define	BADSIG		(int (*)())-1
#define	SIG_DFL		(int (*)())0
#ifdef	lint
#define	SIG_IGN		(int (*)())0
#else
#define	SIG_IGN		(int (*)())1
#endif


/* values for sc_syscall_action in sigcontext structure */
#define	SIG_RETURN	0
#define	SIG_RESTART	1

/* values for sc_syscall in sigcontext structure */
#define	SYS_NOTSYSCALL		0
#define	SYS_EXIT		1
#define	SYS_FORK		2
#define	SYS_READ		3
#define	SYS_WRITE		4
#define	SYS_OPEN		5
#define	SYS_CLOSE		6
#define	SYS_WAIT		7
#define	SYS_CREAT		8
#define	SYS_LINK		9
#define	SYS_UNLINK		10
#define	SYS_CHDIR		12
#define	SYS_TIME		13
#define	SYS_MKNOD		14
#define	SYS_CHMOD		15
#define	SYS_CHOWN		16
#define	SYS_BRK			17
#define	SYS_OSTAT		18
#define	SYS_LSEEK		19
#define	SYS_GETPID		20
#define	SYS_MOUNT		21
#define	SYS_UMOUNT		22
#define	SYS_SETUID		23
#define	SYS_GETUID		24
#define	SYS_STIME		25
#define	SYS_PTRACE		26
#define	SYS_ALARM		27
#define	SYS_OFSTAT		28
#define	SYS_PAUSE		29
#define	SYS_UTIME		30
#define	SYS_STTY		31
#define	SYS_GTTY		32
#define	SYS_ACCESS		33
#define	SYS_NICE		34
#define	SYS_FTIME		35
#define	SYS_SYNC		36
#define	SYS_KILL		37
#define	SYS_STAT		38
#define	SYS_SETPGRP		39
#define	SYS_LSTAT		40
#define	SYS_DUP			41
#define	SYS_PIPE		42
#define	SYS_TIMES		43
#define	SYS_PROFIL		44
#define	SYS_SETGID		46
#define	SYS_GETGID		47
#define	SYS_SIGNAL		48
#define	SYS_ACCT		51
#define	SYS_IOCTL		54
#define	SYS_SYMLINK		56
#define	SYS_UTSSYS		57
#define	SYS_READLINK		58
#define	SYS_EXEC		59
#define	SYS_UMASK		60
#define	SYS_CHROOT		61
#define	SYS_FCNTL		62
#define	SYS_ULIMIT		63
#define	SYS_VFORK		66
#define	SYS_GETGROUPS		79
#define	SYS_SETGROUPS		80
#define	SYS_SETITIMER		83
#define	SYS_GETITIMER		86
#define	SYS_DUP2		90
#define	SYS_FSTAT		92
#define	SYS_SELECT		93
#define	SYS_FSYNC		95
#define	SYS_SETPRIORITY		96
#define	SYS_GETPRIORITY		100
#define	SYS_SIGVECTOR		108
#define	SYS_SIGBLOCK		109
#define	SYS_SIGSETMASK		110
#define	SYS_SIGPAUSE		111
#define	SYS_SIGSPACE		112
#define	SYS_GETTIMEOFDAY	116
#define	SYS_READV		120
#define	SYS_WRITEV		121
#define	SYS_SETTIMEOFDAY	122
#define	SYS_FCHOWN		123
#define	SYS_FCHMOD		124
#define	SYS_TRUNCATE		129
#define	SYS_FTRUNCATE		130
#define	SYS_MKDIR		136
#define	SYS_RMDIR		137
#define	SYS_PRIVGRP		151
#define	SYS_RTPRIO		152
#define	SYS_PLOCK		153
#define	SYS_NETWORKING		154
#define	SYS_LOCKF		155
#define	SYS_SEMGET		156
#define	SYS_SEMCTL		157
#define	SYS_SEMOP		158
#define	SYS_MSGGET		159
#define	SYS_MSGCTL		160
#define	SYS_MSGSND		161
#define	SYS_MSGRCV		162
#define	SYS_SHMGET		163
#define	SYS_SHMCTL		164
#define	SYS_SHMAT		165
#define	SYS_SHMDT		166

#endif	not NSIG
