/* HPUX_ID: @(#)systm.h	27.5     85/06/27  */

/*
 * Random set of variables used by more than one routine.
 */


extern	int	lbolt;			/* awoken once a second */


extern	char	runin;		/* scheduling flag */
extern	char	runout;		/* scheduling flag */
extern	int	runrun;		/* scheduling flag */
extern	char	curpri;		/* more scheduling */


extern	int	maxmem;		/* actual max memory per process */
extern	int	physmem;	/* physical memory on this CPU */


int	nswap;		/* size of swap space */
dev_t	rootdev;	/* device of the root */
dev_t	swapdev;	/* swapping device */


extern char *panicstr;		/* panic string pointer */


daddr_t	bmap();
struct	inode *ialloc();
struct	inode *iget();
struct	inode *owner();
struct	inode *maknode();
struct	inode *namei();
struct	buf *alloc();
struct	buf *getblk();
struct	buf *geteblk();
struct	buf *bread();
struct	buf *breada();
struct	fs *getfs();
struct	file *getf();
struct	file *falloc();



/*
 * Structure of the system-entry table
 */
extern struct sysent
{
	int	sy_narg;		/* total number of arguments */
	int	(*sy_call)();		/* handler */
} sysent[];
extern struct sysent	compat_sysent[];
extern int		nsysent, ncompat_sysent;

extern	int	hand;		/* current index into coremap used by daemon */
extern	char version[];		/* system version */

/*
 * Nblkdev is the number of entries
 * (rows) in the block switch. It is
 * set in binit/bio.c by making
 * a pass over the switch.
 * Used in bounds checking on major
 * device numbers.
 */

extern int	nblkdev;

/*
 * Number of character switch entries.
 * Set by cinit/prim.c
 */

extern int	nchrdev;

int	nswdev;		/* number of swap devices */
int	mpid;		/* generic for unique process id's */
char	kmapwnt;	/* kernel map want flag */
int	updlock;	/* lock for sync */
daddr_t	rablock;	/* block to be read ahead */
int	rasize;		/* size of block in rablock */
extern	int intstack[];		/* stack for interrupts */


/* extern dev_t	dumpdev;	/* device to take dumps on */
/* extern long	dumplo;		/* offset into dumpdev */

extern	dev_t	argdev;		/* device for argument lists */

int	physmembase;		/* lowram page frame number CPU */
int	p1pages;		/* max # of pages per process */
caddr_t	usrstack;		/* logical address of user stack start */
caddr_t	user_area;		/* logical address of uarea */
caddr_t float_area;		/* logical address of float card start */
int	processor;		/* 68010, 68020 */

extern  int icode[];		/* user init code */

extern	int szicode;		/* size of user init code */
long    total_lockable_mem;     /* Maximum lockable memory, in clicks */
long    lockable_mem;           /* Current amount left, in clicks */
long	unlockable_mem;		/* Amount reserved from locking, in bytes */


caddr_t	calloc();
unsigned max();
unsigned min();
int	memall();
int	uchar(), schar();
int	vmemall();
caddr_t	wmemall();
swblk_t	vtod();
extern	int	noproc;		/* no one is running just now */
extern	int	wantin;
extern	int	boothowto;	/* reboot flags, from console subsystem */
extern	int	selwait;

extern	char vmmap[];		/* poor name! */


/* casts to keep lint happy */
#define	insque(q,p)	_insque((caddr_t)q,(caddr_t)p)
#define	remque(q)	_remque((caddr_t)q)
#define	queue(q,p)	_queue((caddr_t)q,(caddr_t)p)
#define	dequeue(q)	_dequeue((caddr_t)q)

/* float variable used globally */
int float_present;

