/* HPUX_ID: @(#)timeout.h	27.1     85/02/21  */
/* this defines the structure used for doing timeouts and delays.
   for KLEENIX compatibility on 4.2.
   The address of this structure is passed to timeout so
   that it can be used by untimeout.

   timeout is defined as Ktimeout to avoid conflict with the
   4.2 routine of the same name.
*/

#define timeout Ktimeout

struct timeout {
	long timeval;			/* timeout value */
	struct timeout *f_link;		/* forward link */
	struct timeout *b_link;		/* backward link */
	int (*proc)();			/* procedure to call if timed out */
	caddr_t arg;			/* argument to pass */
};

/* Software triggers usually are associated with timeouts */

/* This is used to provide 'software triggering' of interrupt service
   routines.  This structure is linked into a list of structures to be
   serviced on the way out of other ISR's.  This permits, for example,
   deferring the service of a timeout to a lower level, or having the
   top half of the character service stuff trigger the bottom half at
   a lower level */

struct sw_intloc {
	struct sw_intloc *link;		/* must be first */
	int (*proc)();			/* to call on trigger */
	caddr_t arg;			/* argument */
	char priority;			/* level of interrupt */
	char sub_priority;		/* sub-level of interrupt */
};
