/* HPUX_ID: @(#)tty.h	27.7     85/10/15  */
/*
 * A clist structure is the head of a linked list queue of characters.
 * The routines getc* and putc* manipulate these structures.
 */

struct clist {
	int	c_cc;		/* character count */
	struct cblock *c_cf;	/* pointer to first */
	struct cblock *c_cl;	/* pointer to last */
};


#define	NCC	8
/* new modem stuff */
#define	NMTIMERS	6
#define	LINE_CLEARED	0
#define	LINE_SET	1
#define	VALID_RING	HZ/2	/* 1/2 second for now */

#include <sys/timeout.h>

struct tty_driver {
	int	type;			/* Driver Number */
	int	(*open)();		/* open(dev, tp, flag) */
	int	(*close)();		/* close(dev, tp) */
	int	(*read)();		/* read(tp) */
	int	(*write)();		/* write(tp) */
	int	(*ioctl)();		/* ioctl(dev, tp, cmd, arg, mode) */
	int	(*select)();		/* select(tp) */
	int	(*kputchar)();		/* putchar(c); */
	int	(*wait)();		/* wait(tp); */
	struct tty * (*pwr_init)();	/* pwr_init(&tp, addr, id, il, &cs,
						&pci_total); */
	int	(*who_init)();		/* who_init(tp, tty_number, sc)
						For console tty_number == -1 */
	struct tty_driver *next;	/* Pointer to next one in list */
};

/*
 * A tty structure is needed for each UNIX character device that
 * is used for normal terminal IO.
 */

struct tty {
	struct	clist t_rawq;	/* raw input queue */
	struct	clist t_canq;	/* canonical queue */
	struct	clist t_outq;	/* output queue */
	struct cblock *t_buf;	/* buffer pointer */
	struct  timeout timeo;	/* for timouts/delays */
	int	(* t_proc)();	/* routine for device functions */
	struct	proc *t_rsel;	/* tty */
	struct	proc *t_wsel;	/* tty */
	ushort	t_iflag;	/* input modes */
	ushort	t_oflag;	/* output modes */
	ushort	t_cflag;	/* control modes */
	ushort	t_lflag;	/* line discipline modes */
	long	t_state;	/* internal state */
	short	t_pgrp;		/* process group name */
	char	t_line;		/* line discipline */
	char	t_delct;	/* delimiter count */
	char	t_col;		/* current column */
	char	t_row;		/* current row */
	int	t_slcnl;	/* shadow registers: line control */
	int	t_smcnl;	/*		     modem control */
	int	t_sicnl;	/* 		     interrupt control */
	unsigned char	t_cc[NCC];	/* settable control chars */
	char	*t_card_ptr;	/* Address of card */
	int	t_int_lvl;	/* Interrupt Level of the Card */
	struct tty_driver *t_drvtype;	/* Driver Type */
	ushort	*t_inbuf;	/* Input character buffer */
	ushort	*t_in_head;	/* Head of character queue */
	ushort	*t_in_tail;	/* Tail of character queue */
	ushort	t_in_count;	/* Number of characters in queue */
	char	t_int_flag;	/* More Flags */
	char	t_rcv_flag;	/* Pending interrupt for receive */
	char	t_xmt_flag;	/* Pending interrupt for transmit */
	char	t_open_type;	/* type of open that owns the card */
	struct sw_intloc rcv_intloc;	/* Software trigger receive structure */
	struct sw_intloc xmit_intloc;	/* Software trigger transmit structure */
	struct sw_intloc tttimeo_intloc; /* Software trigger ttimeo structure */
	struct sw_intloc ttrstrt_intloc; /* Software trigger ttstrt structure */
	int *utility;	/* driver dependent info */
	struct  timeout t_open;	/* for modem timeout stuff */
	struct  timeout t_DCD;	/* for modem timeout stuff */
	char	modem_status;	/* last state of modem input lines */
	char	tty_count;	/* keep number of direct opens */
	char	cul_count;	/* keep number of call out opens */
	char	ttyd_count;	/* keep number of call in opens */
	long	t_time;		/* Keep track of elasped time for RI */
	unsigned short	timers[NMTIMERS];  /* modem specific timers */
};

/* Minor device bits */
#define CCITT_MODE       0x0002
#define SIMPLE_MODE      0x0000
#define DEV_TTY          0x0004		/* direct connect */
#define DEV_CUL          0x0001		/* call out */
#define DEV_TTYD         0x0000		/* call in */

/*
 * The structure of a clist block
 */
#define	CBSIZE	26		/* number of chars in a clist block */

struct cblock {
	struct cblock *c_next;
	char	c_first;
	char	c_last;
	char	c_data[CBSIZE];
};



#define	TTIPRI	PZERO+3
#define	TTOPRI	PZERO+4


/* limits */
extern int ttlowat[], tthiwat[];
#define	TTYHOG	512	/* min(TTYHOG-TTXOHI,card_buffer_size) is the number of
			** character times that the 628 card can be locked out
			** by the kernel without dropping characters.
			*/

#define	PARAM_INT 	8	/* ran out of room when changing params */

#define	TTXOLO	60
#define	TTXOHI	180



/* Hardware bits */
#define	DONE	0200
#define	IENABLE	0100
#define	OVERRUN	040000
#define	FRERROR	020000
#define	PERROR	010000
#define	MODEMSTATUS 0100000

/* Internal state */
#define	TIMEOUT	0000000001		/* Delay timeout in progress */
#define	WOPEN	0000000002		/* Waiting for open to complete */
#define	ISOPEN	0000000004		/* Device is open */
#define TS_ISOPEN ISOPEN
#define	TBLOCK	0000000010
#define	CARR_ON	0000000020		/* Software copy of carrier-present */
#define	BUSY	0000000040		/* Output in progress */
#define	OASLP	0000000100		/* Wakeup when output done */
#define	IASLP	0000000200		/* Wakeup when input done */
#define	TTSTOP	0000000400		/* Output stopped by ctl-s */
#define ASYNC   0000001000              /* tty in async i/o mode */

#define	TACT	0000002000
#define ESC     0000004000              /* Last char escape */
#define	RTO	0000010000
#define	TTIOW	0000020000
#define	TTXON	0000040000
#define	TTXOFF	0000100000

#define	PDISLP		 0000200000	/* wakeup when pdi output queue empty */
#define	PDIOLCK		 0000400000   /* Disable pdi output during ioctl wait */
#define	RCOLL		 0001000000   /* collision in read select */
#define	WCOLL		 0002000000   /* collision in write select */
#define CCITT   	 0004000000   /* Device open for CCITT modem control */
#define SIMPLE  	 0010000000   /* Device open for Simple modem control */
#define TTYD    	 0020000000   /* Device open/pending for TTYD access */
#define CUL     	 0040000000   /* Device open/pending for CUL  access */
#define TTY     	 0100000000   /* Device open for TTY access */
#define TTYD_NDELAY 	 0200000000   /* Non-blocking TTYD open sleazed thru */
#define TTYD_PENDING 	 0400000000   /* CCITT ttyd open is pending */
#define WAIT_FOR_RING 	01000000000   /* CCITT ttyd open is waiting for ring */
#define OPEN_TO_PENDING 02000000000   /* Open timeout is pending */
#define OPEN_TIMED_OUT  04000000000   /* Open has timed out */
#define CARRIER_TO_PENDING 010000000000  /* Loss of carrier timeout pending */
#define DELTA_CLOCAL       020000000000  /* Loss of carrier timeout pending */
/* NO MORE BITS */

/* t_open_type */
#define TTY_OPEN       0x01  /* A direct connect dev has this open */
#define CUL_OPEN       0x02  /* A call out dev has this open */
#define TTYD_OPEN      0x04  /* A call in dev has this open */


/* l_output status */
#define	CPRES	1

/* device commands */
#define	T_OUTPUT	0
#define	T_TIME		1
#define	T_SUSPEND	2
#define	T_RESUME	3
#define	T_BLOCK		4
#define	T_UNBLOCK	5
#define	T_RFLUSH	6
#define	T_WFLUSH	7
#define	T_BREAK		8

#define T_PARM		11
#define T_MODEM_STAT	100
#define T_MODEM_CNTL	101


/*********************************************************************/
/* The following stuff should probably be in a different header file */

/* Supported TTY driver types */
#define	SIONULL		0	/* Dummy Driver for Run only system */
#define	SIO626		1	/* 98626 Driver */
#define	SIO628		2	/* 98628 Driver */
#define	SIO642		3	/* 98642 Driver */
#define	ITE200		4	/* Internal Terminal Emulator 9826/36/17 9920 */
#define	TTYDRIVS	5	/* Number of tty drivers possible */

/* Level Zero Interrupt Flags */
#define	PEND_TXINT	0x01	/* pending transfer interrupt */
#define	NMI_LCK		0x02	/* queuing routine is locked from NMI's */
#define	NMI_CNTL 	0x04	/* Control-Shift-PAUSE is pending from NMI */
#define	NMI_SHFT 	0x08	/* Shift-PAUSE is pending from NMI */
#define START_OF_RING 	0x10	/* Loss of carrier timeout pending */

#define	LINENO	0x1F		/* line number part of dev minor */
#define	TTYBUF_SIZE	256	/* Number of entries in TTY input buffer 
				** for delayed isr's
				*/
