/* HPUX_ID: @(#)user.h	27.6		85/10/11 */

#include <machine/pcb.h>
#include <sys/dmap.h>
#include <time.h>
#include <sys/resource.h>
#include <sys/privgrp.h>
#include <errno.h>		/* u_error codes */
#include <sys/rfa_user.h>
#include <a.out.h>

/*
 * Per process structure containing data that
 * isn't needed in core when the process is swapped out.
 */
 
#define	SHSIZE		32
#define	MAXCOMLEN	MAXNAMLEN
 
struct	user {
	struct	proc *u_procp;		/* pointer to proc structure */
	int	*u_ar0;			/* address of users saved R0 */
	char	u_comm[MAXNAMLEN + 1];

/* syscall parameters, results and catches */
	int	u_arg[8];		/* arguments to current system call */
	int	*u_ap;			/* pointer to arglist */
	label_t	u_qsave;		/* for non-local gotos on interrupts */
	u_char	u_error;		/* return error code */
	union {				/* syscall return values */
		struct	{
			int	R_val1;
			int	R_val2;
		} u_rv;
#define	r_val1	u_rv.R_val1
#define	r_val2	u_rv.R_val2

/* Bell-to-Berkeley translations */
#define u_rval1		u_r.r_val1
#define u_rval2		u_r.r_val2

		off_t	r_off;
		time_t	r_time;
	} u_r;
	char	u_eosys;		/* special action on end of syscall */
	u_char	u_syscall;		/* syscall # passed to signal handler */

/* 1.1 - processes and protection */
	u_short	u_uid;			/* effective user id */
	u_short	u_gid;			/* effective group id */
	int	u_groups[NGROUPS];	/* groups, 0 terminated */
	u_short	u_ruid;			/* real user id */
	u_short	u_rgid;			/* real group id */
	u_short	u_sgid;			/* set (effective) gid */
	u_int	u_priv[PRIV_MASKSIZ];	/* privlege mask */

/* 1.2 - memory management */
	size_t	u_tsize;		/* text size (clicks) */
	size_t	u_dsize;		/* data size (clicks) */
	size_t	u_ssize;		/* stack size (clicks) */
	long   	u_locksdsize;		/* locked stack+data size (clicks)*/
	struct	dmap u_dmap;		/* disk map for data segment */
	struct	dmap u_smap;		/* disk map for stack segment */
	struct	dmap u_cdmap, u_csmap;	/* shadows of u_dmap, u_smap, for
					   use of parent during fork */
	label_t u_ssave;		/* label variable for swapping */
	label_t u_rsave;		/* for exchanging stacks */
	label_t u_psave;		/* for probe simulation */
	size_t	u_odsize, u_ossize;	/* for (clumsy) expansion swaps */
	time_t	u_outime;		/* user time at last sample */
	short   u_flag;                 /* See u_flag values */
#define UF_MEMSIGL  0x00000001          /* Signal upon memory allocation
					 *  and process locked 
					 */

/* 1.3 - signal management */
	int	(*u_signal[NSIG-1])();	/* disposition of signals */
	int	u_sigmask[NSIG-1];	/* signals to be blocked */
	int	u_sigonstack;		/* signals to take on sigstack */
	int	u_oldmask;		/* saved mask from before sigpause */
	int	u_code;			/* ``code'' to trap */
	struct	sigstack u_sigstack;	/* sp & on stack state variable */
#define	u_onstack	u_sigstack.ss_onstack
#define	u_sigsp		u_sigstack.ss_sp
	int	u_sigcode[7];	  	/* signal "trampoline" code */

	size_t 	u_lockovh;		/* locked proc overhead size (clicks) */
					/* belongs with u_locksdsize */

/* 1.4 - descriptor management */
	struct	file *u_ofile[NOFILE];	/* file structures for open files */
	struct	file *u_fp;		/* current file pointer */
	char	u_pofile[NOFILE];	/* per-process flags of open files */
#define	UF_EXCLOSE 	0x1		/* auto-close on exec */
#define	UF_MAPPED 	0x2		/* mapped from device */
	struct	inode *u_cdir;		/* current directory */
	struct	inode *u_rdir;		/* root directory of current process */
	struct	tty *u_ttyp;		/* controlling tty pointer */
	dev_t	u_ttyd;			/* controlling tty dev */
	short	u_cmask;		/* mask for file creation */

/* 1.5 - timing and statistics */
	struct	rusage u_ru;		/* stats for this proc */
	struct	rusage u_cru;		/* sum of stats for reaped children */
	struct	itimerval u_timer[3];
	int	u_XXX[3];
	time_t	u_start;
	time_t	u_ticks;
	short	u_acflag;

/* 1.6 - resource controls */
	struct	rlimit u_rlimit[RLIM_NLIMITS];
	struct	quota *u_quota;		/* user's quota structure */
	int	u_qflags;		/* per process quota flags */

/* BEGIN TRASH */
	char	u_segflg;		/* 0:user D; 1:system; 2:user I */
	caddr_t	u_base;			/* base address for IO */
	unsigned int u_count;		/* bytes remaining for IO */
	off_t	u_offset;		/* offset in file for IO */

	union {
	   struct exec	Ux_A;
	   char ux_shell[SHSIZE];	/* #! and name of interpreter */
	} u_exdata;
#define	ux_mag		Ux_A.a_magic.file_type
#define	ux_system_id	Ux_A.a_magic.system_id
#define	ux_tsize	Ux_A.a_text
#define	ux_dsize	Ux_A.a_data
#define	ux_bsize	Ux_A.a_bss
#define	ux_entloc	Ux_A.a_entry



	caddr_t	u_dirp;			/* pathname pointer */
	struct	direct u_dent;		/* current directory entry */
	struct	inode *u_pdir;		/* inode of parent directory of dirp */
/* END TRASH */

	struct uprof {			/* profile arguments */
		short	*pr_base;	/* buffer base */
		unsigned pr_size;	/* buffer size */
		unsigned pr_off;	/* pc offset */
		unsigned pr_scale;	/* pc scaling */
	} u_prof;
	struct	rfa_user u_rfa;		/* for remote files */
	struct	pcb	u_pcb;		/* should be last except u_stack */
	int	u_stack[1];
};

/* u_eosys values */
#define	EOSYS_NOTSYSCALL	0	/* not in kernel via syscall() */
#define	EOSYS_NORMAL		1	/* in syscall but nothing notable */
#define	EOSYS_INTERRUPTED	2	/* signal is not yet fully processed */
#define	EOSYS_RESTART    	3	/* user has requested restart */
#define	EOSYS_NORESTART    	4	/* user has requested error return */
#define	RESTARTSYS		EOSYS_INTERRUPTED /* temporary!!! */


/* u_error codes */
#include <errno.h>		/* Traditional */


